/*
 * Decompiled with CFR 0.152.
 */
package org.drools.dynamic;

import java.time.Duration;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.drools.reflective.classloader.ProjectClassLoader;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ClassLoaderTest {
    private static final Duration TIMEOUT = Duration.ofSeconds(5L);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testParallelClassLoading() {
        Integer THREAD_COUNT = 100;
        ProjectClassLoader projectClassLoader = ProjectClassLoader.createProjectClassLoader();
        ClassLoader internalTypesClassLoader = (ClassLoader)projectClassLoader.makeClassLoader();
        projectClassLoader.setInternalClassLoader((ProjectClassLoader.InternalTypesClassLoader)internalTypesClassLoader);
        ExecutorService executorService = Executors.newFixedThreadPool(THREAD_COUNT);
        try {
            int i;
            ArrayList futures = new ArrayList();
            for (i = 0; i < THREAD_COUNT; ++i) {
                if (i % 2 == 0) {
                    futures.add(executorService.submit(() -> ClassLoaderTest.lambda$testParallelClassLoading$0((ClassLoader)projectClassLoader)));
                    continue;
                }
                futures.add(executorService.submit(() -> {
                    try {
                        Class.forName("nonexistant", true, internalTypesClassLoader);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                }));
            }
            for (i = 1; i <= THREAD_COUNT; ++i) {
                int threadId = i - 1;
                Assertions.assertTimeoutPreemptively((Duration)TIMEOUT, () -> {
                    try {
                        ((Future)futures.get(threadId)).get();
                    }
                    catch (InterruptedException | ExecutionException exception) {
                        // empty catch block
                    }
                }, (String)("Thread " + threadId + " did not finish in time."));
            }
        }
        finally {
            executorService.shutdownNow();
        }
    }

    private static /* synthetic */ void lambda$testParallelClassLoading$0(ClassLoader projectClassLoader) {
        try {
            Class.forName("nonexistant", true, projectClassLoader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

