/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.postgresql.storage;

import io.quarkus.hibernate.orm.panache.PanacheRepositoryBase;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.persistence.EntityManager;
import java.util.Optional;
import org.kie.kogito.index.model.ProcessDefinition;
import org.kie.kogito.index.postgresql.mapper.ProcessDefinitionEntityMapper;
import org.kie.kogito.index.postgresql.model.ProcessDefinitionEntity;
import org.kie.kogito.index.postgresql.model.ProcessDefinitionEntityId;
import org.kie.kogito.index.postgresql.model.ProcessDefinitionEntityRepository;
import org.kie.kogito.index.postgresql.storage.AbstractStorage;

@ApplicationScoped
public class ProcessDefinitionEntityStorage
extends AbstractStorage<ProcessDefinitionEntity, ProcessDefinition> {
    public ProcessDefinitionEntityStorage() {
    }

    @Inject
    public ProcessDefinitionEntityStorage(ProcessDefinitionEntityRepository repository, ProcessDefinitionEntityMapper mapper) {
        super(new RepositoryAdapter(repository), ProcessDefinition.class, ProcessDefinitionEntity.class, mapper::mapToModel, mapper::mapToEntity, e -> new ProcessDefinitionEntityId(e.getId(), e.getVersion()).getKey());
    }

    @Override
    public boolean containsKey(String key) {
        ProcessDefinitionEntityId id = new ProcessDefinitionEntityId(key);
        return this.getRepository().count("id = ?1 and version = ?2", new Object[]{id.getId(), id.getVersion()}) == 1L;
    }

    public static class RepositoryAdapter
    implements PanacheRepositoryBase<ProcessDefinitionEntity, String> {
        ProcessDefinitionEntityRepository repository;

        public RepositoryAdapter(ProcessDefinitionEntityRepository repository) {
            this.repository = repository;
        }

        public boolean deleteById(String key) {
            return this.repository.deleteById(new ProcessDefinitionEntityId(key));
        }

        public Optional<ProcessDefinitionEntity> findByIdOptional(String key) {
            return this.repository.findByIdOptional(new ProcessDefinitionEntityId(key));
        }

        public void persist(ProcessDefinitionEntity entity) {
            this.repository.persist(entity);
        }

        public EntityManager getEntityManager() {
            return this.repository.getEntityManager();
        }
    }
}

