/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.postgresql.storage;

import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusTest;
import jakarta.inject.Inject;
import jakarta.transaction.Transactional;
import java.util.UUID;
import org.apache.commons.lang3.RandomStringUtils;
import org.junit.jupiter.api.Test;
import org.kie.kogito.index.model.ProcessInstance;
import org.kie.kogito.index.model.ProcessInstanceState;
import org.kie.kogito.index.postgresql.model.ProcessInstanceEntity;
import org.kie.kogito.index.postgresql.model.ProcessInstanceEntityRepository;
import org.kie.kogito.index.postgresql.storage.AbstractStorageIT;
import org.kie.kogito.index.test.TestUtils;
import org.kie.kogito.persistence.api.StorageService;
import org.kie.kogito.testcontainers.quarkus.PostgreSqlQuarkusTestResource;

@QuarkusTest
@QuarkusTestResource(value=PostgreSqlQuarkusTestResource.class)
public class ProcessInstanceStorageIT
extends AbstractStorageIT<ProcessInstanceEntity, ProcessInstance> {
    @Inject
    ProcessInstanceEntityRepository repository;
    @Inject
    StorageService storage;

    public ProcessInstanceStorageIT() {
        super(ProcessInstance.class);
    }

    public ProcessInstanceEntityRepository getRepository() {
        return this.repository;
    }

    @Override
    public StorageService getStorage() {
        return this.storage;
    }

    @Test
    @Transactional
    public void testProcessInstanceEntity() {
        String processInstanceId = UUID.randomUUID().toString();
        ProcessInstance processInstance1 = TestUtils.createProcessInstance((String)processInstanceId, (String)RandomStringUtils.randomAlphabetic((int)5), (String)UUID.randomUUID().toString(), (String)RandomStringUtils.randomAlphabetic((int)10), (Integer)ProcessInstanceState.ACTIVE.ordinal(), (long)0L);
        ProcessInstance processInstance2 = TestUtils.createProcessInstance((String)processInstanceId, (String)RandomStringUtils.randomAlphabetic((int)5), (String)UUID.randomUUID().toString(), (String)RandomStringUtils.randomAlphabetic((int)10), (Integer)ProcessInstanceState.COMPLETED.ordinal(), (long)1000L);
        this.testStorage(processInstanceId, processInstance1, processInstance2);
    }
}

