/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.postgresql.storage;

import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusTest;
import jakarta.inject.Inject;
import jakarta.transaction.Transactional;
import java.util.Set;
import org.junit.jupiter.api.Test;
import org.kie.kogito.index.model.ProcessDefinition;
import org.kie.kogito.index.postgresql.model.ProcessDefinitionEntity;
import org.kie.kogito.index.postgresql.model.ProcessDefinitionEntityRepository;
import org.kie.kogito.index.postgresql.storage.AbstractStorageIT;
import org.kie.kogito.index.postgresql.storage.ProcessDefinitionEntityStorage;
import org.kie.kogito.index.test.TestUtils;
import org.kie.kogito.persistence.api.StorageService;
import org.kie.kogito.testcontainers.quarkus.PostgreSqlQuarkusTestResource;

@QuarkusTest
@QuarkusTestResource(value=PostgreSqlQuarkusTestResource.class)
class ProcessDefinitionStorageIT
extends AbstractStorageIT<ProcessDefinitionEntity, ProcessDefinition> {
    @Inject
    ProcessDefinitionEntityRepository repository;
    @Inject
    StorageService storage;

    public ProcessDefinitionStorageIT() {
        super(ProcessDefinition.class);
    }

    public ProcessDefinitionEntityStorage.RepositoryAdapter getRepository() {
        return new ProcessDefinitionEntityStorage.RepositoryAdapter(this.repository);
    }

    @Override
    public StorageService getStorage() {
        return this.storage;
    }

    @Test
    @Transactional
    void testProcessInstanceEntity() {
        String processId = "travels";
        String version = "1.0";
        ProcessDefinition pdv1 = TestUtils.createProcessDefinition((String)processId, (String)version, Set.of("admin", "kogito"));
        ProcessDefinition pdv2 = TestUtils.createProcessDefinition((String)processId, (String)version, Set.of("kogito"));
        this.testStorage(pdv1.getKey(), pdv1, pdv2);
    }
}

