/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.postgresql.storage;

import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusTest;
import jakarta.inject.Inject;
import jakarta.transaction.Transactional;
import java.util.UUID;
import org.apache.commons.lang3.RandomStringUtils;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.kogito.index.model.Job;
import org.kie.kogito.index.postgresql.model.JobEntity;
import org.kie.kogito.index.postgresql.model.JobEntityRepository;
import org.kie.kogito.index.postgresql.storage.AbstractStorageIT;
import org.kie.kogito.index.test.TestUtils;
import org.kie.kogito.persistence.api.StorageService;
import org.kie.kogito.testcontainers.quarkus.PostgreSqlQuarkusTestResource;

@QuarkusTest
@QuarkusTestResource(value=PostgreSqlQuarkusTestResource.class)
public class JobStorageIT
extends AbstractStorageIT<JobEntity, Job> {
    @Inject
    JobEntityRepository repository;
    @Inject
    StorageService storage;

    public JobStorageIT() {
        super(Job.class);
    }

    public JobEntityRepository getRepository() {
        return this.repository;
    }

    @Override
    public StorageService getStorage() {
        return this.storage;
    }

    @BeforeEach
    @Transactional
    public void setup() {
        this.repository.deleteAll();
    }

    @Test
    @Transactional
    public void testJobEntity() {
        String jobId = UUID.randomUUID().toString();
        String processInstanceId = UUID.randomUUID().toString();
        Job job1 = TestUtils.createJob((String)jobId, (String)processInstanceId, (String)RandomStringUtils.randomAlphabetic((int)5), (String)UUID.randomUUID().toString(), (String)RandomStringUtils.randomAlphabetic((int)10), (String)"EXPECTED", (long)0L);
        Job job2 = TestUtils.createJob((String)jobId, (String)processInstanceId, (String)RandomStringUtils.randomAlphabetic((int)5), (String)UUID.randomUUID().toString(), (String)RandomStringUtils.randomAlphabetic((int)10), (String)"SCHEDULED", (long)1000L);
        this.testStorage(jobId, job1, job2);
    }
}

