/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.postgresql.storage;

import io.quarkus.hibernate.orm.panache.PanacheRepositoryBase;
import org.assertj.core.api.Assertions;
import org.kie.kogito.index.postgresql.model.AbstractEntity;
import org.kie.kogito.persistence.api.Storage;
import org.kie.kogito.persistence.api.StorageService;

public abstract class AbstractStorageIT<E extends AbstractEntity, T> {
    Class<T> type;

    public AbstractStorageIT(Class<T> type) {
        this.type = type;
    }

    abstract StorageService getStorage();

    abstract PanacheRepositoryBase<E, String> getRepository();

    void testStorage(String key, T value1, T value2) {
        Storage cache = this.getStorage().getCache("cache", this.type);
        Assertions.assertThat((Object)cache.get((Object)key)).isNull();
        Assertions.assertThat((boolean)cache.containsKey((Object)key)).isFalse();
        Assertions.assertThat((long)this.getRepository().count()).isZero();
        cache.put((Object)key, value1);
        Assertions.assertThat((Object)cache.get((Object)key)).isEqualTo(value1);
        Assertions.assertThat((boolean)cache.containsKey((Object)key)).isTrue();
        Assertions.assertThat((long)this.getRepository().count()).isOne();
        cache.put((Object)key, value2);
        Assertions.assertThat((Object)cache.get((Object)key)).isEqualTo(value2);
        Assertions.assertThat((boolean)cache.containsKey((Object)key)).isTrue();
        Assertions.assertThat((long)this.getRepository().count()).isOne();
        cache.remove((Object)key);
        Assertions.assertThat((Object)cache.get((Object)key)).isNull();
        Assertions.assertThat((boolean)cache.containsKey((Object)key)).isFalse();
        Assertions.assertThat((long)this.getRepository().count()).isZero();
    }
}

