/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.postgresql.mapper;

import io.quarkus.test.junit.QuarkusTest;
import jakarta.inject.Inject;
import java.util.Collections;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.kogito.index.model.ProcessDefinition;
import org.kie.kogito.index.postgresql.mapper.ProcessDefinitionEntityMapper;
import org.kie.kogito.index.postgresql.model.ProcessDefinitionEntity;

@QuarkusTest
class ProcessDefinitionEntityMapperIT {
    ProcessDefinition pd = new ProcessDefinition();
    ProcessDefinitionEntity entity = new ProcessDefinitionEntity();
    @Inject
    ProcessDefinitionEntityMapper mapper;

    ProcessDefinitionEntityMapperIT() {
    }

    @BeforeEach
    void setup() {
        String version = "1.0";
        String processId = "testProcessId";
        Set<String> roles = Collections.singleton("testRoles");
        String type = "testType";
        Set<String> addons = Collections.singleton("testAddons");
        this.pd.setId(processId);
        this.pd.setVersion(version);
        this.pd.setRoles(roles);
        this.pd.setAddons(addons);
        this.pd.setType(type);
        this.entity.setId(processId);
        this.entity.setVersion(version);
        this.entity.setRoles(roles);
        this.entity.setAddons(addons);
        this.entity.setType(type);
    }

    @Test
    void testMapToEntity() {
        ProcessDefinitionEntity result = this.mapper.mapToEntity(this.pd);
        Assertions.assertThat((Object)result).usingRecursiveComparison().ignoringFieldsMatchingRegexes(new String[]{".*\\$\\$_hibernate_tracker"}).isEqualTo((Object)this.entity);
    }

    @Test
    void testMapToModel() {
        ProcessDefinition result = this.mapper.mapToModel(this.entity);
        Assertions.assertThat((Object)result).usingRecursiveComparison().isEqualTo((Object)this.pd);
    }
}

