/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.postgresql.mapper;

import io.quarkus.test.junit.QuarkusTest;
import jakarta.inject.Inject;
import java.time.ZonedDateTime;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.kogito.index.model.Job;
import org.kie.kogito.index.postgresql.mapper.JobEntityMapper;
import org.kie.kogito.index.postgresql.model.JobEntity;

@QuarkusTest
class JobEntityMapperIT {
    @Inject
    JobEntityMapper mapper;
    Job job = new Job();
    JobEntity jobEntity = new JobEntity();

    JobEntityMapperIT() {
    }

    @BeforeEach
    void setup() {
        String testId = "testId";
        ZonedDateTime time = ZonedDateTime.now();
        String status = "ACTIVE";
        String processId = "testProcessId";
        String processInstanceId = "testProcessInstanceId";
        String rootProcessId = "testRootProcessId";
        String rootProcessInstanceId = "testRootProcessInstanceId";
        Integer priority = 79;
        String callbackEndpoint = "testCallbackEndpoint";
        Long repeatInterval = 70L;
        Integer repeatLimit = 89;
        String scheduledId = "testScheduleId";
        Integer retries = 25;
        Integer executionCounter = 17;
        this.job.setId(testId);
        this.job.setStatus(status);
        this.job.setLastUpdate(time);
        this.job.setProcessId(processId);
        this.job.setProcessInstanceId(processInstanceId);
        this.job.setRootProcessId(rootProcessId);
        this.job.setRootProcessInstanceId(rootProcessInstanceId);
        this.job.setExpirationTime(time);
        this.job.setPriority(priority);
        this.job.setCallbackEndpoint(callbackEndpoint);
        this.job.setRepeatInterval(repeatInterval);
        this.job.setRepeatLimit(repeatLimit);
        this.job.setScheduledId(scheduledId);
        this.job.setRetries(retries);
        this.job.setExecutionCounter(executionCounter);
        this.jobEntity.setId(testId);
        this.jobEntity.setStatus(status);
        this.jobEntity.setLastUpdate(time);
        this.jobEntity.setProcessId(processId);
        this.jobEntity.setProcessInstanceId(processInstanceId);
        this.jobEntity.setRootProcessId(rootProcessId);
        this.jobEntity.setRootProcessInstanceId(rootProcessInstanceId);
        this.jobEntity.setExpirationTime(time);
        this.jobEntity.setPriority(priority);
        this.jobEntity.setCallbackEndpoint(callbackEndpoint);
        this.jobEntity.setRepeatInterval(repeatInterval);
        this.jobEntity.setRepeatLimit(repeatLimit);
        this.jobEntity.setScheduledId(scheduledId);
        this.jobEntity.setRetries(retries);
        this.jobEntity.setExecutionCounter(executionCounter);
    }

    @Test
    void testMapToEntity() {
        JobEntity result = this.mapper.mapToEntity(this.job);
        Assertions.assertThat((Object)result).isEqualToIgnoringGivenFields((Object)this.jobEntity, new String[]{"$$_hibernate_tracker"});
    }

    @Test
    void testMapToModel() {
        Job result = this.mapper.mapToModel(this.jobEntity);
        Assertions.assertThat((Object)result).isEqualToComparingFieldByField((Object)this.job);
    }
}

