/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.postgresql.schema;

import java.util.EnumSet;
import java.util.HashMap;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.MetadataSources;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.hibernate.tool.schema.TargetType;
import org.kie.kogito.index.postgresql.model.JobEntity;
import org.kie.kogito.index.postgresql.model.MilestoneEntity;
import org.kie.kogito.index.postgresql.model.NodeInstanceEntity;
import org.kie.kogito.index.postgresql.model.ProcessInstanceEntity;
import org.kie.kogito.index.postgresql.model.ProcessInstanceErrorEntity;
import org.kie.kogito.index.postgresql.model.UserTaskInstanceEntity;
import org.kie.kogito.testcontainers.KogitoPostgreSqlContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;

public class DDLSchemaExporter {
    public static void main(String[] args) {
        try (KogitoPostgreSqlContainer postgresql = new KogitoPostgreSqlContainer();){
            postgresql.waitingFor((WaitStrategy)Wait.forListeningPort());
            postgresql.start();
            HashMap<String, String> settings = new HashMap<String, String>();
            settings.put("hibernate.connection.url", postgresql.getJdbcUrl());
            settings.put("hibernate.connection.username", postgresql.getUsername());
            settings.put("hibernate.connection.password", postgresql.getPassword());
            StandardServiceRegistry serviceRegistry = new StandardServiceRegistryBuilder().applySettings(settings).build();
            MetadataSources metadataSources = new MetadataSources((ServiceRegistry)serviceRegistry);
            metadataSources.addAnnotatedClass(JobEntity.class);
            metadataSources.addAnnotatedClass(MilestoneEntity.class);
            metadataSources.addAnnotatedClass(NodeInstanceEntity.class);
            metadataSources.addAnnotatedClass(ProcessInstanceEntity.class);
            metadataSources.addAnnotatedClass(ProcessInstanceErrorEntity.class);
            metadataSources.addAnnotatedClass(UserTaskInstanceEntity.class);
            Metadata metadata = metadataSources.buildMetadata();
            SchemaExport schemaExport = new SchemaExport();
            schemaExport.setDelimiter(";");
            schemaExport.setFormat(true);
            schemaExport.setOutputFile("src/main/resources/create.sql");
            schemaExport.createOnly(EnumSet.of(TargetType.SCRIPT), metadata);
            schemaExport.getExceptions().forEach(System.err::println);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

