package org.kie.kogito.index.postgresql.mapper;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.Generated;
import javax.enterprise.context.ApplicationScoped;
import org.kie.kogito.index.model.Attachment;
import org.kie.kogito.index.model.Comment;
import org.kie.kogito.index.model.Comment.Builder;
import org.kie.kogito.index.model.UserTaskInstance;
import org.kie.kogito.index.postgresql.model.AttachmentEntity;
import org.kie.kogito.index.postgresql.model.CommentEntity;
import org.kie.kogito.index.postgresql.model.UserTaskInstanceEntity;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2023-11-10T12:57:51+0100",
    comments = "version: 1.4.2.Final, compiler: javac, environment: Java 11.0.20.1 (Eclipse Adoptium)"
)
@ApplicationScoped
public class UserTaskInstanceEntityMapperImpl implements UserTaskInstanceEntityMapper {

    @Override
    public UserTaskInstanceEntity mapToEntity(UserTaskInstance ut) {
        if ( ut == null ) {
            return null;
        }

        UserTaskInstanceEntity userTaskInstanceEntity = new UserTaskInstanceEntity();

        userTaskInstanceEntity.setId( ut.getId() );
        userTaskInstanceEntity.setDescription( ut.getDescription() );
        userTaskInstanceEntity.setName( ut.getName() );
        userTaskInstanceEntity.setPriority( ut.getPriority() );
        userTaskInstanceEntity.setProcessInstanceId( ut.getProcessInstanceId() );
        userTaskInstanceEntity.setState( ut.getState() );
        userTaskInstanceEntity.setActualOwner( ut.getActualOwner() );
        Set<String> set = ut.getAdminGroups();
        if ( set != null ) {
            userTaskInstanceEntity.setAdminGroups( new HashSet<String>( set ) );
        }
        Set<String> set1 = ut.getAdminUsers();
        if ( set1 != null ) {
            userTaskInstanceEntity.setAdminUsers( new HashSet<String>( set1 ) );
        }
        userTaskInstanceEntity.setCompleted( ut.getCompleted() );
        userTaskInstanceEntity.setStarted( ut.getStarted() );
        Set<String> set2 = ut.getExcludedUsers();
        if ( set2 != null ) {
            userTaskInstanceEntity.setExcludedUsers( new HashSet<String>( set2 ) );
        }
        Set<String> set3 = ut.getPotentialGroups();
        if ( set3 != null ) {
            userTaskInstanceEntity.setPotentialGroups( new HashSet<String>( set3 ) );
        }
        Set<String> set4 = ut.getPotentialUsers();
        if ( set4 != null ) {
            userTaskInstanceEntity.setPotentialUsers( new HashSet<String>( set4 ) );
        }
        userTaskInstanceEntity.setReferenceName( ut.getReferenceName() );
        userTaskInstanceEntity.setLastUpdate( ut.getLastUpdate() );
        userTaskInstanceEntity.setProcessId( ut.getProcessId() );
        userTaskInstanceEntity.setRootProcessId( ut.getRootProcessId() );
        userTaskInstanceEntity.setRootProcessInstanceId( ut.getRootProcessInstanceId() );
        userTaskInstanceEntity.setInputs( ut.getInputs() );
        userTaskInstanceEntity.setOutputs( ut.getOutputs() );
        userTaskInstanceEntity.setEndpoint( ut.getEndpoint() );
        userTaskInstanceEntity.setComments( commentListToCommentEntityList( ut.getComments() ) );
        userTaskInstanceEntity.setAttachments( attachmentListToAttachmentEntityList( ut.getAttachments() ) );

        afterMapping( userTaskInstanceEntity );

        return userTaskInstanceEntity;
    }

    @Override
    public UserTaskInstance mapToModel(UserTaskInstanceEntity ut) {
        if ( ut == null ) {
            return null;
        }

        UserTaskInstance userTaskInstance = new UserTaskInstance();

        userTaskInstance.setId( ut.getId() );
        userTaskInstance.setDescription( ut.getDescription() );
        userTaskInstance.setName( ut.getName() );
        userTaskInstance.setPriority( ut.getPriority() );
        userTaskInstance.setProcessInstanceId( ut.getProcessInstanceId() );
        userTaskInstance.setState( ut.getState() );
        userTaskInstance.setActualOwner( ut.getActualOwner() );
        Set<String> set = ut.getAdminGroups();
        if ( set != null ) {
            userTaskInstance.setAdminGroups( new HashSet<String>( set ) );
        }
        Set<String> set1 = ut.getAdminUsers();
        if ( set1 != null ) {
            userTaskInstance.setAdminUsers( new HashSet<String>( set1 ) );
        }
        userTaskInstance.setCompleted( ut.getCompleted() );
        userTaskInstance.setStarted( ut.getStarted() );
        Set<String> set2 = ut.getExcludedUsers();
        if ( set2 != null ) {
            userTaskInstance.setExcludedUsers( new HashSet<String>( set2 ) );
        }
        Set<String> set3 = ut.getPotentialGroups();
        if ( set3 != null ) {
            userTaskInstance.setPotentialGroups( new HashSet<String>( set3 ) );
        }
        Set<String> set4 = ut.getPotentialUsers();
        if ( set4 != null ) {
            userTaskInstance.setPotentialUsers( new HashSet<String>( set4 ) );
        }
        userTaskInstance.setReferenceName( ut.getReferenceName() );
        userTaskInstance.setLastUpdate( ut.getLastUpdate() );
        userTaskInstance.setComments( commentEntityListToCommentList( ut.getComments() ) );
        userTaskInstance.setAttachments( attachmentEntityListToAttachmentList( ut.getAttachments() ) );
        userTaskInstance.setProcessId( ut.getProcessId() );
        userTaskInstance.setRootProcessId( ut.getRootProcessId() );
        userTaskInstance.setEndpoint( ut.getEndpoint() );
        userTaskInstance.setRootProcessInstanceId( ut.getRootProcessInstanceId() );
        userTaskInstance.setInputs( ut.getInputs() );
        userTaskInstance.setOutputs( ut.getOutputs() );

        return userTaskInstance;
    }

    protected CommentEntity commentToCommentEntity(Comment comment) {
        if ( comment == null ) {
            return null;
        }

        CommentEntity commentEntity = new CommentEntity();

        commentEntity.setId( comment.getId() );
        commentEntity.setContent( comment.getContent() );
        commentEntity.setUpdatedBy( comment.getUpdatedBy() );
        commentEntity.setUpdatedAt( comment.getUpdatedAt() );

        return commentEntity;
    }

    protected List<CommentEntity> commentListToCommentEntityList(List<Comment> list) {
        if ( list == null ) {
            return null;
        }

        List<CommentEntity> list1 = new ArrayList<CommentEntity>( list.size() );
        for ( Comment comment : list ) {
            list1.add( commentToCommentEntity( comment ) );
        }

        return list1;
    }

    protected AttachmentEntity attachmentToAttachmentEntity(Attachment attachment) {
        if ( attachment == null ) {
            return null;
        }

        AttachmentEntity attachmentEntity = new AttachmentEntity();

        attachmentEntity.setId( attachment.getId() );
        attachmentEntity.setName( attachment.getName() );
        attachmentEntity.setContent( attachment.getContent() );
        attachmentEntity.setUpdatedBy( attachment.getUpdatedBy() );
        attachmentEntity.setUpdatedAt( attachment.getUpdatedAt() );

        return attachmentEntity;
    }

    protected List<AttachmentEntity> attachmentListToAttachmentEntityList(List<Attachment> list) {
        if ( list == null ) {
            return null;
        }

        List<AttachmentEntity> list1 = new ArrayList<AttachmentEntity>( list.size() );
        for ( Attachment attachment : list ) {
            list1.add( attachmentToAttachmentEntity( attachment ) );
        }

        return list1;
    }

    protected Comment commentEntityToComment(CommentEntity commentEntity) {
        if ( commentEntity == null ) {
            return null;
        }

        Builder comment = Comment.builder();

        comment.id( commentEntity.getId() );
        comment.content( commentEntity.getContent() );
        comment.updatedAt( commentEntity.getUpdatedAt() );
        comment.updatedBy( commentEntity.getUpdatedBy() );

        return comment.build();
    }

    protected List<Comment> commentEntityListToCommentList(List<CommentEntity> list) {
        if ( list == null ) {
            return null;
        }

        List<Comment> list1 = new ArrayList<Comment>( list.size() );
        for ( CommentEntity commentEntity : list ) {
            list1.add( commentEntityToComment( commentEntity ) );
        }

        return list1;
    }

    protected Attachment attachmentEntityToAttachment(AttachmentEntity attachmentEntity) {
        if ( attachmentEntity == null ) {
            return null;
        }

        org.kie.kogito.index.model.Attachment.Builder attachment = Attachment.builder();

        attachment.id( attachmentEntity.getId() );
        attachment.name( attachmentEntity.getName() );
        attachment.content( attachmentEntity.getContent() );
        attachment.updatedAt( attachmentEntity.getUpdatedAt() );
        attachment.updatedBy( attachmentEntity.getUpdatedBy() );

        return attachment.build();
    }

    protected List<Attachment> attachmentEntityListToAttachmentList(List<AttachmentEntity> list) {
        if ( list == null ) {
            return null;
        }

        List<Attachment> list1 = new ArrayList<Attachment>( list.size() );
        for ( AttachmentEntity attachmentEntity : list ) {
            list1.add( attachmentEntityToAttachment( attachmentEntity ) );
        }

        return list1;
    }
}
