package org.kie.kogito.index.postgresql.mapper;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.Generated;
import javax.enterprise.context.ApplicationScoped;
import org.kie.kogito.index.model.Milestone;
import org.kie.kogito.index.model.Milestone.Builder;
import org.kie.kogito.index.model.NodeInstance;
import org.kie.kogito.index.model.ProcessInstance;
import org.kie.kogito.index.model.ProcessInstanceError;
import org.kie.kogito.index.postgresql.model.MilestoneEntity;
import org.kie.kogito.index.postgresql.model.NodeInstanceEntity;
import org.kie.kogito.index.postgresql.model.ProcessInstanceEntity;
import org.kie.kogito.index.postgresql.model.ProcessInstanceErrorEntity;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2023-11-10T12:57:51+0100",
    comments = "version: 1.4.2.Final, compiler: javac, environment: Java 11.0.20.1 (Eclipse Adoptium)"
)
@ApplicationScoped
public class ProcessInstanceEntityMapperImpl implements ProcessInstanceEntityMapper {

    @Override
    public MilestoneEntity mapMilestoneToEntity(Milestone mi) {
        if ( mi == null ) {
            return null;
        }

        MilestoneEntity milestoneEntity = new MilestoneEntity();

        milestoneEntity.setId( mi.getId() );
        milestoneEntity.setName( mi.getName() );
        milestoneEntity.setStatus( mi.getStatus() );

        return milestoneEntity;
    }

    @Override
    public Milestone mapMilestoneToModel(MilestoneEntity pi) {
        if ( pi == null ) {
            return null;
        }

        Builder milestone = Milestone.builder();

        milestone.id( pi.getId() );
        milestone.name( pi.getName() );
        milestone.status( pi.getStatus() );

        return milestone.build();
    }

    @Override
    public ProcessInstanceEntity mapToEntity(ProcessInstance pi) {
        if ( pi == null ) {
            return null;
        }

        ProcessInstanceEntity processInstanceEntity = new ProcessInstanceEntity();

        processInstanceEntity.setId( pi.getId() );
        processInstanceEntity.setProcessId( pi.getProcessId() );
        processInstanceEntity.setProcessName( pi.getProcessName() );
        processInstanceEntity.setState( pi.getState() );
        processInstanceEntity.setBusinessKey( pi.getBusinessKey() );
        processInstanceEntity.setEndpoint( pi.getEndpoint() );
        Set<String> set = pi.getRoles();
        if ( set != null ) {
            processInstanceEntity.setRoles( new HashSet<String>( set ) );
        }
        processInstanceEntity.setStart( pi.getStart() );
        processInstanceEntity.setEnd( pi.getEnd() );
        processInstanceEntity.setRootProcessInstanceId( pi.getRootProcessInstanceId() );
        processInstanceEntity.setRootProcessId( pi.getRootProcessId() );
        processInstanceEntity.setParentProcessInstanceId( pi.getParentProcessInstanceId() );
        processInstanceEntity.setLastUpdate( pi.getLastUpdate() );
        processInstanceEntity.setVariables( pi.getVariables() );
        processInstanceEntity.setNodes( nodeInstanceListToNodeInstanceEntityList( pi.getNodes() ) );
        processInstanceEntity.setMilestones( milestoneListToMilestoneEntityList( pi.getMilestones() ) );
        Set<String> set1 = pi.getAddons();
        if ( set1 != null ) {
            processInstanceEntity.setAddons( new HashSet<String>( set1 ) );
        }
        processInstanceEntity.setError( processInstanceErrorToProcessInstanceErrorEntity( pi.getError() ) );

        afterMapping( processInstanceEntity );

        return processInstanceEntity;
    }

    @Override
    public ProcessInstance mapToModel(ProcessInstanceEntity pi) {
        if ( pi == null ) {
            return null;
        }

        ProcessInstance processInstance = new ProcessInstance();

        processInstance.setId( pi.getId() );
        processInstance.setProcessId( pi.getProcessId() );
        processInstance.setEndpoint( pi.getEndpoint() );
        processInstance.setState( pi.getState() );
        processInstance.setBusinessKey( pi.getBusinessKey() );
        Set<String> set = pi.getRoles();
        if ( set != null ) {
            processInstance.setRoles( new HashSet<String>( set ) );
        }
        processInstance.setStart( pi.getStart() );
        processInstance.setEnd( pi.getEnd() );
        processInstance.setRootProcessInstanceId( pi.getRootProcessInstanceId() );
        processInstance.setRootProcessId( pi.getRootProcessId() );
        processInstance.setParentProcessInstanceId( pi.getParentProcessInstanceId() );
        processInstance.setProcessName( pi.getProcessName() );
        processInstance.setLastUpdate( pi.getLastUpdate() );
        processInstance.setVariables( pi.getVariables() );
        processInstance.setNodes( nodeInstanceEntityListToNodeInstanceList( pi.getNodes() ) );
        processInstance.setError( processInstanceErrorEntityToProcessInstanceError( pi.getError() ) );
        Set<String> set1 = pi.getAddons();
        if ( set1 != null ) {
            processInstance.setAddons( new HashSet<String>( set1 ) );
        }
        processInstance.setMilestones( milestoneEntityListToMilestoneList( pi.getMilestones() ) );

        return processInstance;
    }

    protected NodeInstanceEntity nodeInstanceToNodeInstanceEntity(NodeInstance nodeInstance) {
        if ( nodeInstance == null ) {
            return null;
        }

        NodeInstanceEntity nodeInstanceEntity = new NodeInstanceEntity();

        nodeInstanceEntity.setId( nodeInstance.getId() );
        nodeInstanceEntity.setName( nodeInstance.getName() );
        nodeInstanceEntity.setNodeId( nodeInstance.getNodeId() );
        nodeInstanceEntity.setType( nodeInstance.getType() );
        nodeInstanceEntity.setDefinitionId( nodeInstance.getDefinitionId() );
        nodeInstanceEntity.setEnter( nodeInstance.getEnter() );
        nodeInstanceEntity.setExit( nodeInstance.getExit() );

        return nodeInstanceEntity;
    }

    protected List<NodeInstanceEntity> nodeInstanceListToNodeInstanceEntityList(List<NodeInstance> list) {
        if ( list == null ) {
            return null;
        }

        List<NodeInstanceEntity> list1 = new ArrayList<NodeInstanceEntity>( list.size() );
        for ( NodeInstance nodeInstance : list ) {
            list1.add( nodeInstanceToNodeInstanceEntity( nodeInstance ) );
        }

        return list1;
    }

    protected List<MilestoneEntity> milestoneListToMilestoneEntityList(List<Milestone> list) {
        if ( list == null ) {
            return null;
        }

        List<MilestoneEntity> list1 = new ArrayList<MilestoneEntity>( list.size() );
        for ( Milestone milestone : list ) {
            list1.add( mapMilestoneToEntity( milestone ) );
        }

        return list1;
    }

    protected ProcessInstanceErrorEntity processInstanceErrorToProcessInstanceErrorEntity(ProcessInstanceError processInstanceError) {
        if ( processInstanceError == null ) {
            return null;
        }

        ProcessInstanceErrorEntity processInstanceErrorEntity = new ProcessInstanceErrorEntity();

        processInstanceErrorEntity.setNodeDefinitionId( processInstanceError.getNodeDefinitionId() );
        processInstanceErrorEntity.setMessage( processInstanceError.getMessage() );

        return processInstanceErrorEntity;
    }

    protected NodeInstance nodeInstanceEntityToNodeInstance(NodeInstanceEntity nodeInstanceEntity) {
        if ( nodeInstanceEntity == null ) {
            return null;
        }

        NodeInstance nodeInstance = new NodeInstance();

        nodeInstance.setName( nodeInstanceEntity.getName() );
        nodeInstance.setType( nodeInstanceEntity.getType() );
        nodeInstance.setDefinitionId( nodeInstanceEntity.getDefinitionId() );
        nodeInstance.setId( nodeInstanceEntity.getId() );
        nodeInstance.setEnter( nodeInstanceEntity.getEnter() );
        nodeInstance.setExit( nodeInstanceEntity.getExit() );
        nodeInstance.setNodeId( nodeInstanceEntity.getNodeId() );

        return nodeInstance;
    }

    protected List<NodeInstance> nodeInstanceEntityListToNodeInstanceList(List<NodeInstanceEntity> list) {
        if ( list == null ) {
            return null;
        }

        List<NodeInstance> list1 = new ArrayList<NodeInstance>( list.size() );
        for ( NodeInstanceEntity nodeInstanceEntity : list ) {
            list1.add( nodeInstanceEntityToNodeInstance( nodeInstanceEntity ) );
        }

        return list1;
    }

    protected ProcessInstanceError processInstanceErrorEntityToProcessInstanceError(ProcessInstanceErrorEntity processInstanceErrorEntity) {
        if ( processInstanceErrorEntity == null ) {
            return null;
        }

        ProcessInstanceError processInstanceError = new ProcessInstanceError();

        processInstanceError.setNodeDefinitionId( processInstanceErrorEntity.getNodeDefinitionId() );
        processInstanceError.setMessage( processInstanceErrorEntity.getMessage() );

        return processInstanceError;
    }

    protected List<Milestone> milestoneEntityListToMilestoneList(List<MilestoneEntity> list) {
        if ( list == null ) {
            return null;
        }

        List<Milestone> list1 = new ArrayList<Milestone>( list.size() );
        for ( MilestoneEntity milestoneEntity : list ) {
            list1.add( mapMilestoneToModel( milestoneEntity ) );
        }

        return list1;
    }
}
