/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.postgresql.mapper;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.quarkus.test.junit.QuarkusTest;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.Set;
import javax.inject.Inject;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.kogito.index.model.Milestone;
import org.kie.kogito.index.model.NodeInstance;
import org.kie.kogito.index.model.ProcessInstance;
import org.kie.kogito.index.model.ProcessInstanceError;
import org.kie.kogito.index.postgresql.mapper.ProcessInstanceEntityMapper;
import org.kie.kogito.index.postgresql.model.MilestoneEntity;
import org.kie.kogito.index.postgresql.model.MilestoneEntityId;
import org.kie.kogito.index.postgresql.model.NodeInstanceEntity;
import org.kie.kogito.index.postgresql.model.ProcessInstanceEntity;
import org.kie.kogito.index.postgresql.model.ProcessInstanceErrorEntity;

@QuarkusTest
class ProcessInstanceEntityMapperIT {
    ObjectMapper jsonMapper = new ObjectMapper();
    ProcessInstance processInstance = new ProcessInstance();
    ProcessInstanceEntity processInstanceEntity = new ProcessInstanceEntity();
    @Inject
    ProcessInstanceEntityMapper mapper;

    ProcessInstanceEntityMapperIT() {
    }

    @BeforeEach
    void setup() {
        String nodeInstanceId = "testNodeInstanceId";
        String nodeInstanceName = "testNodeInstanceName";
        String nodeInstanceNodeId = "testNodeInstanceNodeId";
        String nodeInstanceType = "testNodeInstanceType";
        String nodeInstanceDefinitionId = "testNodeInstanceDefinitionId";
        String processInstanceErrorMessage = "testProcessInstanceErrorMessage";
        String processInstanceErrorNodeDefinitionId = "testProcessInstanceErrorNodeDefinitionId";
        String milestoneId = "testMilestone";
        String milestoneName = "testMilestoneName";
        String milestoneStatus = "testMilestoneStatus";
        String testId = "testId";
        String processId = "testProcessId";
        Set<String> roles = Collections.singleton("testRoles");
        ObjectNode variables = this.jsonMapper.createObjectNode();
        variables.put("test", "testValue");
        String endpoint = "testEndpoint";
        Integer state = 2;
        ZonedDateTime time = ZonedDateTime.now();
        String rootProcessId = "testRootProcessId";
        String rootProcessInstanceId = "testRootProcessInstanceId";
        String parentProcessInstanceId = "testParentProcessInstanceId";
        String processName = "testProcessName";
        Set<String> addons = Collections.singleton("testAddons");
        String businessKey = "testBusinessKey";
        NodeInstance nodeInstance = new NodeInstance();
        nodeInstance.setId(nodeInstanceId);
        nodeInstance.setDefinitionId(nodeInstanceDefinitionId);
        nodeInstance.setExit(time);
        nodeInstance.setEnter(time);
        nodeInstance.setType(nodeInstanceType);
        nodeInstance.setNodeId(nodeInstanceNodeId);
        nodeInstance.setName(nodeInstanceName);
        ProcessInstanceError processInstanceError = new ProcessInstanceError();
        processInstanceError.setMessage(processInstanceErrorMessage);
        processInstanceError.setNodeDefinitionId(processInstanceErrorNodeDefinitionId);
        Milestone milestone = new Milestone();
        milestone.setId(milestoneId);
        milestone.setName(milestoneName);
        milestone.setStatus(milestoneStatus);
        this.processInstance.setId(testId);
        this.processInstance.setProcessId(processId);
        this.processInstance.setRoles(roles);
        this.processInstance.setVariables(variables);
        this.processInstance.setEndpoint(endpoint);
        this.processInstance.setNodes(Collections.singletonList(nodeInstance));
        this.processInstance.setState(state);
        this.processInstance.setStart(time);
        this.processInstance.setEnd(time);
        this.processInstance.setRootProcessId(rootProcessId);
        this.processInstance.setRootProcessInstanceId(rootProcessInstanceId);
        this.processInstance.setParentProcessInstanceId(parentProcessInstanceId);
        this.processInstance.setProcessName(processName);
        this.processInstance.setError(processInstanceError);
        this.processInstance.setAddons(addons);
        this.processInstance.setLastUpdate(time);
        this.processInstance.setBusinessKey(businessKey);
        this.processInstance.setMilestones(Collections.singletonList(milestone));
        NodeInstanceEntity nodeInstanceEntity = new NodeInstanceEntity();
        nodeInstanceEntity.setId(nodeInstanceId);
        nodeInstanceEntity.setDefinitionId(nodeInstanceDefinitionId);
        nodeInstanceEntity.setEnter(time);
        nodeInstanceEntity.setExit(time);
        nodeInstanceEntity.setName(nodeInstanceName);
        nodeInstanceEntity.setNodeId(nodeInstanceNodeId);
        nodeInstanceEntity.setType(nodeInstanceType);
        nodeInstanceEntity.setProcessInstance(this.processInstanceEntity);
        ProcessInstanceErrorEntity processInstanceErrorEntity = new ProcessInstanceErrorEntity();
        processInstanceErrorEntity.setMessage(processInstanceErrorMessage);
        processInstanceErrorEntity.setNodeDefinitionId(processInstanceErrorNodeDefinitionId);
        MilestoneEntity milestoneEntity = new MilestoneEntity();
        MilestoneEntityId milestoneEntityId = new MilestoneEntityId();
        milestoneEntityId.setId(milestoneId);
        milestoneEntityId.setProcessInstance(testId);
        milestoneEntity.setId(milestoneId);
        milestoneEntity.setName(milestoneName);
        milestoneEntity.setStatus(milestoneStatus);
        milestoneEntity.setProcessInstance(this.processInstanceEntity);
        this.processInstanceEntity.setId(testId);
        this.processInstanceEntity.setProcessId(processId);
        this.processInstanceEntity.setRoles(roles);
        this.processInstanceEntity.setVariables(variables);
        this.processInstanceEntity.setEndpoint(endpoint);
        this.processInstanceEntity.setNodes(Collections.singletonList(nodeInstanceEntity));
        this.processInstanceEntity.setState(state);
        this.processInstanceEntity.setStart(time);
        this.processInstanceEntity.setEnd(time);
        this.processInstanceEntity.setRootProcessId(rootProcessId);
        this.processInstanceEntity.setRootProcessInstanceId(rootProcessInstanceId);
        this.processInstanceEntity.setParentProcessInstanceId(parentProcessInstanceId);
        this.processInstanceEntity.setProcessName(processName);
        this.processInstanceEntity.setError(processInstanceErrorEntity);
        this.processInstanceEntity.setAddons(addons);
        this.processInstanceEntity.setLastUpdate(time);
        this.processInstanceEntity.setBusinessKey(businessKey);
        this.processInstanceEntity.setMilestones(Collections.singletonList(milestoneEntity));
    }

    @Test
    void testMapToEntity() {
        ProcessInstanceEntity result = this.mapper.mapToEntity(this.processInstance);
        Assertions.assertThat((Object)result).usingRecursiveComparison().ignoringFieldsMatchingRegexes(new String[]{".*\\$\\$_hibernate_tracker"}).isEqualTo((Object)this.processInstanceEntity);
    }

    @Test
    void testMapToModel() {
        ProcessInstance result = this.mapper.mapToModel(this.processInstanceEntity);
        Assertions.assertThat((Object)result).usingRecursiveComparison().isEqualTo((Object)this.processInstance);
    }
}

