/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.postgresql.storage;

import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusTest;
import java.util.UUID;
import javax.inject.Inject;
import javax.transaction.Transactional;
import org.apache.commons.lang3.RandomStringUtils;
import org.junit.jupiter.api.Test;
import org.kie.kogito.index.model.UserTaskInstance;
import org.kie.kogito.index.postgresql.model.UserTaskInstanceEntity;
import org.kie.kogito.index.postgresql.model.UserTaskInstanceEntityRepository;
import org.kie.kogito.index.postgresql.storage.AbstractStorageIT;
import org.kie.kogito.index.test.TestUtils;
import org.kie.kogito.persistence.api.StorageService;
import org.kie.kogito.testcontainers.quarkus.PostgreSqlQuarkusTestResource;

@QuarkusTest
@QuarkusTestResource(value=PostgreSqlQuarkusTestResource.class)
public class UserTaskInstanceStorageIT
extends AbstractStorageIT<UserTaskInstanceEntity, UserTaskInstance> {
    @Inject
    UserTaskInstanceEntityRepository repository;
    @Inject
    StorageService storage;

    public UserTaskInstanceStorageIT() {
        super(UserTaskInstance.class);
    }

    @Override
    public StorageService getStorage() {
        return this.storage;
    }

    public UserTaskInstanceEntityRepository getRepository() {
        return this.repository;
    }

    @Test
    @Transactional
    public void testUserTaskInstanceEntity() {
        String taskId = UUID.randomUUID().toString();
        String processInstanceId = UUID.randomUUID().toString();
        UserTaskInstance userTaskInstance1 = TestUtils.createUserTaskInstance((String)taskId, (String)processInstanceId, (String)RandomStringUtils.randomAlphabetic((int)5), (String)UUID.randomUUID().toString(), (String)RandomStringUtils.randomAlphabetic((int)10), (String)"InProgress", (long)0L);
        UserTaskInstance userTaskInstance2 = TestUtils.createUserTaskInstance((String)taskId, (String)processInstanceId, (String)RandomStringUtils.randomAlphabetic((int)5), (String)UUID.randomUUID().toString(), (String)RandomStringUtils.randomAlphabetic((int)10), (String)"Completed", (long)1000L);
        this.testStorage(taskId, userTaskInstance1, userTaskInstance2);
    }
}

