/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.postgresql.storage;

import io.quarkus.hibernate.orm.panache.PanacheRepositoryBase;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.kie.kogito.index.model.ProcessInstance;
import org.kie.kogito.index.postgresql.model.ProcessInstanceEntity;
import org.kie.kogito.index.postgresql.storage.PostgreSqlQuery;
import org.kie.kogito.persistence.api.query.QueryFilterFactory;
import org.kie.kogito.persistence.api.query.SortDirection;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;

@ExtendWith(value={MockitoExtension.class})
class DomainQueryTest {
    private static final Class rootType = ProcessInstanceEntity.class;
    @Mock
    PanacheRepositoryBase<ProcessInstance, String> repository;
    @Mock
    EntityManager entityManager;
    @Mock
    CriteriaBuilder criteriaBuilder;
    @Mock
    CriteriaQuery criteriaQuery;
    @Mock
    TypedQuery mockQuery;

    DomainQueryTest() {
    }

    @BeforeEach
    public void setup() {
        Mockito.when((Object)this.repository.getEntityManager()).thenReturn((Object)this.entityManager);
        Mockito.when((Object)this.entityManager.getCriteriaBuilder()).thenReturn((Object)this.criteriaBuilder);
        Mockito.when((Object)this.criteriaBuilder.createQuery(rootType)).thenReturn((Object)this.criteriaQuery);
        Mockito.when((Object)this.entityManager.createQuery(this.criteriaQuery)).thenReturn((Object)this.mockQuery);
    }

    @Test
    void testNoParameters() {
        PostgreSqlQuery query = new PostgreSqlQuery(this.repository, Function.identity(), rootType);
        query.execute();
        ((CriteriaQuery)Mockito.verify((Object)this.criteriaQuery)).from(rootType);
        ((CriteriaQuery)Mockito.verify((Object)this.criteriaQuery, (VerificationMode)Mockito.never())).where((Expression)ArgumentMatchers.any(Predicate.class));
        ((CriteriaQuery)Mockito.verify((Object)this.criteriaQuery, (VerificationMode)Mockito.never())).orderBy((List)ArgumentMatchers.any(List.class));
        ((EntityManager)Mockito.verify((Object)this.entityManager)).createQuery(this.criteriaQuery);
        ((TypedQuery)Mockito.verify((Object)this.mockQuery)).getResultList();
    }

    @Test
    void testEmptyParameters() {
        PostgreSqlQuery query = new PostgreSqlQuery(this.repository, Function.identity(), rootType);
        query.filter(Collections.emptyList());
        query.sort(Collections.emptyList());
        query.execute();
        ((CriteriaQuery)Mockito.verify((Object)this.criteriaQuery)).from(rootType);
        ((CriteriaQuery)Mockito.verify((Object)this.criteriaQuery, (VerificationMode)Mockito.never())).where((Expression)ArgumentMatchers.any(Predicate.class));
        ((CriteriaQuery)Mockito.verify((Object)this.criteriaQuery, (VerificationMode)Mockito.never())).orderBy((List)ArgumentMatchers.any(List.class));
        ((EntityManager)Mockito.verify((Object)this.entityManager)).createQuery(this.criteriaQuery);
        ((TypedQuery)Mockito.verify((Object)this.mockQuery)).getResultList();
    }

    @Test
    void testPagination() {
        PostgreSqlQuery query = new PostgreSqlQuery(this.repository, Function.identity(), rootType);
        query.limit(Integer.valueOf(10));
        query.offset(Integer.valueOf(0));
        query.execute();
        ((CriteriaQuery)Mockito.verify((Object)this.criteriaQuery)).from(rootType);
        ((CriteriaQuery)Mockito.verify((Object)this.criteriaQuery, (VerificationMode)Mockito.never())).where((Expression)ArgumentMatchers.any(Predicate.class));
        ((CriteriaQuery)Mockito.verify((Object)this.criteriaQuery, (VerificationMode)Mockito.never())).orderBy((List)ArgumentMatchers.any(List.class));
        ((EntityManager)Mockito.verify((Object)this.entityManager)).createQuery(this.criteriaQuery);
        ((TypedQuery)Mockito.verify((Object)this.mockQuery)).setFirstResult(0);
        ((TypedQuery)Mockito.verify((Object)this.mockQuery)).setMaxResults(10);
        ((TypedQuery)Mockito.verify((Object)this.mockQuery)).getResultList();
    }

    @Test
    void testOrderBy() {
        Root root = (Root)Mockito.mock(Root.class);
        Mockito.when((Object)root.get((String)ArgumentMatchers.any(String.class))).thenAnswer(inv -> {
            Path path = (Path)Mockito.mock(Path.class);
            Mockito.when((Object)path.getAlias()).thenReturn((Object)((String)inv.getArgument(0)));
            return path;
        });
        Mockito.when((Object)this.criteriaQuery.from(rootType)).thenReturn((Object)root);
        Mockito.when((Object)this.criteriaBuilder.asc((Expression)ArgumentMatchers.any())).thenAnswer(inv -> {
            Order order = (Order)Mockito.mock(Order.class);
            Mockito.when((Object)order.isAscending()).thenReturn((Object)true);
            Mockito.when((Object)order.getExpression()).thenReturn((Object)((Expression)inv.getArgument(0)));
            return order;
        });
        Mockito.when((Object)this.criteriaBuilder.desc((Expression)ArgumentMatchers.any())).thenAnswer(inv -> {
            Order order = (Order)Mockito.mock(Order.class);
            Mockito.when((Object)order.isAscending()).thenReturn((Object)false);
            Mockito.when((Object)order.getExpression()).thenReturn((Object)((Expression)inv.getArgument(0)));
            return order;
        });
        PostgreSqlQuery query = new PostgreSqlQuery(this.repository, Function.identity(), rootType);
        query.sort(Arrays.asList(QueryFilterFactory.orderBy((String)"name", (SortDirection)SortDirection.DESC), QueryFilterFactory.orderBy((String)"date", (SortDirection)SortDirection.ASC)));
        query.execute();
        ((CriteriaQuery)Mockito.verify((Object)this.criteriaQuery)).from(rootType);
        ((CriteriaQuery)Mockito.verify((Object)this.criteriaQuery, (VerificationMode)Mockito.never())).where((Expression)ArgumentMatchers.any(Predicate.class));
        ArgumentCaptor captor = ArgumentCaptor.forClass(List.class);
        ((CriteriaQuery)Mockito.verify((Object)this.criteriaQuery)).orderBy((List)captor.capture());
        Assertions.assertThat((List)((List)captor.getValue())).hasSize(2);
        Assertions.assertThat((boolean)((Order)((List)captor.getValue()).get(0)).isAscending()).isFalse();
        Assertions.assertThat((String)((Order)((List)captor.getValue()).get(0)).getExpression().getAlias()).isEqualTo("name");
        Assertions.assertThat((boolean)((Order)((List)captor.getValue()).get(1)).isAscending()).isTrue();
        Assertions.assertThat((String)((Order)((List)captor.getValue()).get(1)).getExpression().getAlias()).isEqualTo("date");
        ((EntityManager)Mockito.verify((Object)this.entityManager)).createQuery(this.criteriaQuery);
        ((TypedQuery)Mockito.verify((Object)this.mockQuery)).getResultList();
    }
}

