/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.postgresql.reporting.database;

import javax.persistence.EntityManager;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.kie.kogito.index.postgresql.model.JobEntityRepository;
import org.kie.kogito.index.postgresql.model.ProcessInstanceEntityRepository;
import org.kie.kogito.index.postgresql.model.UserTaskInstanceEntityRepository;
import org.kie.kogito.index.postgresql.reporting.database.PostgresDataIndexDatabaseManagerImpl;
import org.kie.kogito.persistence.postgresql.reporting.database.sqlbuilders.PostgresApplyMappingSqlBuilder;
import org.kie.kogito.persistence.postgresql.reporting.database.sqlbuilders.PostgresIndexesSqlBuilder;
import org.kie.kogito.persistence.postgresql.reporting.database.sqlbuilders.PostgresTableSqlBuilder;
import org.kie.kogito.persistence.postgresql.reporting.database.sqlbuilders.PostgresTriggerDeleteSqlBuilder;
import org.kie.kogito.persistence.postgresql.reporting.database.sqlbuilders.PostgresTriggerInsertSqlBuilder;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class PostgresDataIndexDatabaseManagerImplTest {
    @Mock
    private ProcessInstanceEntityRepository processInstanceEntityRepository;
    @Mock
    private UserTaskInstanceEntityRepository userTaskInstanceEntityRepository;
    @Mock
    private JobEntityRepository jobEntityRepository;
    @Mock
    private EntityManager entityManager;
    private PostgresDataIndexDatabaseManagerImpl manager;

    PostgresDataIndexDatabaseManagerImplTest() {
    }

    @BeforeEach
    void setup() {
        this.manager = new PostgresDataIndexDatabaseManagerImpl(this.processInstanceEntityRepository, this.userTaskInstanceEntityRepository, this.jobEntityRepository, new PostgresIndexesSqlBuilder(), new PostgresTableSqlBuilder(), new PostgresTriggerDeleteSqlBuilder(), new PostgresTriggerInsertSqlBuilder(), new PostgresApplyMappingSqlBuilder());
    }

    @Test
    void testGetEntityManager_Processes() {
        Mockito.when((Object)this.processInstanceEntityRepository.getEntityManager()).thenReturn((Object)this.entityManager);
        Assertions.assertEquals((Object)this.entityManager, (Object)this.manager.getEntityManager("processes"));
    }

    @Test
    void testGetEntityManager_UserTasks() {
        Mockito.when((Object)this.userTaskInstanceEntityRepository.getEntityManager()).thenReturn((Object)this.entityManager);
        Assertions.assertEquals((Object)this.entityManager, (Object)this.manager.getEntityManager("tasks"));
    }

    @Test
    void testGetEntityManager_Jobs() {
        Mockito.when((Object)this.jobEntityRepository.getEntityManager()).thenReturn((Object)this.entityManager);
        Assertions.assertEquals((Object)this.entityManager, (Object)this.manager.getEntityManager("jobs"));
    }

    @Test
    void testGetEntityManager_Unknown() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.manager.getEntityManager("unknown"));
    }
}

