/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.postgresql.reporting;

import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusTest;
import java.util.List;
import javax.inject.Inject;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityResult;
import javax.persistence.FieldResult;
import javax.persistence.Id;
import javax.persistence.SqlResultSetMapping;
import javax.transaction.Transactional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.kogito.index.model.ProcessInstance;
import org.kie.kogito.index.postgresql.model.ProcessInstanceEntityRepository;
import org.kie.kogito.index.postgresql.storage.PostgreSqlStorageService;
import org.kie.kogito.index.test.TestUtils;
import org.kie.kogito.persistence.api.Storage;
import org.kie.kogito.testcontainers.quarkus.PostgreSqlQuarkusTestResource;

@QuarkusTest
@QuarkusTestResource(value=PostgreSqlQuarkusTestResource.class)
class ProcessInstanceVariableMappingIT {
    private static final String CACHE_NAME = "processes";
    private static final Class<ProcessInstance> CACHE_TYPE = ProcessInstance.class;
    private static final String SQL = "SELECT id, firstName,lastName FROM ProcessInstanceVariableExtract";
    @Inject
    PostgreSqlStorageService storageService;
    @Inject
    ProcessInstanceEntityRepository repository;

    ProcessInstanceVariableMappingIT() {
    }

    @BeforeEach
    @Transactional
    public void setup() {
        this.storageService.getCache(CACHE_NAME, CACHE_TYPE).clear();
    }

    @Test
    @Transactional
    void testProcessInstanceVariableMapping() {
        Storage cache = this.storageService.getCache(CACHE_NAME, CACHE_TYPE);
        ProcessInstance pi0 = TestUtils.createProcessInstance((String)"pi0", (String)"process0", (String)"rootProcessInstanceId", (String)"rootProcessId", (Integer)1, (long)0L, (String)"Michael", (String)"Anstis");
        ProcessInstance pi1 = TestUtils.createProcessInstance((String)"pi1", (String)"process0", (String)"rootProcessInstanceId", (String)"rootProcessId", (Integer)1, (long)0L, (String)"Keith", (String)"Flint");
        cache.put((Object)pi0.getId(), (Object)pi0);
        cache.put((Object)pi1.getId(), (Object)pi1);
        List results = this.repository.getEntityManager().createNativeQuery(SQL, "ProcessInstanceVariableMappingMapping").getResultList();
        Assertions.assertThat((List)results).hasSize(2);
        ProcessInstanceVariableExtract row0 = (ProcessInstanceVariableExtract)results.get(0);
        org.junit.jupiter.api.Assertions.assertEquals((Object)pi0.getId(), (Object)row0.id);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Michael", (Object)row0.firstName);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Anstis", (Object)row0.lastName);
        ProcessInstanceVariableExtract row1 = (ProcessInstanceVariableExtract)results.get(1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)pi1.getId(), (Object)row1.id);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Keith", (Object)row1.firstName);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Flint", (Object)row1.lastName);
    }

    @Test
    @Transactional
    void testProcessInstanceVariableMapping_Partitioned() {
        Storage cache = this.storageService.getCache(CACHE_NAME, CACHE_TYPE);
        ProcessInstance pi0 = TestUtils.createProcessInstance((String)"pi0", (String)"process0", (String)"rootProcessInstanceId", (String)"rootProcessId", (Integer)1, (long)0L, (String)"Michael", (String)"Anstis");
        ProcessInstance pi1 = TestUtils.createProcessInstance((String)"pi1", (String)"process1", (String)"rootProcessInstanceId", (String)"rootProcessId", (Integer)1, (long)0L, (String)"Keith", (String)"Flint");
        cache.put((Object)pi0.getId(), (Object)pi0);
        cache.put((Object)pi1.getId(), (Object)pi1);
        List results = this.repository.getEntityManager().createNativeQuery(SQL, "ProcessInstanceVariableMappingMapping").getResultList();
        Assertions.assertThat((List)results).hasSize(1);
        ProcessInstanceVariableExtract row0 = (ProcessInstanceVariableExtract)results.get(0);
        org.junit.jupiter.api.Assertions.assertEquals((Object)pi0.getId(), (Object)row0.id);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Michael", (Object)row0.firstName);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Anstis", (Object)row0.lastName);
    }

    @Entity
    @SqlResultSetMapping(name="ProcessInstanceVariableMappingMapping", entities={@EntityResult(entityClass=ProcessInstanceVariableExtract.class, fields={@FieldResult(name="id", column="id"), @FieldResult(name="firstName", column="firstName"), @FieldResult(name="lastName", column="lastName")})})
    public static class ProcessInstanceVariableExtract {
        @Id
        @Column(nullable=false)
        private String id;
        @Column
        private String firstName;
        @Column
        private String lastName;
    }
}

