/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.postgresql.reporting.database;

import java.util.Locale;
import java.util.Objects;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import org.kie.kogito.index.postgresql.model.JobEntityRepository;
import org.kie.kogito.index.postgresql.model.ProcessInstanceEntityRepository;
import org.kie.kogito.index.postgresql.model.UserTaskInstanceEntityRepository;
import org.kie.kogito.persistence.postgresql.reporting.database.BasePostgresDatabaseManagerImpl;
import org.kie.kogito.persistence.postgresql.reporting.database.sqlbuilders.PostgresIndexesSqlBuilder;
import org.kie.kogito.persistence.postgresql.reporting.database.sqlbuilders.PostgresTableSqlBuilder;
import org.kie.kogito.persistence.postgresql.reporting.database.sqlbuilders.PostgresTriggerDeleteSqlBuilder;
import org.kie.kogito.persistence.postgresql.reporting.database.sqlbuilders.PostgresTriggerInsertSqlBuilder;

@ApplicationScoped
public class PostgresDataIndexDatabaseManagerImpl
extends BasePostgresDatabaseManagerImpl {
    private ProcessInstanceEntityRepository processInstanceEntityRepository;
    private UserTaskInstanceEntityRepository userTaskInstanceEntityRepository;
    private JobEntityRepository jobEntityRepository;

    protected PostgresDataIndexDatabaseManagerImpl() {
    }

    @Inject
    public PostgresDataIndexDatabaseManagerImpl(ProcessInstanceEntityRepository processInstanceEntityRepository, UserTaskInstanceEntityRepository userTaskInstanceEntityRepository, JobEntityRepository jobEntityRepository, PostgresIndexesSqlBuilder indexesSqlBuilder, PostgresTableSqlBuilder tableSqlBuilder, PostgresTriggerDeleteSqlBuilder triggerDeleteSqlBuilder, PostgresTriggerInsertSqlBuilder triggerInsertSqlBuilder) {
        super(indexesSqlBuilder, tableSqlBuilder, triggerDeleteSqlBuilder, triggerInsertSqlBuilder);
        this.processInstanceEntityRepository = Objects.requireNonNull(processInstanceEntityRepository);
        this.userTaskInstanceEntityRepository = Objects.requireNonNull(userTaskInstanceEntityRepository);
        this.jobEntityRepository = Objects.requireNonNull(jobEntityRepository);
    }

    protected EntityManager getEntityManager(String sourceTableName) {
        switch (sourceTableName.toLowerCase(Locale.ROOT)) {
            case "processes": {
                return this.processInstanceEntityRepository.getEntityManager();
            }
            case "tasks": {
                return this.userTaskInstanceEntityRepository.getEntityManager();
            }
            case "jobs": {
                return this.jobEntityRepository.getEntityManager();
            }
        }
        throw new IllegalArgumentException(String.format("There is no repository defined for '%s'.", sourceTableName));
    }
}

