/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.graphql;

import graphql.language.StringValue;
import graphql.schema.CoercingSerializeException;
import java.time.ZonedDateTime;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.index.graphql.PostgreSqlDateTimeCoercing;

public class PostgreSqlDateTimeCoercingTest {
    PostgreSqlDateTimeCoercing dateTimeCoercing = new PostgreSqlDateTimeCoercing();

    @Test
    public void testParseValueAsZonedDateTime() {
        Assertions.assertThat((Object)this.dateTimeCoercing.parseValue(null)).isNull();
        Assertions.assertThat((Object)this.dateTimeCoercing.parseValue((Object)"2019-11-20T03:14:03.075Z")).isEqualTo((Object)ZonedDateTime.parse("2019-11-20T03:14:03.075Z"));
    }

    @Test
    public void testParseLiteral() {
        Assertions.assertThat((Object)this.dateTimeCoercing.parseLiteral(null)).isNull();
        Assertions.assertThat((Object)this.dateTimeCoercing.parseLiteral((Object)new StringValue("2019-11-20T03:14:03.075Z"))).isEqualTo((Object)ZonedDateTime.parse("2019-11-20T03:14:03.075Z"));
    }

    @Test
    public void testSerializeInvalidString() {
        try {
            this.dateTimeCoercing.serialize((Object)"test");
            Assertions.fail((String)"Method should throw CoercingSerializeException");
        }
        catch (CoercingSerializeException ex) {
            Assertions.assertThat((String)ex.getMessage()).isEqualTo("Invalid ISO-8601 value : 'test'. because of : 'Text 'test' could not be parsed at index 0'");
        }
    }

    @Test
    public void testSerializeNull() {
        try {
            this.dateTimeCoercing.serialize(null);
            Assertions.fail((String)"Method should throw CoercingSerializeException");
        }
        catch (CoercingSerializeException ex) {
            Assertions.assertThat((String)ex.getMessage()).isEqualTo("Expected something we can convert to 'java.time.ZonedDateTime' but was 'null'.");
        }
    }

    @Test
    public void testSerializeInvalidType() {
        try {
            this.dateTimeCoercing.serialize((Object)1);
            Assertions.fail((String)"Method should throw CoercingSerializeException");
        }
        catch (CoercingSerializeException ex) {
            Assertions.assertThat((String)ex.getMessage()).isEqualTo("Expected something we can convert to 'java.time.ZonedDateTime' but was 'java.lang.Integer'.");
        }
    }

    @Test
    public void testSerializeString() {
        String result = this.dateTimeCoercing.serialize((Object)"2019-08-20T19:26:02.092+00:00");
        Assertions.assertThat((String)result).isEqualTo("2019-08-20T19:26:02.092Z");
    }
}

