/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.drools.scorecard.model;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.pmml.PMML4Result;
import org.kie.pmml.api.enums.MINING_FUNCTION;
import org.kie.pmml.api.enums.RESULT_FEATURE;
import org.kie.pmml.commons.model.KiePMMLOutputField;
import org.kie.pmml.models.drools.scorecard.model.KiePMMLScorecardModel;

public class KiePMMLScorecardModelTest {
    private static final String MODEL_NAME = "SCORE_MODEL";
    private KiePMMLScorecardModel model;
    private List<KiePMMLOutputField> outputFields;
    private Map<String, Object> outputFieldsMap;

    @Before
    public void setup() {
        this.outputFields = this.getOutputFields();
        this.outputFieldsMap = this.getOutputFieldsMap();
    }

    @Test
    public void populateWithOutputFieldsNoOutputFields() {
        this.model = (KiePMMLScorecardModel)KiePMMLScorecardModel.builder((String)MODEL_NAME, Collections.emptyList(), (MINING_FUNCTION)MINING_FUNCTION.REGRESSION).build();
        PMML4Result toPopulate = new PMML4Result();
        this.model.populateWithOutputFields(toPopulate);
        Assert.assertTrue((boolean)toPopulate.getResultVariables().isEmpty());
        this.model = (KiePMMLScorecardModel)KiePMMLScorecardModel.builder((String)MODEL_NAME, Collections.emptyList(), (MINING_FUNCTION)MINING_FUNCTION.REGRESSION).withOutputFields(Collections.emptyList()).build();
        toPopulate = new PMML4Result();
        this.model.populateWithOutputFields(toPopulate);
        Assert.assertTrue((boolean)toPopulate.getResultVariables().isEmpty());
    }

    @Test
    public void populateWithOutputFieldsNoOutputFieldsMap() {
        this.model = (KiePMMLScorecardModel)KiePMMLScorecardModel.builder((String)MODEL_NAME, Collections.emptyList(), (MINING_FUNCTION)MINING_FUNCTION.REGRESSION).withOutputFields(this.outputFields).build();
        PMML4Result toPopulate = new PMML4Result();
        this.model.populateWithOutputFields(toPopulate);
        Assert.assertFalse((boolean)toPopulate.getResultVariables().isEmpty());
        for (KiePMMLOutputField outputField : this.outputFields) {
            Assert.assertTrue((boolean)toPopulate.getResultVariables().containsKey(outputField.getName()));
            Assert.assertNull(toPopulate.getResultVariables().get(outputField.getName()));
        }
        this.model = (KiePMMLScorecardModel)KiePMMLScorecardModel.builder((String)MODEL_NAME, Collections.emptyList(), (MINING_FUNCTION)MINING_FUNCTION.REGRESSION).withOutputFields(this.outputFields).withOutputFieldsMap(Collections.emptyMap()).build();
        toPopulate = new PMML4Result();
        this.model.populateWithOutputFields(toPopulate);
        Assert.assertFalse((boolean)toPopulate.getResultVariables().isEmpty());
        for (KiePMMLOutputField outputField : this.outputFields) {
            Assert.assertTrue((boolean)toPopulate.getResultVariables().containsKey(outputField.getName()));
            Assert.assertNull(toPopulate.getResultVariables().get(outputField.getName()));
        }
    }

    @Test
    public void populateWithOutputFields() {
        this.model = (KiePMMLScorecardModel)KiePMMLScorecardModel.builder((String)MODEL_NAME, Collections.emptyList(), (MINING_FUNCTION)MINING_FUNCTION.REGRESSION).withOutputFields(this.outputFields).withOutputFieldsMap(this.outputFieldsMap).build();
        PMML4Result toPopulate = new PMML4Result();
        this.model.populateWithOutputFields(toPopulate);
        Assert.assertFalse((boolean)toPopulate.getResultVariables().isEmpty());
        for (int i = this.outputFields.size() - 1; i == 0; --i) {
            KiePMMLOutputField outputField = this.outputFields.get(i);
            Assert.assertTrue((boolean)toPopulate.getResultVariables().containsKey(outputField.getName()));
            Assert.assertEquals((Object)("REASON_CODE_" + i), toPopulate.getResultVariables().get(outputField.getName()));
        }
    }

    private List<KiePMMLOutputField> getOutputFields() {
        return IntStream.range(1, 4).mapToObj(value -> (KiePMMLOutputField)KiePMMLOutputField.builder((String)("RANK-" + value), Collections.emptyList()).withRank(Integer.valueOf(value)).withResultFeature(RESULT_FEATURE.REASON_CODE).build()).collect(Collectors.toList());
    }

    private Map<String, Object> getOutputFieldsMap() {
        return IntStream.range(1, 4).boxed().collect(Collectors.toMap(index -> "REASON_CODE_" + index, Integer::doubleValue));
    }
}

