/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.drools.utils;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.data.Offset;
import org.drools.core.command.runtime.SetGlobalCommand;
import org.drools.core.command.runtime.rule.InsertObjectCommand;
import org.drools.core.impl.KnowledgeBaseImpl;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.command.Command;
import org.kie.api.pmml.PMML4Result;
import org.kie.api.runtime.StatelessKieSession;
import org.kie.pmml.models.drools.executor.KiePMMLStatusHolder;
import org.kie.pmml.models.drools.utils.KiePMMLSessionUtils;

public class KiePMMLSessionUtilsTest {
    private static final KieBase KIE_BASE = new KnowledgeBaseImpl("PMML", null);
    private static final String MODEL_NAME = "MODELNAME";
    private static final PMML4Result PMML4_RESULT = new PMML4Result();
    private KiePMMLSessionUtils.Builder builder;
    private KiePMMLSessionUtils kiePMMLSessionUtils;

    @Before
    public void setup() {
        this.builder = KiePMMLSessionUtils.builder((KieBase)KIE_BASE, (String)MODEL_NAME, (String)"PACKAGE_NAME", (PMML4Result)PMML4_RESULT);
        this.kiePMMLSessionUtils = this.builder.build();
    }

    @Test
    public void builder() {
        Assertions.assertThat((Object)this.builder).isNotNull();
        Assertions.assertThat((Object)this.kiePMMLSessionUtils).isNotNull();
    }

    @Test
    public void kiePMMLSessionUtils() {
        List retrieved = this.kiePMMLSessionUtils.commands;
        Assertions.assertThat((List)retrieved).isNotNull();
        Assertions.assertThat((List)retrieved).hasSize(3);
        Assertions.assertThat((Object)((Command)retrieved.get(0))).isInstanceOf(InsertObjectCommand.class);
        InsertObjectCommand insertObjectCommand = (InsertObjectCommand)retrieved.get(0);
        Assertions.assertThat((String)insertObjectCommand.getEntryPoint()).isEqualTo("DEFAULT");
        Assertions.assertThat((Object)insertObjectCommand.getObject()).isNotNull();
        Assertions.assertThat((Object)insertObjectCommand.getObject()).isInstanceOf(KiePMMLStatusHolder.class);
        KiePMMLStatusHolder kiePMMLStatusHolder = (KiePMMLStatusHolder)insertObjectCommand.getObject();
        Assertions.assertThat((double)kiePMMLStatusHolder.getAccumulator()).isCloseTo(0.0, Offset.offset((Number)0.0));
        Assertions.assertThat((String)kiePMMLStatusHolder.getStatus()).isNull();
        Assertions.assertThat((Object)((Command)retrieved.get(1))).isInstanceOf(InsertObjectCommand.class);
        insertObjectCommand = (InsertObjectCommand)retrieved.get(1);
        Assertions.assertThat((String)insertObjectCommand.getEntryPoint()).isEqualTo("DEFAULT");
        Assertions.assertThat((Object)insertObjectCommand.getObject()).isNotNull();
        Assertions.assertThat((Object)insertObjectCommand.getObject()).isInstanceOf(PMML4Result.class);
        Assertions.assertThat((Object)insertObjectCommand.getObject()).isEqualTo((Object)PMML4_RESULT);
        Assertions.assertThat((Object)((Command)retrieved.get(2))).isInstanceOf(SetGlobalCommand.class);
        SetGlobalCommand setGlobalCommand = (SetGlobalCommand)retrieved.get(2);
        Assertions.assertThat((String)setGlobalCommand.getIdentifier()).isEqualTo("$pmml4Result");
        Assertions.assertThat((Object)setGlobalCommand.getObject()).isInstanceOf(PMML4Result.class);
        Assertions.assertThat((Object)setGlobalCommand.getObject()).isEqualTo((Object)PMML4_RESULT);
    }

    @Test
    public void getKieSession() {
        StatelessKieSession retrieved = this.kiePMMLSessionUtils.getKieSession(KIE_BASE);
        Assertions.assertThat((Object)retrieved).isNotNull();
    }

    @Test
    public void insertObjectInSession() {
        List retrieved = this.kiePMMLSessionUtils.commands;
        Assertions.assertThat((List)retrieved).isNotNull();
        Assertions.assertThat((List)retrieved).hasSize(3);
        String toInsert = "TO_INSERT";
        String globalName = "GLOBAL_NAME";
        this.kiePMMLSessionUtils.insertObjectInSession((Object)toInsert, "GLOBAL_NAME");
        Assertions.assertThat((List)retrieved).hasSize(5);
        Assertions.assertThat((Object)((Command)retrieved.get(3))).isInstanceOf(InsertObjectCommand.class);
        InsertObjectCommand insertObjectCommand = (InsertObjectCommand)retrieved.get(3);
        Assertions.assertThat((String)insertObjectCommand.getEntryPoint()).isEqualTo("DEFAULT");
        Assertions.assertThat((Object)insertObjectCommand.getObject()).isNotNull();
        Assertions.assertThat((Object)insertObjectCommand.getObject()).isEqualTo((Object)toInsert);
        Assertions.assertThat((Object)((Command)retrieved.get(4))).isInstanceOf(SetGlobalCommand.class);
        SetGlobalCommand setGlobalCommand = (SetGlobalCommand)retrieved.get(4);
        Assertions.assertThat((String)setGlobalCommand.getIdentifier()).isEqualTo("GLOBAL_NAME");
        Assertions.assertThat((Object)setGlobalCommand.getObject()).isEqualTo((Object)toInsert);
    }
}

