/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.drools.commons.factories;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.IntStream;
import org.assertj.core.api.Assertions;
import org.drools.compiler.lang.api.DescrFactory;
import org.drools.compiler.lang.api.PackageDescrBuilder;
import org.drools.compiler.lang.descr.PackageDescr;
import org.drools.compiler.lang.descr.TypeDeclarationDescr;
import org.drools.compiler.lang.descr.TypeFieldDescr;
import org.junit.Before;
import org.junit.Test;
import org.kie.pmml.models.drools.ast.KiePMMLDroolsType;
import org.kie.pmml.models.drools.commons.factories.KiePMMLDescrTestUtils;
import org.kie.pmml.models.drools.commons.factories.KiePMMLDescrTypesFactory;

public class KiePMMLDescrTypesFactoryTest {
    private PackageDescrBuilder builder;

    @Before
    public void setUp() throws Exception {
        this.builder = DescrFactory.newPackage().name("PACKAGE_NAME");
    }

    @Test
    public void declareTypes() {
        ArrayList<KiePMMLDroolsType> types = new ArrayList<KiePMMLDroolsType>();
        types.add(KiePMMLDescrTestUtils.getDroolsType());
        types.add(KiePMMLDescrTestUtils.getDottedDroolsType());
        Assertions.assertThat((List)((PackageDescr)this.builder.getDescr()).getTypeDeclarations()).isEmpty();
        KiePMMLDescrTypesFactory.factory((PackageDescrBuilder)this.builder).declareTypes(types);
        Assertions.assertThat((List)((PackageDescr)this.builder.getDescr()).getTypeDeclarations()).hasSize(2);
        IntStream.range(0, types.size()).forEach(i -> this.commonVerifyTypeDeclarationDescr(Objects.requireNonNull((KiePMMLDroolsType)types.get(i)), (TypeDeclarationDescr)((PackageDescr)this.builder.getDescr()).getTypeDeclarations().get(i)));
    }

    @Test
    public void declareType() {
        KiePMMLDroolsType type = KiePMMLDescrTestUtils.getDroolsType();
        KiePMMLDescrTypesFactory.factory((PackageDescrBuilder)this.builder).declareType(type);
        Assertions.assertThat((List)((PackageDescr)this.builder.getDescr()).getTypeDeclarations()).hasSize(1);
        this.commonVerifyTypeDeclarationDescr(type, (TypeDeclarationDescr)((PackageDescr)this.builder.getDescr()).getTypeDeclarations().get(0));
    }

    private void commonVerifyTypeDeclarationDescr(KiePMMLDroolsType type, TypeDeclarationDescr typeDeclarationDescr) {
        String expectedGeneratedType = type.getName();
        String expectedMappedOriginalType = type.getType();
        Assertions.assertThat((String)typeDeclarationDescr.getTypeName()).isEqualTo(expectedGeneratedType);
        Assertions.assertThat((Map)typeDeclarationDescr.getFields()).hasSize(1);
        Assertions.assertThat((Map)typeDeclarationDescr.getFields()).containsKey((Object)"value");
        Assertions.assertThat((String)((TypeFieldDescr)typeDeclarationDescr.getFields().get("value")).getPattern().getObjectType()).isEqualTo(expectedMappedOriginalType);
    }
}

