/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.drools.commons.factories;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.drools.compiler.lang.api.DescrFactory;
import org.drools.compiler.lang.api.PackageDescrBuilder;
import org.drools.compiler.lang.descr.AttributeDescr;
import org.drools.compiler.lang.descr.PackageDescr;
import org.drools.compiler.lang.descr.RuleDescr;
import org.junit.Before;
import org.junit.Test;
import org.kie.pmml.api.enums.BOOLEAN_OPERATOR;
import org.kie.pmml.api.enums.OPERATOR;
import org.kie.pmml.models.drools.ast.KiePMMLDroolsRule;
import org.kie.pmml.models.drools.ast.KiePMMLFieldOperatorValue;
import org.kie.pmml.models.drools.commons.factories.KiePMMLDescrRulesFactory;
import org.kie.pmml.models.drools.tuples.KiePMMLOperatorValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KiePMMLDescrRulesFactoryTest {
    private static final Logger logger = LoggerFactory.getLogger((String)KiePMMLDescrRulesFactoryTest.class.getName());
    private static final String PACKAGE_NAME = "package";
    private PackageDescrBuilder builder;

    @Before
    public void setUp() throws Exception {
        this.builder = DescrFactory.newPackage().name(PACKAGE_NAME);
        Assertions.assertThat((Object)((PackageDescr)this.builder.getDescr())).isNotNull();
        Assertions.assertThat((String)((PackageDescr)this.builder.getDescr()).getName()).isEqualTo(PACKAGE_NAME);
    }

    @Test
    public void declareRule() {
        String name = "NAME";
        String statusToSet = "STATUS_TO_SET";
        String patternType = "TEMPERATURE";
        String agendaGroup = "agendaGroup";
        String activationGroup = "activationGroup";
        List<KiePMMLFieldOperatorValue> orConstraints = Arrays.asList(new KiePMMLFieldOperatorValue(patternType, BOOLEAN_OPERATOR.OR, Collections.singletonList(new KiePMMLOperatorValue(OPERATOR.LESS_THAN, (Object)35)), null), new KiePMMLFieldOperatorValue(patternType, BOOLEAN_OPERATOR.AND, Collections.singletonList(new KiePMMLOperatorValue(OPERATOR.GREATER_THAN, (Object)85)), null));
        KiePMMLDroolsRule rule = KiePMMLDroolsRule.builder((String)name, (String)statusToSet, Collections.emptyList()).withAgendaGroup(agendaGroup).withActivationGroup(activationGroup).withOrConstraints(orConstraints).build();
        KiePMMLDescrRulesFactory.factory((PackageDescrBuilder)this.builder).declareRule(rule);
        Assertions.assertThat((List)((PackageDescr)this.builder.getDescr()).getRules()).isNotNull();
        Assertions.assertThat((List)((PackageDescr)this.builder.getDescr()).getRules()).hasSize(1);
        RuleDescr retrieved = (RuleDescr)((PackageDescr)this.builder.getDescr()).getRules().get(0);
        Assertions.assertThat((String)retrieved.getName()).isEqualTo(name);
        Assertions.assertThat((Map)retrieved.getAttributes()).hasSize(2);
        Assertions.assertThat((Map)retrieved.getAttributes()).containsKey((Object)"agenda-group");
        Assertions.assertThat((String)((AttributeDescr)retrieved.getAttributes().get("agenda-group")).getValue()).isEqualTo(agendaGroup);
        Assertions.assertThat((Map)retrieved.getAttributes()).containsKey((Object)"activation-group");
        Assertions.assertThat((String)((AttributeDescr)retrieved.getAttributes().get("activation-group")).getValue()).isEqualTo(activationGroup);
    }
}

