/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.drools.commons.factories;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.dmg.pmml.SimplePredicate;
import org.drools.compiler.lang.descr.GlobalDescr;
import org.drools.compiler.lang.descr.ImportDescr;
import org.drools.compiler.lang.descr.PackageDescr;
import org.drools.compiler.lang.descr.RuleDescr;
import org.junit.Test;
import org.kie.api.pmml.PMML4Result;
import org.kie.pmml.api.enums.BOOLEAN_OPERATOR;
import org.kie.pmml.api.enums.OPERATOR;
import org.kie.pmml.models.drools.ast.KiePMMLDroolsAST;
import org.kie.pmml.models.drools.ast.KiePMMLDroolsRule;
import org.kie.pmml.models.drools.ast.KiePMMLDroolsType;
import org.kie.pmml.models.drools.ast.KiePMMLFieldOperatorValue;
import org.kie.pmml.models.drools.commons.factories.KiePMMLDescrFactory;
import org.kie.pmml.models.drools.commons.factories.KiePMMLDescrTestUtils;
import org.kie.pmml.models.drools.executor.KiePMMLStatusHolder;
import org.kie.pmml.models.drools.tuples.KiePMMLOperatorValue;

public class KiePMMLDescrFactoryTest {
    private static final String RULE_NAME = "NAME";
    private static final String STATUS_TO_SET = "STATUS_TO_SET";
    private static final String PATTERN_TYPE = "TEMPERATURE";

    @Test
    public void getBaseDescr() {
        ArrayList<KiePMMLDroolsType> types = new ArrayList<KiePMMLDroolsType>();
        types.add(KiePMMLDescrTestUtils.getDroolsType());
        types.add(KiePMMLDescrTestUtils.getDottedDroolsType());
        List<KiePMMLFieldOperatorValue> orConstraints = Arrays.asList(new KiePMMLFieldOperatorValue(PATTERN_TYPE, BOOLEAN_OPERATOR.OR, Collections.singletonList(new KiePMMLOperatorValue(OPERATOR.LESS_THAN, (Object)35)), null), new KiePMMLFieldOperatorValue(PATTERN_TYPE, BOOLEAN_OPERATOR.AND, Collections.singletonList(new KiePMMLOperatorValue(OPERATOR.GREATER_THAN, (Object)85)), null));
        KiePMMLDroolsRule rule = KiePMMLDroolsRule.builder((String)RULE_NAME, (String)STATUS_TO_SET, Collections.emptyList()).withOrConstraints(orConstraints).build();
        ArrayList<KiePMMLDroolsRule> rules = new ArrayList<KiePMMLDroolsRule>();
        rules.add(rule);
        KiePMMLDroolsAST drooledAST = new KiePMMLDroolsAST(types, rules);
        PackageDescr packageDescr = KiePMMLDescrFactory.getBaseDescr((KiePMMLDroolsAST)drooledAST, (String)"PACKAGE_NAME");
        Assertions.assertThat((String)packageDescr.getName()).isEqualTo("PACKAGE_NAME");
        this.checkImports(packageDescr.getImports());
        this.checkGlobals(packageDescr.getGlobals());
        this.checkRules(packageDescr.getRules());
    }

    private void checkImports(List<ImportDescr> toCheck) {
        Assertions.assertThat(toCheck).hasSize(4);
        List<String> expectedImports = Arrays.asList(KiePMMLStatusHolder.class.getName(), SimplePredicate.class.getName(), PMML4Result.class.getName());
        for (String expectedImport : expectedImports) {
            Assertions.assertThat((Object)toCheck.stream().filter(importDescr -> expectedImport.equals(importDescr.getTarget())).findFirst().orElse(null)).isNotNull();
        }
    }

    private void checkGlobals(List<GlobalDescr> toCheck) {
        Assertions.assertThat(toCheck).hasSize(2);
        GlobalDescr retrieved = toCheck.get(0);
        Assertions.assertThat((String)retrieved.getIdentifier()).isEqualTo("$pmml4Result");
        Assertions.assertThat((String)retrieved.getType()).isEqualTo("PMML4Result");
        retrieved = toCheck.get(1);
        Assertions.assertThat((String)retrieved.getIdentifier()).isEqualTo("$outputFieldsMap");
        Assertions.assertThat((String)retrieved.getType()).isEqualTo("Map");
    }

    private void checkRules(List<RuleDescr> toCheck) {
        Assertions.assertThat(toCheck).hasSize(1);
        RuleDescr retrieved = toCheck.get(0);
        Assertions.assertThat((String)retrieved.getName()).isEqualTo(RULE_NAME);
    }
}

