/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.commons.utils;

import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.AssignExpr;
import com.github.javaparser.ast.expr.BooleanLiteralExpr;
import com.github.javaparser.ast.expr.DoubleLiteralExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.IntegerLiteralExpr;
import com.github.javaparser.ast.expr.LongLiteralExpr;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.MethodReferenceExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.NullLiteralExpr;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.ast.expr.SimpleName;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.expr.ThisExpr;
import com.github.javaparser.ast.expr.VariableDeclarationExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ExplicitConstructorInvocationStmt;
import com.github.javaparser.ast.stmt.ExpressionStmt;
import com.github.javaparser.ast.stmt.ReturnStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.junit.Assert;
import org.junit.Test;
import org.kie.pmml.api.enums.DATA_TYPE;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.commons.model.tuples.KiePMMLNameValue;
import org.kie.pmml.compiler.commons.testutils.CodegenTestUtils;
import org.kie.pmml.compiler.commons.utils.CommonCodegenUtils;

public class CommonCodegenUtilsTest {
    @Test
    public void populateMethodDeclarations() {
        List toAdd = IntStream.range(0, 5).boxed().map(index -> this.getMethodDeclaration("METHOD_" + index)).collect(Collectors.toList());
        ClassOrInterfaceDeclaration toPopulate = new ClassOrInterfaceDeclaration();
        Assert.assertTrue((boolean)toPopulate.getMembers().isEmpty());
        CommonCodegenUtils.populateMethodDeclarations((ClassOrInterfaceDeclaration)toPopulate, toAdd);
        NodeList retrieved = toPopulate.getMembers();
        Assert.assertEquals((long)toAdd.size(), (long)retrieved.size());
        Assert.assertTrue((boolean)toAdd.stream().anyMatch(methodDeclaration -> retrieved.stream().anyMatch(bodyDeclaration -> bodyDeclaration.equals(methodDeclaration))));
    }

    @Test
    public void getFilteredKiePMMLNameValueExpression() {
        String kiePMMLNameValueListParam = "KIEPMMLNAMEVALUELISTPARAM";
        String fieldNameToRef = "FIELDNAMETOREF";
        ExpressionStmt retrieved = CommonCodegenUtils.getFilteredKiePMMLNameValueExpression((String)kiePMMLNameValueListParam, (String)fieldNameToRef, (boolean)true);
        Assert.assertNotNull((Object)retrieved);
        String expected = String.format("%1$s<%2$s> %3$s = %4$s.stream().filter((%2$s %5$s) -> %6$s.equals(\"%7$s\", %5$s.getName())).findFirst();", Optional.class.getName(), KiePMMLNameValue.class.getName(), CommonCodegenUtils.OPTIONAL_FILTERED_KIEPMMLNAMEVALUE_NAME, kiePMMLNameValueListParam, "lmbdParam", Objects.class.getName(), fieldNameToRef);
        String retrievedString = retrieved.toString();
        Assert.assertEquals((Object)expected, (Object)retrievedString);
        BlockStmt body = new BlockStmt();
        body.addStatement((Statement)retrieved);
        Parameter listParameter = new Parameter((Type)CommonCodegenUtils.getTypedClassOrInterfaceTypeByTypeNames((String)List.class.getName(), Collections.singletonList(KiePMMLNameValue.class.getName())), kiePMMLNameValueListParam);
        Parameter fieldRefParameter = new Parameter((Type)StaticJavaParser.parseClassOrInterfaceType((String)String.class.getName()), fieldNameToRef);
        CodegenTestUtils.commonValidateCompilation(body, Arrays.asList(listParameter, fieldRefParameter));
        retrieved = CommonCodegenUtils.getFilteredKiePMMLNameValueExpression((String)kiePMMLNameValueListParam, (String)fieldNameToRef, (boolean)false);
        Assert.assertNotNull((Object)retrieved);
        expected = String.format("%1$s<%2$s> %3$s = %4$s.stream().filter((%2$s %5$s) -> %6$s.equals(%7$s, %5$s.getName())).findFirst();", Optional.class.getName(), KiePMMLNameValue.class.getName(), CommonCodegenUtils.OPTIONAL_FILTERED_KIEPMMLNAMEVALUE_NAME, kiePMMLNameValueListParam, "lmbdParam", Objects.class.getName(), fieldNameToRef);
        retrievedString = retrieved.toString();
        Assert.assertEquals((Object)expected, (Object)retrievedString);
        body = new BlockStmt();
        body.addStatement((Statement)retrieved);
        listParameter = new Parameter((Type)CommonCodegenUtils.getTypedClassOrInterfaceTypeByTypeNames((String)List.class.getName(), Collections.singletonList(KiePMMLNameValue.class.getName())), kiePMMLNameValueListParam);
        fieldRefParameter = new Parameter((Type)StaticJavaParser.parseClassOrInterfaceType((String)String.class.getName()), fieldNameToRef);
        CodegenTestUtils.commonValidateCompilation(body, Arrays.asList(listParameter, fieldRefParameter));
    }

    @Test
    public void addMapPopulation() {
        Map<String, MethodDeclaration> toAdd = IntStream.range(0, 5).boxed().collect(Collectors.toMap(index -> "KEY_" + index, index -> this.getMethodDeclaration("METHOD_" + index)));
        BlockStmt body = new BlockStmt();
        String mapName = "MAP_NAME";
        CommonCodegenUtils.addMapPopulation(toAdd, (BlockStmt)body, (String)mapName);
        NodeList statements = body.getStatements();
        Assert.assertEquals((long)toAdd.size(), (long)statements.size());
        for (Statement statement2 : statements) {
            Assert.assertTrue((boolean)(statement2 instanceof ExpressionStmt));
            ExpressionStmt expressionStmt = (ExpressionStmt)statement2;
            Expression expression = expressionStmt.getExpression();
            Assert.assertTrue((boolean)(expression instanceof MethodCallExpr));
            MethodCallExpr methodCallExpr = (MethodCallExpr)expression;
            NodeList arguments = methodCallExpr.getArguments();
            Assert.assertEquals((long)2L, (long)arguments.size());
            Assert.assertTrue((boolean)(arguments.get(0) instanceof StringLiteralExpr));
            Assert.assertTrue((boolean)(arguments.get(1) instanceof MethodReferenceExpr));
            MethodReferenceExpr methodReferenceExpr = (MethodReferenceExpr)arguments.get(1);
            Assert.assertTrue((boolean)(methodReferenceExpr.getScope() instanceof ThisExpr));
            Expression scope = methodCallExpr.getScope().orElse(null);
            Assert.assertNotNull((Object)scope);
            Assert.assertTrue((boolean)(scope instanceof NameExpr));
            Assert.assertEquals((Object)mapName, (Object)((NameExpr)scope).getNameAsString());
        }
        for (Map.Entry<String, MethodDeclaration> entry : toAdd.entrySet()) {
            int matchingDeclarations = (int)statements.stream().filter(statement -> {
                ExpressionStmt expressionStmt = (ExpressionStmt)statement;
                Expression expression = expressionStmt.getExpression();
                MethodCallExpr methodCallExpr = (MethodCallExpr)expression;
                NodeList arguments = methodCallExpr.getArguments();
                if (!((String)entry.getKey()).equals(((StringLiteralExpr)arguments.get(0)).getValue())) {
                    return false;
                }
                MethodReferenceExpr methodReferenceExpr = (MethodReferenceExpr)arguments.get(1);
                return ((MethodDeclaration)entry.getValue()).getName().asString().equals(methodReferenceExpr.getIdentifier());
            }).count();
            Assert.assertEquals((long)1L, (long)matchingDeclarations);
        }
    }

    @Test
    public void addMapPopulationExpression() {
        HashMap<String, Object> inputMap = new HashMap<String, Object>();
        inputMap.put("one", new StringLiteralExpr("ONE"));
        inputMap.put("two", new IntegerLiteralExpr("2"));
        inputMap.put("three", new DoubleLiteralExpr("3.0"));
        BlockStmt inputBody = new BlockStmt();
        String inputMapName = "testMap";
        CommonCodegenUtils.addMapPopulationExpressions(inputMap, (BlockStmt)inputBody, (String)inputMapName);
        NodeList statements = inputBody.getStatements();
        Assert.assertEquals((long)inputMap.size(), (long)statements.size());
        ArrayList<MethodCallExpr> methodCallExprs = new ArrayList<MethodCallExpr>(statements.size());
        for (Statement statement : statements) {
            Assert.assertTrue((boolean)(statement instanceof ExpressionStmt));
            Expression expression = ((ExpressionStmt)statement).getExpression();
            Assert.assertTrue((boolean)(expression instanceof MethodCallExpr));
            MethodCallExpr methodCallExpr2 = (MethodCallExpr)expression;
            Assert.assertEquals((Object)inputMapName, methodCallExpr2.getScope().map(Node::toString).orElse(null));
            Assert.assertEquals((Object)"put", (Object)methodCallExpr2.getName().asString());
            Assert.assertSame((Object)2, (Object)methodCallExpr2.getArguments().size());
            Assert.assertTrue((boolean)(methodCallExpr2.getArgument(0) instanceof StringLiteralExpr));
            methodCallExprs.add(methodCallExpr2);
        }
        for (Map.Entry inputEntry : inputMap.entrySet()) {
            Assert.assertEquals((String)("Expected one and only one statement for key \"" + (String)inputEntry.getKey() + "\""), (long)1L, (long)methodCallExprs.stream().filter(methodCallExpr -> {
                StringLiteralExpr arg0 = (StringLiteralExpr)methodCallExpr.getArgument(0);
                return arg0.asString().equals(inputEntry.getKey()) && methodCallExpr.getArgument(1).equals(inputEntry.getValue());
            }).count());
        }
    }

    @Test
    public void addListPopulation() {
        List toAdd = IntStream.range(0, 5).mapToObj(i -> {
            ObjectCreationExpr toReturn = new ObjectCreationExpr();
            toReturn.setType(String.class);
            StringLiteralExpr value = new StringLiteralExpr("String" + i);
            toReturn.setArguments(NodeList.nodeList((Node[])new Expression[]{value}));
            return toReturn;
        }).collect(Collectors.toList());
        BlockStmt body = new BlockStmt();
        String listName = "LIST_NAME";
        CommonCodegenUtils.addListPopulationByObjectCreationExpr(toAdd, (BlockStmt)body, (String)listName);
        NodeList statements = body.getStatements();
        Assert.assertEquals((long)toAdd.size(), (long)statements.size());
        for (Statement statement2 : statements) {
            Assert.assertTrue((boolean)(statement2 instanceof ExpressionStmt));
            ExpressionStmt expressionStmt = (ExpressionStmt)statement2;
            Assert.assertTrue((boolean)(expressionStmt.getExpression() instanceof MethodCallExpr));
            MethodCallExpr methodCallExpr = (MethodCallExpr)expressionStmt.getExpression();
            Assert.assertEquals((Object)listName, (Object)((Expression)methodCallExpr.getScope().get()).asNameExpr().getNameAsString());
            NodeList arguments = methodCallExpr.getArguments();
            Assert.assertEquals((long)1L, (long)arguments.size());
            Assert.assertTrue((boolean)(arguments.get(0) instanceof ObjectCreationExpr));
            ObjectCreationExpr objectCreationExpr = (ObjectCreationExpr)arguments.get(0);
            Assert.assertEquals((Object)objectCreationExpr.getType().asString(), (Object)String.class.getSimpleName());
            arguments = objectCreationExpr.getArguments();
            Assert.assertEquals((long)1L, (long)arguments.size());
            Assert.assertTrue((boolean)(arguments.get(0) instanceof StringLiteralExpr));
        }
        for (ObjectCreationExpr entry : toAdd) {
            int matchingDeclarations = (int)statements.stream().filter(statement -> {
                ExpressionStmt expressionStmt = (ExpressionStmt)statement;
                Expression expression = expressionStmt.getExpression();
                MethodCallExpr methodCallExpr = (MethodCallExpr)expression;
                NodeList arguments = methodCallExpr.getArguments();
                return entry.equals((Object)((Expression)arguments.get(0)).asObjectCreationExpr());
            }).count();
            Assert.assertEquals((long)1L, (long)matchingDeclarations);
        }
    }

    @Test
    public void createArraysAsListExpression() {
        ExpressionStmt retrieved = CommonCodegenUtils.createArraysAsListExpression();
        Assert.assertNotNull((Object)retrieved);
        String expected = "java.util.Arrays.asList();";
        String retrievedString = retrieved.toString();
        Assert.assertEquals((Object)expected, (Object)retrievedString);
    }

    @Test
    public void createArraysAsListFromList() {
        List strings = IntStream.range(0, 3).mapToObj(i -> "Element" + i).collect(Collectors.toList());
        ExpressionStmt retrieved = CommonCodegenUtils.createArraysAsListFromList(strings);
        Assert.assertNotNull((Object)retrieved);
        String arguments = strings.stream().map(string -> "\"" + string + "\"").collect(Collectors.joining(", "));
        String expected = String.format("java.util.Arrays.asList(%s);", arguments);
        String retrievedString = retrieved.toString();
        Assert.assertEquals((Object)expected, (Object)retrievedString);
        List doubles = IntStream.range(0, 3).mapToObj(i -> (double)i * 0.17).collect(Collectors.toList());
        retrieved = CommonCodegenUtils.createArraysAsListFromList(doubles);
        Assert.assertNotNull((Object)retrieved);
        arguments = doubles.stream().map(String::valueOf).collect(Collectors.joining(", "));
        expected = String.format("java.util.Arrays.asList(%s);", arguments);
        retrievedString = retrieved.toString();
        Assert.assertEquals((Object)expected, (Object)retrievedString);
    }

    @Test
    public void getParamMethodDeclaration() {
        String methodName = "METHOD_NAME";
        HashMap<String, ClassOrInterfaceType> parameterNameTypeMap = new HashMap<String, ClassOrInterfaceType>();
        parameterNameTypeMap.put("stringParam", StaticJavaParser.parseClassOrInterfaceType((String)String.class.getName()));
        parameterNameTypeMap.put("kiePMMLNameValueParam", StaticJavaParser.parseClassOrInterfaceType((String)KiePMMLNameValue.class.getName()));
        parameterNameTypeMap.put("listParam", new ClassOrInterfaceType(null, new SimpleName(List.class.getName()), NodeList.nodeList((Node[])new Type[]{StaticJavaParser.parseClassOrInterfaceType((String)KiePMMLNameValue.class.getName())})));
        MethodDeclaration retrieved = CommonCodegenUtils.getMethodDeclaration((String)methodName, parameterNameTypeMap);
        this.commonValidateMethodDeclaration(retrieved, methodName);
        this.commonValidateMethodDeclarationParams(retrieved, parameterNameTypeMap);
    }

    @Test
    public void getNoParamMethodDeclarationByString() {
        String methodName = "METHOD_NAME";
        MethodDeclaration retrieved = CommonCodegenUtils.getMethodDeclaration((String)methodName);
        this.commonValidateMethodDeclaration(retrieved, methodName);
    }

    @Test
    public void getReturnStmt() {
        String returnedVariable = "RETURNED_VARIABLE";
        ReturnStmt retrieved = CommonCodegenUtils.getReturnStmt((String)returnedVariable);
        String expected = String.format("return %s;", returnedVariable);
        Assert.assertEquals((Object)expected, (Object)retrieved.toString());
    }

    @Test
    public void getTypedClassOrInterfaceType() {
        String className = "CLASS_NAME";
        List<String> typesName = Arrays.asList("TypeA", "TypeB");
        ClassOrInterfaceType retrieved = CommonCodegenUtils.getTypedClassOrInterfaceTypeByTypeNames((String)className, typesName);
        Assert.assertNotNull((Object)retrieved);
        String expected = String.format("%1$s<%2$s,%3$s>", className, typesName.get(0), typesName.get(1));
        Assert.assertEquals((Object)expected, (Object)retrieved.asString());
    }

    @Test
    public void setAssignExpressionValueMatch() {
        BlockStmt body = new BlockStmt();
        AssignExpr assignExpr = new AssignExpr();
        assignExpr.setTarget((Expression)new NameExpr("MATCH"));
        body.addStatement((Expression)assignExpr);
        DoubleLiteralExpr value = new DoubleLiteralExpr(24.22);
        CommonCodegenUtils.setAssignExpressionValue((BlockStmt)body, (String)"MATCH", (Expression)value);
        Assert.assertEquals((Object)value, (Object)assignExpr.getValue());
    }

    @Test(expected=KiePMMLException.class)
    public void setAssignExpressionValueNoMatch() {
        BlockStmt body = new BlockStmt();
        AssignExpr assignExpr = new AssignExpr();
        assignExpr.setTarget((Expression)new NameExpr("MATCH"));
        body.addStatement((Expression)assignExpr);
        CommonCodegenUtils.setAssignExpressionValue((BlockStmt)body, (String)"NOMATCH", (Expression)new DoubleLiteralExpr(24.22));
    }

    @Test(expected=KiePMMLException.class)
    public void setAssignExpressionValueNoAssignExpressions() {
        BlockStmt body = new BlockStmt();
        CommonCodegenUtils.setAssignExpressionValue((BlockStmt)body, (String)"NOMATCH", (Expression)new DoubleLiteralExpr(24.22));
    }

    @Test
    public void getAssignExpression() {
        BlockStmt body = new BlockStmt();
        Optional retrieved = CommonCodegenUtils.getAssignExpression((BlockStmt)body, (String)"NOMATCH");
        Assert.assertNotNull((Object)retrieved);
        Assert.assertFalse((boolean)retrieved.isPresent());
        AssignExpr assignExpr = new AssignExpr();
        assignExpr.setTarget((Expression)new NameExpr("MATCH"));
        body.addStatement((Expression)assignExpr);
        retrieved = CommonCodegenUtils.getAssignExpression((BlockStmt)body, (String)"NOMATCH");
        Assert.assertNotNull((Object)retrieved);
        Assert.assertFalse((boolean)retrieved.isPresent());
        retrieved = CommonCodegenUtils.getAssignExpression((BlockStmt)body, (String)"MATCH");
        Assert.assertNotNull((Object)retrieved);
        Assert.assertTrue((boolean)retrieved.isPresent());
        AssignExpr retrievedAssignExpr = (AssignExpr)retrieved.get();
        Assert.assertEquals((Object)assignExpr, (Object)retrievedAssignExpr);
    }

    @Test
    public void getExplicitConstructorInvocationStmt() {
        BlockStmt body = new BlockStmt();
        Optional retrieved = CommonCodegenUtils.getExplicitConstructorInvocationStmt((BlockStmt)body);
        Assert.assertNotNull((Object)retrieved);
        Assert.assertFalse((boolean)retrieved.isPresent());
        ExplicitConstructorInvocationStmt explicitConstructorInvocationStmt = new ExplicitConstructorInvocationStmt();
        body.addStatement((Statement)explicitConstructorInvocationStmt);
        retrieved = CommonCodegenUtils.getExplicitConstructorInvocationStmt((BlockStmt)body);
        Assert.assertNotNull((Object)retrieved);
        Assert.assertTrue((boolean)retrieved.isPresent());
        ExplicitConstructorInvocationStmt retrievedExplicitConstructorInvocationStmt = (ExplicitConstructorInvocationStmt)retrieved.get();
        Assert.assertEquals((Object)explicitConstructorInvocationStmt, (Object)retrievedExplicitConstructorInvocationStmt);
    }

    @Test
    public void setExplicitConstructorInvocationStmtArgumentWithParameter() {
        String parameterName = "PARAMETER_NAME";
        String value = "VALUE";
        ExplicitConstructorInvocationStmt explicitConstructorInvocationStmt = new ExplicitConstructorInvocationStmt();
        explicitConstructorInvocationStmt.setArguments(NodeList.nodeList((Node[])new Expression[]{new NameExpr("NOT_PARAMETER"), new NameExpr("PARAMETER_NAME")}));
        Assert.assertTrue((boolean)CommonCodegenUtils.getExplicitConstructorInvocationParameter((ExplicitConstructorInvocationStmt)explicitConstructorInvocationStmt, (String)"PARAMETER_NAME").isPresent());
        CommonCodegenUtils.setExplicitConstructorInvocationStmtArgument((ExplicitConstructorInvocationStmt)explicitConstructorInvocationStmt, (String)"PARAMETER_NAME", (String)"VALUE");
        Assert.assertFalse((boolean)CommonCodegenUtils.getExplicitConstructorInvocationParameter((ExplicitConstructorInvocationStmt)explicitConstructorInvocationStmt, (String)"PARAMETER_NAME").isPresent());
        Assert.assertTrue((boolean)CommonCodegenUtils.getExplicitConstructorInvocationParameter((ExplicitConstructorInvocationStmt)explicitConstructorInvocationStmt, (String)"VALUE").isPresent());
    }

    @Test(expected=KiePMMLException.class)
    public void setExplicitConstructorInvocationStmtArgumentNoParameter() {
        String parameterName = "PARAMETER_NAME";
        ExplicitConstructorInvocationStmt explicitConstructorInvocationStmt = new ExplicitConstructorInvocationStmt();
        explicitConstructorInvocationStmt.setArguments(NodeList.nodeList((Node[])new Expression[]{new NameExpr("NOT_PARAMETER")}));
        CommonCodegenUtils.setExplicitConstructorInvocationStmtArgument((ExplicitConstructorInvocationStmt)explicitConstructorInvocationStmt, (String)"PARAMETER_NAME", (String)"VALUE");
    }

    @Test
    public void getExplicitConstructorInvocationParameter() {
        String parameterName = "PARAMETER_NAME";
        ExplicitConstructorInvocationStmt explicitConstructorInvocationStmt = new ExplicitConstructorInvocationStmt();
        Assert.assertFalse((boolean)CommonCodegenUtils.getExplicitConstructorInvocationParameter((ExplicitConstructorInvocationStmt)explicitConstructorInvocationStmt, (String)"PARAMETER_NAME").isPresent());
        explicitConstructorInvocationStmt.setArguments(NodeList.nodeList((Node[])new Expression[]{new NameExpr("NOT_PARAMETER")}));
        Assert.assertFalse((boolean)CommonCodegenUtils.getExplicitConstructorInvocationParameter((ExplicitConstructorInvocationStmt)explicitConstructorInvocationStmt, (String)"PARAMETER_NAME").isPresent());
        explicitConstructorInvocationStmt.setArguments(NodeList.nodeList((Node[])new Expression[]{new NameExpr("NOT_PARAMETER"), new NameExpr("PARAMETER_NAME")}));
        Assert.assertTrue((boolean)CommonCodegenUtils.getExplicitConstructorInvocationParameter((ExplicitConstructorInvocationStmt)explicitConstructorInvocationStmt, (String)"PARAMETER_NAME").isPresent());
    }

    @Test
    public void getMethodDeclaration() {
        String methodName = "METHOD_NAME";
        ClassOrInterfaceDeclaration classOrInterfaceDeclaration = new ClassOrInterfaceDeclaration();
        Assert.assertFalse((boolean)CommonCodegenUtils.getMethodDeclaration((ClassOrInterfaceDeclaration)classOrInterfaceDeclaration, (String)"METHOD_NAME").isPresent());
        classOrInterfaceDeclaration.addMethod("NOT_METHOD", new Modifier.Keyword[0]);
        Assert.assertFalse((boolean)CommonCodegenUtils.getMethodDeclaration((ClassOrInterfaceDeclaration)classOrInterfaceDeclaration, (String)"METHOD_NAME").isPresent());
        classOrInterfaceDeclaration.addMethod("METHOD_NAME", new Modifier.Keyword[0]);
        Assert.assertTrue((boolean)CommonCodegenUtils.getMethodDeclaration((ClassOrInterfaceDeclaration)classOrInterfaceDeclaration, (String)"METHOD_NAME").isPresent());
    }

    @Test
    public void addMethod() {
        MethodDeclaration methodTemplate = new MethodDeclaration();
        methodTemplate.setName("methodTemplate");
        BlockStmt body = new BlockStmt();
        methodTemplate.setBody(body);
        String methodName = "METHOD_NAME";
        ClassOrInterfaceDeclaration classOrInterfaceDeclaration = new ClassOrInterfaceDeclaration();
        Assert.assertTrue((boolean)classOrInterfaceDeclaration.getMethodsByName("METHOD_NAME").isEmpty());
        CommonCodegenUtils.addMethod((MethodDeclaration)methodTemplate, (ClassOrInterfaceDeclaration)classOrInterfaceDeclaration, (String)"METHOD_NAME");
        Assert.assertEquals((long)1L, (long)classOrInterfaceDeclaration.getMethodsByName("METHOD_NAME").size());
        Assert.assertEquals((Object)body, ((MethodDeclaration)classOrInterfaceDeclaration.getMethodsByName("METHOD_NAME").get(0)).getBody().get());
    }

    @Test
    public void getVariableDeclarator() {
        String variableName = "variableName";
        BlockStmt body = new BlockStmt();
        Assert.assertFalse((boolean)CommonCodegenUtils.getVariableDeclarator((BlockStmt)body, (String)"variableName").isPresent());
        VariableDeclarationExpr variableDeclarationExpr = new VariableDeclarationExpr((Type)StaticJavaParser.parseClassOrInterfaceType((String)"String"), "variableName");
        body.addStatement((Expression)variableDeclarationExpr);
        Optional retrieved = CommonCodegenUtils.getVariableDeclarator((BlockStmt)body, (String)"variableName");
        Assert.assertTrue((boolean)retrieved.isPresent());
        VariableDeclarator variableDeclarator = (VariableDeclarator)retrieved.get();
        Assert.assertEquals((Object)"variableName", (Object)variableDeclarator.getName().asString());
    }

    @Test
    public void getExpressionForObject() {
        String string = "string";
        Expression retrieved = CommonCodegenUtils.getExpressionForObject((Object)string);
        Assert.assertTrue((boolean)(retrieved instanceof StringLiteralExpr));
        Assert.assertEquals((Object)"\"string\"", (Object)retrieved.toString());
        int i = 1;
        retrieved = CommonCodegenUtils.getExpressionForObject((Object)i);
        Assert.assertTrue((boolean)(retrieved instanceof IntegerLiteralExpr));
        Assert.assertEquals((long)i, (long)((IntegerLiteralExpr)retrieved).asInt());
        Integer j = 3;
        retrieved = CommonCodegenUtils.getExpressionForObject((Object)j);
        Assert.assertTrue((boolean)(retrieved instanceof IntegerLiteralExpr));
        Assert.assertEquals((long)j.intValue(), (long)((IntegerLiteralExpr)retrieved).asInt());
        double x = 1.12;
        retrieved = CommonCodegenUtils.getExpressionForObject((Object)x);
        Assert.assertTrue((boolean)(retrieved instanceof DoubleLiteralExpr));
        Assert.assertEquals((double)x, (double)((DoubleLiteralExpr)retrieved).asDouble(), (double)0.001);
        Double y = 3.12;
        retrieved = CommonCodegenUtils.getExpressionForObject((Object)y);
        Assert.assertTrue((boolean)(retrieved instanceof DoubleLiteralExpr));
        Assert.assertEquals((double)y, (double)((DoubleLiteralExpr)retrieved).asDouble(), (double)0.001);
        float k = 1.12f;
        retrieved = CommonCodegenUtils.getExpressionForObject((Object)Float.valueOf(k));
        Assert.assertTrue((boolean)(retrieved instanceof DoubleLiteralExpr));
        Assert.assertEquals((double)1.12, (double)((DoubleLiteralExpr)retrieved).asDouble(), (double)0.001);
        Float z = Float.valueOf(3.12f);
        retrieved = CommonCodegenUtils.getExpressionForObject((Object)z);
        Assert.assertTrue((boolean)(retrieved instanceof DoubleLiteralExpr));
        Assert.assertEquals((double)z.doubleValue(), (double)((DoubleLiteralExpr)retrieved).asDouble(), (double)0.001);
        boolean b = true;
        retrieved = CommonCodegenUtils.getExpressionForObject((Object)b);
        Assert.assertTrue((boolean)(retrieved instanceof BooleanLiteralExpr));
        Assert.assertEquals((Object)b, (Object)((BooleanLiteralExpr)retrieved).getValue());
        Boolean c = false;
        retrieved = CommonCodegenUtils.getExpressionForObject((Object)c);
        Assert.assertTrue((boolean)(retrieved instanceof BooleanLiteralExpr));
        Assert.assertEquals((Object)c, (Object)((BooleanLiteralExpr)retrieved).getValue());
    }

    @Test
    public void getNameExprsFromBlock() {
        BlockStmt toRead = new BlockStmt();
        List retrieved = CommonCodegenUtils.getNameExprsFromBlock((BlockStmt)toRead, (String)"value");
        Assert.assertNotNull((Object)retrieved);
        Assert.assertTrue((boolean)retrieved.isEmpty());
        toRead = this.getBlockStmt();
        retrieved = CommonCodegenUtils.getNameExprsFromBlock((BlockStmt)toRead, (String)"value");
        Assert.assertNotNull((Object)retrieved);
        Assert.assertEquals((long)2L, (long)retrieved.size());
    }

    @Test
    public void literalExprFromDataType() {
        HashMap<DATA_TYPE, String> inputMap = new HashMap<DATA_TYPE, String>();
        inputMap.put(DATA_TYPE.STRING, "TEST");
        inputMap.put(DATA_TYPE.INTEGER, "1");
        inputMap.put(DATA_TYPE.FLOAT, "2.0");
        inputMap.put(DATA_TYPE.DOUBLE, "3.0");
        inputMap.put(DATA_TYPE.BOOLEAN, "true");
        inputMap.put(DATA_TYPE.DATE, "2021-06-01");
        inputMap.put(DATA_TYPE.TIME, "11:21:31");
        inputMap.put(DATA_TYPE.DATE_TIME, "2021-06-01T11:21:31");
        inputMap.put(DATA_TYPE.DATE_DAYS_SINCE_0, "10");
        inputMap.put(DATA_TYPE.DATE_DAYS_SINCE_1960, "20");
        inputMap.put(DATA_TYPE.DATE_DAYS_SINCE_1970, "30");
        inputMap.put(DATA_TYPE.DATE_DAYS_SINCE_1980, "40");
        inputMap.put(DATA_TYPE.TIME_SECONDS, "50");
        inputMap.put(DATA_TYPE.DATE_TIME_SECONDS_SINCE_0, "60");
        inputMap.put(DATA_TYPE.DATE_TIME_SECONDS_SINCE_1960, "70");
        inputMap.put(DATA_TYPE.DATE_TIME_SECONDS_SINCE_1970, "80");
        inputMap.put(DATA_TYPE.DATE_TIME_SECONDS_SINCE_1980, "90");
        for (Map.Entry input : inputMap.entrySet()) {
            Assert.assertTrue((boolean)(CommonCodegenUtils.literalExprFrom((DATA_TYPE)((DATA_TYPE)input.getKey()), null) instanceof NullLiteralExpr));
            Expression output = CommonCodegenUtils.literalExprFrom((DATA_TYPE)((DATA_TYPE)input.getKey()), (String)((String)input.getValue()));
            switch ((DATA_TYPE)input.getKey()) {
                case STRING: {
                    Assert.assertTrue((boolean)(output instanceof StringLiteralExpr));
                    break;
                }
                case INTEGER: {
                    Assert.assertTrue((boolean)(output instanceof IntegerLiteralExpr));
                    break;
                }
                case DOUBLE: 
                case FLOAT: {
                    Assert.assertTrue((boolean)(output instanceof DoubleLiteralExpr));
                    break;
                }
                case BOOLEAN: {
                    Assert.assertTrue((boolean)(output instanceof BooleanLiteralExpr));
                    break;
                }
                case DATE: 
                case TIME: 
                case DATE_TIME: {
                    Assert.assertTrue((boolean)(output instanceof MethodCallExpr));
                    break;
                }
                case DATE_DAYS_SINCE_0: 
                case DATE_DAYS_SINCE_1960: 
                case DATE_DAYS_SINCE_1970: 
                case DATE_DAYS_SINCE_1980: 
                case TIME_SECONDS: 
                case DATE_TIME_SECONDS_SINCE_0: 
                case DATE_TIME_SECONDS_SINCE_1960: 
                case DATE_TIME_SECONDS_SINCE_1970: 
                case DATE_TIME_SECONDS_SINCE_1980: {
                    Assert.assertTrue((boolean)(output instanceof LongLiteralExpr));
                }
            }
        }
        Assert.assertThrows(IllegalArgumentException.class, () -> CommonCodegenUtils.literalExprFrom(null, null));
        Assert.assertThrows(IllegalArgumentException.class, () -> CommonCodegenUtils.literalExprFrom(null, (String)"test"));
    }

    @Test
    public void replaceNodesInBlock() {
        BlockStmt toRead = this.getBlockStmt();
        List retrieved = CommonCodegenUtils.getNameExprsFromBlock((BlockStmt)toRead, (String)"value");
        Assert.assertEquals((long)2L, (long)retrieved.size());
        List<NullLiteralExpr> nullExprs = toRead.stream().filter(node -> node instanceof NullLiteralExpr).map(NullLiteralExpr.class::cast).collect(Collectors.toList());
        Assert.assertNotNull(nullExprs);
        Assert.assertTrue((boolean)nullExprs.isEmpty());
        List replacementTuplas = retrieved.stream().map(nameExpr -> {
            NullLiteralExpr toAdd = new NullLiteralExpr();
            nullExprs.add(toAdd);
            return new CommonCodegenUtils.ReplacementTupla((Node)nameExpr, (Node)toAdd);
        }).collect(Collectors.toList());
        CommonCodegenUtils.replaceNodesInStatement((Statement)toRead, replacementTuplas);
        List newRetrieved = CommonCodegenUtils.getNameExprsFromBlock((BlockStmt)toRead, (String)"value");
        Assert.assertTrue((boolean)newRetrieved.isEmpty());
        List retrievedNullExprs = toRead.stream().filter(node -> node instanceof NullLiteralExpr).map(NullLiteralExpr.class::cast).collect(Collectors.toList());
        Assert.assertNotNull(nullExprs);
        Assert.assertEquals((long)nullExprs.size(), (long)retrievedNullExprs.size());
        nullExprs.forEach(nullExpr -> Assert.assertTrue((boolean)retrievedNullExprs.contains(nullExpr)));
    }

    private BlockStmt getBlockStmt() {
        String blockStatement = "{\nObject inputValue = 12;\n        if (stringObjectMap.containsKey(\"avalue\")) {\n            inputValue = stringObjectMap.get(\"avalue\");\n        } else {\n            return false;\n        }\n        if (inputValue instanceof Number && value instanceof Number) {\n            return ((Number) inputValue).doubleValue() >= ((Number) value).doubleValue();\n        } else {\n            return false;\n        }\n}";
        return StaticJavaParser.parseBlock((String)blockStatement);
    }

    private void commonValidateMethodDeclaration(MethodDeclaration toValidate, String methodName) {
        Assert.assertNotNull((Object)toValidate);
        Assert.assertEquals((Object)methodName, (Object)toValidate.getName().asString());
    }

    private void commonValidateMethodDeclarationParams(MethodDeclaration toValidate, Map<String, ClassOrInterfaceType> parameterNameTypeMap) {
        NodeList retrieved = toValidate.getParameters();
        Assert.assertNotNull((Object)retrieved);
        Assert.assertEquals((long)parameterNameTypeMap.size(), (long)retrieved.size());
        for (Parameter parameter : retrieved) {
            Assert.assertTrue((boolean)parameterNameTypeMap.containsKey(parameter.getNameAsString()));
            Assert.assertEquals((Object)parameterNameTypeMap.get(parameter.getNameAsString()), (Object)parameter.getType());
        }
    }

    private MethodDeclaration getMethodDeclaration(String methodName) {
        return CommonCodegenUtils.getMethodDeclaration((String)methodName);
    }
}

