/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.commons.codegenfactories;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.dmg.pmml.Target;
import org.junit.Assert;
import org.junit.Test;
import org.kie.pmml.api.enums.CAST_INTEGER;
import org.kie.pmml.api.enums.OP_TYPE;
import org.kie.pmml.commons.model.KiePMMLTarget;
import org.kie.pmml.commons.model.KiePMMLTargetValue;
import org.kie.pmml.compiler.api.testutils.PMMLModelTestUtils;
import org.kie.pmml.compiler.api.utils.ModelUtils;
import org.kie.pmml.compiler.commons.codegenfactories.KiePMMLTargetFactory;
import org.kie.pmml.compiler.commons.testutils.CodegenTestUtils;
import org.kie.pmml.compiler.commons.utils.JavaParserUtils;
import org.kie.test.util.filesystem.FileUtils;

public class KiePMMLTargetFactoryTest {
    private static final String TEST_01_SOURCE = "KiePMMLTargetFactoryTest_01.txt";

    @Test
    public void getKiePMMLTargetValueVariableInitializer() throws IOException {
        KiePMMLTarget kiePMMLTarget = ModelUtils.convertToKiePMMLTarget((Target)PMMLModelTestUtils.getRandomTarget());
        MethodCallExpr retrieved = KiePMMLTargetFactory.getKiePMMLTargetVariableInitializer((KiePMMLTarget)kiePMMLTarget);
        String text = FileUtils.getFileContent((String)TEST_01_SOURCE);
        List targetValues = kiePMMLTarget.getTargetValues();
        String opType = OP_TYPE.class.getCanonicalName() + "." + kiePMMLTarget.getOpType().toString();
        String castInteger = CAST_INTEGER.class.getCanonicalName() + "." + kiePMMLTarget.getCastInteger().toString();
        Expression expected = JavaParserUtils.parseExpression((String)String.format(text, kiePMMLTarget.getName(), ((KiePMMLTargetValue)targetValues.get(0)).getName(), ((KiePMMLTargetValue)targetValues.get(0)).getValue(), ((KiePMMLTargetValue)targetValues.get(0)).getDisplayValue(), ((KiePMMLTargetValue)targetValues.get(0)).getPriorProbability(), ((KiePMMLTargetValue)targetValues.get(0)).getDefaultValue(), ((KiePMMLTargetValue)targetValues.get(1)).getName(), ((KiePMMLTargetValue)targetValues.get(1)).getValue(), ((KiePMMLTargetValue)targetValues.get(1)).getDisplayValue(), ((KiePMMLTargetValue)targetValues.get(1)).getPriorProbability(), ((KiePMMLTargetValue)targetValues.get(1)).getDefaultValue(), ((KiePMMLTargetValue)targetValues.get(2)).getName(), ((KiePMMLTargetValue)targetValues.get(2)).getValue(), ((KiePMMLTargetValue)targetValues.get(2)).getDisplayValue(), ((KiePMMLTargetValue)targetValues.get(2)).getPriorProbability(), ((KiePMMLTargetValue)targetValues.get(2)).getDefaultValue(), opType, kiePMMLTarget.getField(), castInteger, kiePMMLTarget.getMin(), kiePMMLTarget.getMax(), kiePMMLTarget.getRescaleConstant(), kiePMMLTarget.getRescaleFactor()));
        Assert.assertTrue((boolean)JavaParserUtils.equalsNode((Node)expected, (Node)retrieved));
        List<Class<?>> imports = Arrays.asList(Arrays.class, Collections.class, KiePMMLTarget.class, KiePMMLTargetValue.class);
        CodegenTestUtils.commonValidateCompilationWithImports((Expression)retrieved, imports);
    }
}

