/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.commons.utils;

import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.dmg.pmml.Aggregate;
import org.dmg.pmml.Apply;
import org.dmg.pmml.Constant;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Discretize;
import org.dmg.pmml.Expression;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.Lag;
import org.dmg.pmml.MapValues;
import org.dmg.pmml.NormContinuous;
import org.dmg.pmml.NormDiscrete;
import org.dmg.pmml.TextIndex;
import org.kie.pmml.commons.exceptions.KiePMMLException;
import org.kie.pmml.compiler.commons.utils.ExpressionFunctionUtils;
import org.kie.pmml.compiler.commons.utils.ModelUtils;

public class DerivedFieldFunctionUtils {
    private DerivedFieldFunctionUtils() {
    }

    static Map<String, MethodDeclaration> getDerivedFieldsMethodMap(List<DerivedField> derivedFields, AtomicInteger arityCounter) {
        HashMap<String, MethodDeclaration> toReturn = new HashMap<String, MethodDeclaration>();
        derivedFields.forEach(derivedField -> toReturn.put(derivedField.getName().getValue(), DerivedFieldFunctionUtils.getDerivedFieldMethodDeclaration(derivedField, arityCounter)));
        return toReturn;
    }

    static MethodDeclaration getDerivedFieldMethodDeclaration(DerivedField derivedField, AtomicInteger arityCounter) {
        Expression expression = derivedField.getExpression();
        if (expression != null) {
            return DerivedFieldFunctionUtils.getExpressionMethodDeclaration(expression, derivedField.getDataType(), arityCounter);
        }
        throw new KiePMMLException("Derived field without Expression are not supported, yet");
    }

    static MethodDeclaration getExpressionMethodDeclaration(Expression expression, DataType dataType, AtomicInteger arityCounter) {
        ClassOrInterfaceType returnedType = StaticJavaParser.parseClassOrInterfaceType((String)ModelUtils.getBoxedClassName(dataType));
        int methodArity = arityCounter.addAndGet(1);
        if (expression instanceof Aggregate) {
            return DerivedFieldFunctionUtils.getAggregatedMethodDeclaration((Aggregate)expression, returnedType, methodArity, ExpressionFunctionUtils.DEFAULT_PARAMETERTYPE_MAP);
        }
        if (expression instanceof Apply) {
            return DerivedFieldFunctionUtils.getApplyMethodDeclaration((Apply)expression, returnedType, methodArity, ExpressionFunctionUtils.DEFAULT_PARAMETERTYPE_MAP);
        }
        if (expression instanceof Constant) {
            return DerivedFieldFunctionUtils.getConstantMethodDeclaration((Constant)expression, returnedType, methodArity, ExpressionFunctionUtils.DEFAULT_PARAMETERTYPE_MAP);
        }
        if (expression instanceof Discretize) {
            return DerivedFieldFunctionUtils.getDiscretizeMethodDeclaration((Discretize)expression, returnedType, methodArity, ExpressionFunctionUtils.DEFAULT_PARAMETERTYPE_MAP);
        }
        if (expression instanceof FieldRef) {
            return DerivedFieldFunctionUtils.getFieldRefMethodDeclaration((FieldRef)expression, returnedType, methodArity, ExpressionFunctionUtils.DEFAULT_PARAMETERTYPE_MAP);
        }
        if (expression instanceof Lag) {
            return DerivedFieldFunctionUtils.getLagMethodDeclaration((Lag)expression, returnedType, methodArity, ExpressionFunctionUtils.DEFAULT_PARAMETERTYPE_MAP);
        }
        if (expression instanceof MapValues) {
            return DerivedFieldFunctionUtils.getMapValuesMethodDeclaration((MapValues)expression, returnedType, methodArity, ExpressionFunctionUtils.DEFAULT_PARAMETERTYPE_MAP);
        }
        if (expression instanceof NormContinuous) {
            return DerivedFieldFunctionUtils.getNormContinuousMethodDeclaration((NormContinuous)expression, returnedType, methodArity, ExpressionFunctionUtils.DEFAULT_PARAMETERTYPE_MAP);
        }
        if (expression instanceof NormDiscrete) {
            return DerivedFieldFunctionUtils.getNormDiscreteMethodDeclaration((NormDiscrete)expression, returnedType, methodArity, ExpressionFunctionUtils.DEFAULT_PARAMETERTYPE_MAP);
        }
        if (expression instanceof TextIndex) {
            return DerivedFieldFunctionUtils.getTextIndexMethodDeclaration((TextIndex)expression, returnedType, methodArity, ExpressionFunctionUtils.DEFAULT_PARAMETERTYPE_MAP);
        }
        throw new IllegalArgumentException(String.format("Expression %s not managed", expression.getClass()));
    }

    static MethodDeclaration getAggregatedMethodDeclaration(Aggregate aggregate, ClassOrInterfaceType returnedType, int methodArity, LinkedHashMap<String, ClassOrInterfaceType> parameterNameTypeMap) {
        throw new KiePMMLException("Aggregate not managed, yet");
    }

    static MethodDeclaration getApplyMethodDeclaration(Apply apply, ClassOrInterfaceType returnedType, int methodArity, LinkedHashMap<String, ClassOrInterfaceType> parameterNameTypeMap) {
        String methodName = String.format("%s%s", apply.getClass().getSimpleName(), methodArity);
        return ExpressionFunctionUtils.getApplyExpressionMethodDeclaration(methodName, apply, returnedType, parameterNameTypeMap);
    }

    static MethodDeclaration getConstantMethodDeclaration(Constant constant, ClassOrInterfaceType returnedType, int methodArity, LinkedHashMap<String, ClassOrInterfaceType> parameterNameTypeMap) {
        String methodName = String.format("%s%s", constant.getClass().getSimpleName(), methodArity);
        return ExpressionFunctionUtils.getConstantExpressionMethodDeclaration(methodName, constant, returnedType, parameterNameTypeMap);
    }

    static MethodDeclaration getDiscretizeMethodDeclaration(Discretize discretize, ClassOrInterfaceType returnedType, int methodArity, LinkedHashMap<String, ClassOrInterfaceType> parameterNameTypeMap) {
        throw new KiePMMLException("Discretize not managed, yet");
    }

    static MethodDeclaration getFieldRefMethodDeclaration(FieldRef fieldRef, ClassOrInterfaceType returnedType, int methodArity, LinkedHashMap<String, ClassOrInterfaceType> parameterNameTypeMap) {
        String methodName = String.format("%s%s", fieldRef.getClass().getSimpleName(), methodArity);
        return ExpressionFunctionUtils.getFieldRefExpressionMethodDeclaration(methodName, fieldRef, returnedType, parameterNameTypeMap);
    }

    static MethodDeclaration getLagMethodDeclaration(Lag lag, ClassOrInterfaceType returnedType, int methodArity, LinkedHashMap<String, ClassOrInterfaceType> parameterNameTypeMap) {
        throw new KiePMMLException("Lag not managed, yet");
    }

    static MethodDeclaration getMapValuesMethodDeclaration(MapValues mapValues, ClassOrInterfaceType returnedType, int methodArity, LinkedHashMap<String, ClassOrInterfaceType> parameterNameTypeMap) {
        throw new KiePMMLException("MapValues not managed, yet");
    }

    static MethodDeclaration getNormContinuousMethodDeclaration(NormContinuous normContinuous, ClassOrInterfaceType returnedType, int methodArity, Map<String, ClassOrInterfaceType> parameterNameTypeMap) {
        throw new KiePMMLException("NormContinuous not managed, yet");
    }

    static MethodDeclaration getNormDiscreteMethodDeclaration(NormDiscrete normDiscrete, ClassOrInterfaceType returnedType, int methodArity, LinkedHashMap<String, ClassOrInterfaceType> parameterNameTypeMap) {
        throw new KiePMMLException("NormDiscrete not managed, yet");
    }

    static MethodDeclaration getTextIndexMethodDeclaration(TextIndex textIndex, ClassOrInterfaceType returnedType, int methodArity, LinkedHashMap<String, ClassOrInterfaceType> parameterNameTypeMap) {
        throw new KiePMMLException("TextIndex not managed, yet");
    }
}

