/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.commons.utils;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.xml.bind.JAXBException;
import org.dmg.pmml.Model;
import org.dmg.pmml.PMML;
import org.dmg.pmml.mining.MiningModel;
import org.dmg.pmml.mining.Segment;
import org.junit.Assert;
import org.junit.Test;
import org.kie.pmml.compiler.commons.utils.KiePMMLUtil;
import org.kie.test.util.filesystem.FileUtils;
import org.xml.sax.SAXException;

public class KiePMMLUtilTest {
    private static final String NO_MODELNAME_SAMPLE_NAME = "NoModelNameSample.pmml";
    private static final String NO_MODELNAME_NO_SEGMENTID_SAMPLE_NAME = "NoModelNameNoSegmentIdSample.pmml";

    @Test
    public void loadString() throws IOException, JAXBException, SAXException {
        this.commonLoadString(NO_MODELNAME_SAMPLE_NAME);
        this.commonLoadString(NO_MODELNAME_NO_SEGMENTID_SAMPLE_NAME);
    }

    @Test
    public void loadFile() throws JAXBException, IOException, SAXException {
        this.commonLoadFile(NO_MODELNAME_SAMPLE_NAME);
        this.commonLoadFile(NO_MODELNAME_NO_SEGMENTID_SAMPLE_NAME);
    }

    @Test
    public void getSanitizedId() {
        String modelName = "MODEL_NAME";
        String id = "2";
        String expected = String.format("%sSegment%s", "MODEL_NAME", id);
        String retrieved = KiePMMLUtil.getSanitizedId((String)id, (String)"MODEL_NAME");
        Assert.assertEquals((Object)expected, (Object)retrieved);
        id = "34.5";
        expected = String.format("%sSegment%s", "MODEL_NAME", id);
        retrieved = KiePMMLUtil.getSanitizedId((String)id, (String)"MODEL_NAME");
        Assert.assertEquals((Object)expected, (Object)retrieved);
        id = "3,45";
        expected = String.format("%sSegment%s", "MODEL_NAME", id);
        retrieved = KiePMMLUtil.getSanitizedId((String)id, (String)"MODEL_NAME");
        Assert.assertEquals((Object)expected, (Object)retrieved);
    }

    private void commonLoadString(String fileName) throws IOException, JAXBException, SAXException {
        FileInputStream inputStream = FileUtils.getFileInputStream((String)fileName);
        StringBuilder textBuilder = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)inputStream, Charset.forName(StandardCharsets.UTF_8.name())));){
            int c = 0;
            while ((c = ((Reader)reader).read()) != -1) {
                textBuilder.append((char)c);
            }
        }
        PMML retrieved = KiePMMLUtil.load((String)textBuilder.toString());
        this.commonValidatePMML(retrieved);
    }

    private void commonLoadFile(String fileName) throws IOException, JAXBException, SAXException {
        PMML retrieved = KiePMMLUtil.load((InputStream)FileUtils.getFileInputStream((String)fileName), (String)fileName);
        this.commonValidatePMML(retrieved);
    }

    private void commonValidatePMML(PMML toValidate) {
        Assert.assertNotNull((Object)toValidate);
        for (Model model : toValidate.getModels()) {
            Assert.assertNotNull((Object)model.getModelName());
            if (!(model instanceof MiningModel)) continue;
            this.commonValidateMiningModel((MiningModel)model);
        }
    }

    private void commonValidateMiningModel(MiningModel toValidate) {
        Assert.assertNotNull((Object)toValidate);
        for (Segment segment : toValidate.getSegmentation().getSegments()) {
            Assert.assertNotNull((Object)segment.getId());
            Model segmentModel = segment.getModel();
            Assert.assertNotNull((Object)segmentModel.getModelName());
            if (!(segmentModel instanceof MiningModel)) continue;
            this.commonValidateMiningModel((MiningModel)segmentModel);
        }
    }
}

