/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.commons.utils;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.PackageDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.TypeDeclaration;
import com.github.javaparser.ast.expr.Name;
import org.junit.Assert;
import org.junit.Test;
import org.kie.pmml.commons.exceptions.KiePMMLInternalException;
import org.kie.pmml.compiler.commons.utils.JavaParserUtils;

public class JavaParserUtilsTest {
    private static final String TEMPLATE_FILE = "Template.tmpl";
    private static final String TEMPLATE_CLASS = "Template";
    private static final String NOT_PARSABLE_FILE = "Unparsable.tmpl";

    @Test
    public void getFromFileName() {
        CompilationUnit retrieved = JavaParserUtils.getFromFileName((String)TEMPLATE_FILE);
        Assert.assertNotNull((Object)retrieved);
    }

    @Test(expected=KiePMMLInternalException.class)
    public void getFromFileNameNotParsable() {
        JavaParserUtils.getFromFileName((String)NOT_PARSABLE_FILE);
    }

    @Test(expected=AssertionError.class)
    public void getFromFileNameNotExisting() {
        JavaParserUtils.getFromFileName((String)"not_existing");
    }

    @Test
    public void getKiePMMLModelCompilationUnitWithPackage() {
        String className = "ClassName";
        String packageName = "apackage";
        CompilationUnit retrieved = JavaParserUtils.getKiePMMLModelCompilationUnit((String)className, (String)packageName, (String)TEMPLATE_FILE, (String)TEMPLATE_CLASS);
        Assert.assertNotNull((Object)retrieved);
        Assert.assertTrue((boolean)retrieved.getPackageDeclaration().isPresent());
        Assert.assertEquals((Object)packageName, (Object)((PackageDeclaration)retrieved.getPackageDeclaration().get()).getName().asString());
        Assert.assertFalse((boolean)retrieved.getClassByName(TEMPLATE_CLASS).isPresent());
        Assert.assertTrue((boolean)retrieved.getClassByName(className).isPresent());
    }

    @Test
    public void getKiePMMLModelCompilationUnitWithoutPackage() {
        String className = "ClassName";
        CompilationUnit retrieved = JavaParserUtils.getKiePMMLModelCompilationUnit((String)className, null, (String)TEMPLATE_FILE, (String)TEMPLATE_CLASS);
        Assert.assertNotNull((Object)retrieved);
        Assert.assertFalse((boolean)retrieved.getPackageDeclaration().isPresent());
        Assert.assertFalse((boolean)retrieved.getClassByName(TEMPLATE_CLASS).isPresent());
        Assert.assertTrue((boolean)retrieved.getClassByName(className).isPresent());
    }

    @Test
    public void getFullClassName() {
        String className = "ClassName";
        String packageName = "apackage";
        PackageDeclaration packageDeclaration = new PackageDeclaration();
        packageDeclaration.setName(new Name(packageName));
        ClassOrInterfaceDeclaration classOrInterfaceDeclaration = new ClassOrInterfaceDeclaration();
        classOrInterfaceDeclaration.setName(className);
        CompilationUnit compilationUnit = new CompilationUnit();
        compilationUnit.setPackageDeclaration(packageDeclaration);
        compilationUnit.setTypes(NodeList.nodeList((Node[])new TypeDeclaration[]{classOrInterfaceDeclaration}));
        String retrieved = JavaParserUtils.getFullClassName((CompilationUnit)compilationUnit);
        String expected = packageName + "." + className;
        Assert.assertEquals((Object)expected, (Object)retrieved);
    }
}

