/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.commons.implementations;

import java.io.InputStream;
import java.util.Optional;
import org.dmg.pmml.DataDictionary;
import org.dmg.pmml.Model;
import org.dmg.pmml.PMML;
import org.dmg.pmml.TransformationDictionary;
import org.junit.Assert;
import org.junit.Test;
import org.kie.pmml.compiler.commons.implementations.KiePMMLModelRetriever;
import org.kie.pmml.compiler.commons.utils.KiePMMLUtil;
import org.kie.test.util.filesystem.FileUtils;

public class KiePMMLModelRetrieverTest {
    private static final String MULTIPLE_TARGETS_SOURCE = "MultipleTargetsFieldSample.pmml";
    private static final String ONE_MINING_TARGET_SOURCE = "OneMiningTargetFieldSample.pmml";
    private static final String PACKAGE_NAME = "packagename";
    private PMML pmmlModel;

    @Test
    public void getFromCommonDataAndTransformationDictionaryAndModelWithProvider() throws Exception {
        this.pmmlModel = KiePMMLUtil.load((InputStream)FileUtils.getFileInputStream((String)MULTIPLE_TARGETS_SOURCE), (String)MULTIPLE_TARGETS_SOURCE);
        Optional retrieved = KiePMMLModelRetriever.getFromCommonDataAndTransformationDictionaryAndModel((DataDictionary)this.pmmlModel.getDataDictionary(), (TransformationDictionary)this.pmmlModel.getTransformationDictionary(), (Model)((Model)this.pmmlModel.getModels().get(0)), null);
        Assert.assertNotNull((Object)retrieved);
    }

    @Test
    public void getFromCommonDataAndTransformationDictionaryAndModelWithoutProvider() throws Exception {
        this.pmmlModel = KiePMMLUtil.load((InputStream)FileUtils.getFileInputStream((String)ONE_MINING_TARGET_SOURCE), (String)ONE_MINING_TARGET_SOURCE);
        Optional retrieved = KiePMMLModelRetriever.getFromCommonDataAndTransformationDictionaryAndModel((DataDictionary)this.pmmlModel.getDataDictionary(), (TransformationDictionary)this.pmmlModel.getTransformationDictionary(), (Model)((Model)this.pmmlModel.getModels().get(0)), null);
        Assert.assertNotNull((Object)retrieved);
        Assert.assertFalse((boolean)retrieved.isPresent());
    }

    @Test
    public void getFromCommonDataAndTransformationDictionaryAndModelFromPluginWithProvider() throws Exception {
        this.pmmlModel = KiePMMLUtil.load((InputStream)FileUtils.getFileInputStream((String)MULTIPLE_TARGETS_SOURCE), (String)MULTIPLE_TARGETS_SOURCE);
        Optional retrieved = KiePMMLModelRetriever.getFromCommonDataAndTransformationDictionaryAndModelFromPlugin((String)PACKAGE_NAME, (DataDictionary)this.pmmlModel.getDataDictionary(), (TransformationDictionary)this.pmmlModel.getTransformationDictionary(), (Model)((Model)this.pmmlModel.getModels().get(0)), null);
        Assert.assertNotNull((Object)retrieved);
    }

    @Test
    public void getFromDataDictionaryAndModelWithoutProvider() throws Exception {
        this.pmmlModel = KiePMMLUtil.load((InputStream)FileUtils.getFileInputStream((String)ONE_MINING_TARGET_SOURCE), (String)ONE_MINING_TARGET_SOURCE);
        Optional retrieved = KiePMMLModelRetriever.getFromCommonDataAndTransformationDictionaryAndModelFromPlugin((String)PACKAGE_NAME, (DataDictionary)this.pmmlModel.getDataDictionary(), (TransformationDictionary)this.pmmlModel.getTransformationDictionary(), (Model)((Model)this.pmmlModel.getModels().get(0)), null);
        Assert.assertNotNull((Object)retrieved);
        Assert.assertFalse((boolean)retrieved.isPresent());
    }
}

