/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.signavio.feel.runtime.functions;

import java.util.Arrays;
import java.util.List;
import org.kie.dmn.api.feel.runtime.events.FEELEvent;
import org.kie.dmn.feel.runtime.events.InvalidParametersEvent;
import org.kie.dmn.feel.runtime.functions.BaseFEELFunction;
import org.kie.dmn.feel.runtime.functions.FEELFnResult;
import org.kie.dmn.feel.runtime.functions.ParameterName;

public class ConcatFunction
extends BaseFEELFunction {
    public ConcatFunction() {
        super("concat");
    }

    public FEELFnResult<String> invoke(@ParameterName(value="values") List<?> list) {
        if (list == null) {
            return FEELFnResult.ofError((FEELEvent)new InvalidParametersEvent(FEELEvent.Severity.ERROR, "list", "cannot be null"));
        }
        if (list.contains(null)) {
            return FEELFnResult.ofError((FEELEvent)new InvalidParametersEvent(FEELEvent.Severity.ERROR, "list", "cannot contain null values"));
        }
        StringBuilder sb = new StringBuilder();
        for (Object element : list) {
            if (!(element instanceof String)) {
                return FEELFnResult.ofError((FEELEvent)new InvalidParametersEvent(FEELEvent.Severity.ERROR, "list", "contains an element that is not a string"));
            }
            sb.append(element);
        }
        return FEELFnResult.ofResult((Object)sb.toString());
    }

    public FEELFnResult<String> invoke(@ParameterName(value="values") Object[] list) {
        return this.invoke(Arrays.asList(list));
    }

    public FEELFnResult<String> invoke() {
        return FEELFnResult.ofError((FEELEvent)new InvalidParametersEvent(FEELEvent.Severity.ERROR, "list", "is missing"));
    }
}

