/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.signavio.feel.runtime.functions;

import java.math.BigDecimal;
import java.time.DateTimeException;
import java.time.Duration;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.util.function.Function;
import org.kie.dmn.api.feel.runtime.events.FEELEvent;
import org.kie.dmn.feel.lang.types.BuiltInType;
import org.kie.dmn.feel.runtime.events.InvalidParametersEvent;
import org.kie.dmn.feel.runtime.functions.BaseFEELFunction;
import org.kie.dmn.feel.runtime.functions.BuiltInFunctions;
import org.kie.dmn.feel.runtime.functions.DateAndTimeFunction;
import org.kie.dmn.feel.runtime.functions.FEELFnResult;
import org.kie.dmn.feel.runtime.functions.ParameterName;
import org.kie.dmn.feel.util.EvalHelper;

public class DayDiffFunction
extends BaseFEELFunction {
    public DayDiffFunction() {
        super("dayDiff");
    }

    public FEELFnResult<BigDecimal> invoke(@ParameterName(value="datetime1") TemporalAccessor datetime1, @ParameterName(value="datetime2") TemporalAccessor datetime2) {
        if (datetime1 == null) {
            return FEELFnResult.ofError((FEELEvent)new InvalidParametersEvent(FEELEvent.Severity.ERROR, "datetime1", "cannot be null"));
        }
        if (datetime2 == null) {
            return FEELFnResult.ofError((FEELEvent)new InvalidParametersEvent(FEELEvent.Severity.ERROR, "datetime2", "cannot be null"));
        }
        try {
            return FEELFnResult.ofResult((Object)EvalHelper.getBigDecimalOrNull((Object)Duration.between((Temporal)datetime1, (Temporal)datetime2).toDays()));
        }
        catch (DateTimeException e) {
            return FEELFnResult.ofError((FEELEvent)new InvalidParametersEvent(FEELEvent.Severity.ERROR, "datetime", "invalid 'date' or 'date and time' parameter", (Throwable)e));
        }
    }

    public FEELFnResult<BigDecimal> invoke(@ParameterName(value="datetime1") String datetime1, @ParameterName(value="datetime2") String datetime2) {
        if (datetime1 == null) {
            return FEELFnResult.ofError((FEELEvent)new InvalidParametersEvent(FEELEvent.Severity.ERROR, "datetime1", "cannot be null"));
        }
        if (datetime2 == null) {
            return FEELFnResult.ofError((FEELEvent)new InvalidParametersEvent(FEELEvent.Severity.ERROR, "datetime2", "cannot be null"));
        }
        try {
            TemporalAccessor dt1 = (TemporalAccessor)((DateAndTimeFunction)BuiltInFunctions.getFunction(DateAndTimeFunction.class)).invoke(datetime1).cata(BuiltInType.justNull(), Function.identity());
            TemporalAccessor dt2 = (TemporalAccessor)((DateAndTimeFunction)BuiltInFunctions.getFunction(DateAndTimeFunction.class)).invoke(datetime2).cata(BuiltInType.justNull(), Function.identity());
            return this.invoke(dt1, dt2);
        }
        catch (DateTimeException e) {
            return FEELFnResult.ofError((FEELEvent)new InvalidParametersEvent(FEELEvent.Severity.ERROR, "datetime", "invalid 'date' or 'date and time' parameter", (Throwable)e));
        }
    }
}

