/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.runtime.functions.twovaluelogic;

import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.Before;
import org.junit.Test;
import org.kie.dmn.feel.runtime.events.InvalidParametersEvent;
import org.kie.dmn.feel.runtime.functions.FunctionTestUtil;
import org.kie.dmn.feel.runtime.functions.twovaluelogic.NNStddevFunction;

public class StddevFunctionTest {
    private NNStddevFunction stddevFunction;

    @Before
    public void setUp() {
        this.stddevFunction = NNStddevFunction.INSTANCE;
    }

    @Test
    public void invokeNumberNull() {
        FunctionTestUtil.assertResult(this.stddevFunction.invoke((Object)null), null, new String[0]);
    }

    @Test
    public void invokeSingleNumber() {
        FunctionTestUtil.assertResultError(this.stddevFunction.invoke((Object)BigDecimal.TEN), InvalidParametersEvent.class, new String[0]);
        FunctionTestUtil.assertResultError(this.stddevFunction.invoke((Object)10), InvalidParametersEvent.class, new String[0]);
        FunctionTestUtil.assertResultError(this.stddevFunction.invoke((Object)10.0), InvalidParametersEvent.class, new String[0]);
        FunctionTestUtil.assertResultError(this.stddevFunction.invoke((Object)10.1), InvalidParametersEvent.class, new String[0]);
        FunctionTestUtil.assertResultError(this.stddevFunction.invoke((Object)Float.valueOf(10.1f)), InvalidParametersEvent.class, new String[0]);
    }

    @Test
    public void invokeUnconvertableNumber() {
        FunctionTestUtil.assertResultError(this.stddevFunction.invoke((Object)Double.POSITIVE_INFINITY), InvalidParametersEvent.class, new String[0]);
        FunctionTestUtil.assertResultError(this.stddevFunction.invoke((Object)Double.NEGATIVE_INFINITY), InvalidParametersEvent.class, new String[0]);
        FunctionTestUtil.assertResultError(this.stddevFunction.invoke((Object)Double.NaN), InvalidParametersEvent.class, new String[0]);
    }

    @Test
    public void invokeListNull() {
        FunctionTestUtil.assertResult(this.stddevFunction.invoke((List)null), null, new String[0]);
    }

    @Test
    public void invokeListEmpty() {
        FunctionTestUtil.assertResult(this.stddevFunction.invoke(Collections.emptyList()), null, new String[0]);
    }

    @Test
    public void invokeListTypeHeterogenous() {
        FunctionTestUtil.assertResultError(this.stddevFunction.invoke(Arrays.asList(1, "test")), InvalidParametersEvent.class, new String[0]);
    }

    @Test
    public void invokeListParamSupportedTypesWithNull() {
        FunctionTestUtil.assertResult(this.stddevFunction.invoke(Arrays.asList(20, 30, null, 40L, null, BigDecimal.TEN)), new BigDecimal("12.90994448735805628393088466594133", MathContext.DECIMAL128), new String[0]);
    }

    @Test
    public void invokeListWithIntegers() {
        FunctionTestUtil.assertResult(this.stddevFunction.invoke(Arrays.asList(10, 20, 30, 40)), new BigDecimal("12.90994448735805628393088466594133", MathContext.DECIMAL128), new String[0]);
    }

    @Test
    public void invokeListWithDoubles() {
        FunctionTestUtil.assertResult(this.stddevFunction.invoke(Arrays.asList(10.0, 20.0, 30.0, 40.0)), new BigDecimal("12.90994448735805628393088466594133", MathContext.DECIMAL128), new String[0]);
    }

    @Test
    public void invokeArrayNull() {
        FunctionTestUtil.assertResult(this.stddevFunction.invoke((Object[])null), null, new String[0]);
    }

    @Test
    public void invokeArrayEmpty() {
        FunctionTestUtil.assertResult(this.stddevFunction.invoke(new Object[0]), null, new String[0]);
    }

    @Test
    public void invokeArrayTypeHeterogenous() {
        FunctionTestUtil.assertResultError(this.stddevFunction.invoke(new Object[]{1, "test"}), InvalidParametersEvent.class, new String[0]);
    }

    @Test
    public void invokeArrayWithIntegers() {
        FunctionTestUtil.assertResult(this.stddevFunction.invoke(new Object[]{10, 20, 30, 40}), new BigDecimal("12.90994448735805628393088466594133", MathContext.DECIMAL128), new String[0]);
    }

    @Test
    public void invokeArrayWithDoubles() {
        FunctionTestUtil.assertResult(this.stddevFunction.invoke(new Object[]{10.0, 20.0, 30.0, 40.0}), new BigDecimal("12.90994448735805628393088466594133", MathContext.DECIMAL128), new String[0]);
    }

    @Test
    public void invokeArrayParamSupportedTypesWithNull() {
        FunctionTestUtil.assertResult(this.stddevFunction.invoke(new Object[]{20, 30, null, 40L, null, BigDecimal.TEN}), new BigDecimal("12.90994448735805628393088466594133", MathContext.DECIMAL128), new String[0]);
    }
}

