/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.runtime.functions.interval;

import org.junit.Before;
import org.junit.Test;
import org.kie.dmn.feel.runtime.Range;
import org.kie.dmn.feel.runtime.events.InvalidParametersEvent;
import org.kie.dmn.feel.runtime.functions.FunctionTestUtil;
import org.kie.dmn.feel.runtime.functions.interval.IncludesFunction;
import org.kie.dmn.feel.runtime.impl.RangeImpl;

public class IncludesFunctionTest {
    private IncludesFunction includesFunction;

    @Before
    public void setUp() {
        this.includesFunction = IncludesFunction.INSTANCE;
    }

    @Test
    public void invokeParamIsNull() {
        FunctionTestUtil.assertResultError(this.includesFunction.invoke(null, (Comparable)((Object)"b")), InvalidParametersEvent.class, new String[0]);
        FunctionTestUtil.assertResultError(this.includesFunction.invoke((Range)new RangeImpl(), (Comparable)null), InvalidParametersEvent.class, new String[0]);
    }

    @Test
    public void invokeParamsCantBeCompared() {
        FunctionTestUtil.assertResultError(this.includesFunction.invoke((Range)new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)((Object)"a"), (Comparable)((Object)"f"), Range.RangeBoundary.CLOSED), (Range)new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(2), Range.RangeBoundary.CLOSED)), InvalidParametersEvent.class, new String[0]);
    }

    @Test
    public void invokeParamRangeAndSingle() {
        FunctionTestUtil.assertResult(this.includesFunction.invoke((Range)new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)((Object)"a"), (Comparable)((Object)"f"), Range.RangeBoundary.CLOSED), (Comparable)((Object)"c")), Boolean.TRUE, new String[0]);
        FunctionTestUtil.assertResult(this.includesFunction.invoke((Range)new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)((Object)"a"), (Comparable)((Object)"f"), Range.RangeBoundary.CLOSED), (Comparable)((Object)"a")), Boolean.TRUE, new String[0]);
        FunctionTestUtil.assertResult(this.includesFunction.invoke((Range)new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)((Object)"a"), (Comparable)((Object)"f"), Range.RangeBoundary.OPEN), (Comparable)((Object)"f")), Boolean.FALSE, new String[0]);
        FunctionTestUtil.assertResult(this.includesFunction.invoke((Range)new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)((Object)"a"), (Comparable)((Object)"f"), Range.RangeBoundary.CLOSED), (Comparable)((Object)"g")), Boolean.FALSE, new String[0]);
    }

    @Test
    public void invokeParamRangeAndRange() {
        FunctionTestUtil.assertResult(this.includesFunction.invoke((Range)new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)((Object)"a"), (Comparable)((Object)"f"), Range.RangeBoundary.CLOSED), (Range)new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)((Object)"a"), (Comparable)((Object)"f"), Range.RangeBoundary.CLOSED)), Boolean.TRUE, new String[0]);
        FunctionTestUtil.assertResult(this.includesFunction.invoke((Range)new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)((Object)"a"), (Comparable)((Object)"f"), Range.RangeBoundary.CLOSED), (Range)new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)((Object)"c"), (Comparable)((Object)"d"), Range.RangeBoundary.CLOSED)), Boolean.TRUE, new String[0]);
        FunctionTestUtil.assertResult(this.includesFunction.invoke((Range)new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)((Object)"c"), (Comparable)((Object)"d"), Range.RangeBoundary.CLOSED), (Range)new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)((Object)"a"), (Comparable)((Object)"f"), Range.RangeBoundary.CLOSED)), Boolean.FALSE, new String[0]);
        FunctionTestUtil.assertResult(this.includesFunction.invoke((Range)new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)((Object)"a"), (Comparable)((Object)"f"), Range.RangeBoundary.CLOSED), (Range)new RangeImpl(Range.RangeBoundary.OPEN, (Comparable)((Object)"a"), (Comparable)((Object)"k"), Range.RangeBoundary.CLOSED)), Boolean.FALSE, new String[0]);
    }
}

