/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.runtime.functions;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAccessor;
import org.junit.Before;
import org.junit.Test;
import org.kie.dmn.feel.runtime.events.InvalidParametersEvent;
import org.kie.dmn.feel.runtime.functions.FunctionTestUtil;
import org.kie.dmn.feel.runtime.functions.WeekOfYearFunction;

public class WeekOfYearTest {
    private WeekOfYearFunction fut;

    @Before
    public void setUp() {
        this.fut = WeekOfYearFunction.INSTANCE;
    }

    @Test
    public void testWeekOfYearFunctionTemporalAccessor() {
        FunctionTestUtil.assertResult(this.fut.invoke((TemporalAccessor)LocalDate.of(2019, 9, 17)), BigDecimal.valueOf(38L), new String[0]);
        FunctionTestUtil.assertResult(this.fut.invoke((TemporalAccessor)LocalDateTime.of(2019, 9, 17, 0, 0, 0)), BigDecimal.valueOf(38L), new String[0]);
        FunctionTestUtil.assertResult(this.fut.invoke((TemporalAccessor)OffsetDateTime.of(2019, 9, 17, 0, 0, 0, 0, ZoneOffset.UTC)), BigDecimal.valueOf(38L), new String[0]);
        FunctionTestUtil.assertResult(this.fut.invoke((TemporalAccessor)ZonedDateTime.of(2019, 9, 17, 0, 0, 0, 0, ZoneOffset.UTC)), BigDecimal.valueOf(38L), new String[0]);
        FunctionTestUtil.assertResultError(this.fut.invoke(null), InvalidParametersEvent.class, new String[0]);
    }
}

