/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.runtime.functions;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAccessor;
import org.junit.Before;
import org.junit.Test;
import org.kie.dmn.feel.runtime.events.InvalidParametersEvent;
import org.kie.dmn.feel.runtime.functions.DateAndTimeFunction;
import org.kie.dmn.feel.runtime.functions.FunctionTestUtil;

public class DateTimeFunctionTest {
    private DateAndTimeFunction dateTimeFunction;

    @Before
    public void setUp() {
        this.dateTimeFunction = new DateAndTimeFunction();
    }

    @Test
    public void invokeParamStringNull() {
        FunctionTestUtil.assertResultError(this.dateTimeFunction.invoke(null), InvalidParametersEvent.class, new String[0]);
    }

    @Test
    public void invokeParamStringNotDateOrTime() {
        FunctionTestUtil.assertResultError(this.dateTimeFunction.invoke("test"), InvalidParametersEvent.class, new String[0]);
        FunctionTestUtil.assertResultError(this.dateTimeFunction.invoke("2017-09-test"), InvalidParametersEvent.class, new String[0]);
        FunctionTestUtil.assertResultError(this.dateTimeFunction.invoke("2017-09-T89"), InvalidParametersEvent.class, new String[0]);
    }

    @Test
    public void invokeParamStringDateTime() {
        FunctionTestUtil.assertResult(this.dateTimeFunction.invoke("2017-09-07T10:20:30"), LocalDateTime.of(2017, 9, 7, 10, 20, 30), new String[0]);
        FunctionTestUtil.assertResult(this.dateTimeFunction.invoke("99999-12-31T11:22:33"), LocalDateTime.of(99999, 12, 31, 11, 22, 33), new String[0]);
    }

    @Test
    public void invokeParamStringDateTimeZoned() {
        FunctionTestUtil.assertResult(this.dateTimeFunction.invoke("2011-12-31T10:15:30@Europe/Paris"), ZonedDateTime.of(2011, 12, 31, 10, 15, 30, 0, ZoneId.of("Europe/Paris")), new String[0]);
        FunctionTestUtil.assertResult(this.dateTimeFunction.invoke("2011-12-31T10:15:30.987@Europe/Paris"), ZonedDateTime.of(2011, 12, 31, 10, 15, 30, 987000000, ZoneId.of("Europe/Paris")), new String[0]);
        FunctionTestUtil.assertResult(this.dateTimeFunction.invoke("2011-12-31T10:15:30.123456789@Europe/Paris"), ZonedDateTime.of(2011, 12, 31, 10, 15, 30, 123456789, ZoneId.of("Europe/Paris")), new String[0]);
        FunctionTestUtil.assertResult(this.dateTimeFunction.invoke("999999999-12-31T23:59:59.999999999@Europe/Paris"), ZonedDateTime.of(999999999, 12, 31, 23, 59, 59, 999999999, ZoneId.of("Europe/Paris")), new String[0]);
    }

    @Test
    public void invokeParamStringDateOffset() {
        FunctionTestUtil.assertResult(this.dateTimeFunction.invoke("2017-12-31T23:59:59.999999999+02:00"), ZonedDateTime.of(2017, 12, 31, 23, 59, 59, 999999999, ZoneOffset.of("+02:00")), new String[0]);
        FunctionTestUtil.assertResult(this.dateTimeFunction.invoke("-999999999-12-31T23:59:59.999999999+02:00"), ZonedDateTime.of(-999999999, 12, 31, 23, 59, 59, 999999999, ZoneOffset.of("+02:00")), new String[0]);
    }

    @Test
    public void invokeParamStringDate() {
        FunctionTestUtil.assertResult(this.dateTimeFunction.invoke("2017-09-07"), LocalDateTime.of(2017, 9, 7, 0, 0, 0), new String[0]);
    }

    @Test
    public void invokeParamTemporalNulls() {
        FunctionTestUtil.assertResultError(this.dateTimeFunction.invoke((TemporalAccessor)null, null), InvalidParametersEvent.class, new String[0]);
        FunctionTestUtil.assertResultError(this.dateTimeFunction.invoke(null, (TemporalAccessor)LocalTime.of(10, 6, 20)), InvalidParametersEvent.class, new String[0]);
        FunctionTestUtil.assertResultError(this.dateTimeFunction.invoke((TemporalAccessor)LocalDate.of(2017, 6, 12), null), InvalidParametersEvent.class, new String[0]);
    }

    @Test
    public void invokeParamTemporalWrongTemporal() {
        FunctionTestUtil.assertResultError(this.dateTimeFunction.invoke((TemporalAccessor)LocalDate.of(2017, 6, 12), (TemporalAccessor)LocalDateTime.of(2017, 6, 12, 0, 0)), InvalidParametersEvent.class, new String[0]);
        FunctionTestUtil.assertResultError(this.dateTimeFunction.invoke((TemporalAccessor)LocalDateTime.of(2017, 6, 12, 0, 0), (TemporalAccessor)LocalDateTime.of(2017, 6, 12, 0, 0)), InvalidParametersEvent.class, new String[0]);
    }

    @Test
    public void invokeParamTemporalLocalTime() {
        FunctionTestUtil.assertResult(this.dateTimeFunction.invoke((TemporalAccessor)LocalDate.of(2017, 6, 12), (TemporalAccessor)LocalTime.of(10, 6, 20)), LocalDateTime.of(2017, 6, 12, 10, 6, 20), new String[0]);
    }

    @Test
    public void invokeParamTemporalOffsetTime() {
        FunctionTestUtil.assertResult(this.dateTimeFunction.invoke((TemporalAccessor)LocalDate.of(2017, 6, 12), (TemporalAccessor)OffsetTime.of(10, 6, 20, 0, ZoneOffset.UTC)), ZonedDateTime.of(2017, 6, 12, 10, 6, 20, 0, ZoneOffset.UTC), new String[0]);
    }
}

