/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.lang.impl;

import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.kie.dmn.feel.lang.impl.MapBackedType;
import org.kie.dmn.feel.lang.types.BuiltInType;
import org.kie.dmn.feel.util.DynamicTypeUtils;

public class MapBackedTypeTest {
    @Test
    public void testBasic() {
        MapBackedType personType = new MapBackedType("Person", DynamicTypeUtils.mapOf(DynamicTypeUtils.entry("First Name", BuiltInType.STRING), DynamicTypeUtils.entry("Last Name", BuiltInType.STRING)));
        Map aPerson = DynamicTypeUtils.prototype(DynamicTypeUtils.entry("First Name", "John"), DynamicTypeUtils.entry("Last Name", "Doe"));
        Assertions.assertThat((boolean)personType.isAssignableValue(aPerson)).isTrue();
        Assertions.assertThat((boolean)personType.isInstanceOf(aPerson)).isTrue();
        Map aCompletePerson = DynamicTypeUtils.prototype(DynamicTypeUtils.entry("First Name", "John"), DynamicTypeUtils.entry("Last Name", "Doe"), DynamicTypeUtils.entry("Address", "100 East Davie Street"));
        Assertions.assertThat((boolean)personType.isAssignableValue(aCompletePerson)).isTrue();
        Assertions.assertThat((boolean)personType.isInstanceOf(aCompletePerson)).isTrue();
        Map notAPerson = DynamicTypeUtils.prototype(DynamicTypeUtils.entry("First Name", "John"));
        Assertions.assertThat((boolean)personType.isAssignableValue(notAPerson)).isFalse();
        Assertions.assertThat((boolean)personType.isInstanceOf(notAPerson)).isFalse();
        Map anonymousPerson1 = DynamicTypeUtils.prototype(DynamicTypeUtils.entry("First Name", null), DynamicTypeUtils.entry("Last Name", "Doe"));
        Assertions.assertThat((boolean)personType.isAssignableValue(anonymousPerson1)).isTrue();
        Assertions.assertThat((boolean)personType.isInstanceOf(anonymousPerson1)).isTrue();
        Map anonymousPerson2 = DynamicTypeUtils.prototype(DynamicTypeUtils.entry("First Name", "John"), DynamicTypeUtils.entry("Last Name", null));
        Assertions.assertThat((boolean)personType.isAssignableValue(anonymousPerson2)).isTrue();
        Assertions.assertThat((boolean)personType.isInstanceOf(anonymousPerson2)).isTrue();
        Map anonymousPerson3 = DynamicTypeUtils.prototype(DynamicTypeUtils.entry("First Name", null), DynamicTypeUtils.entry("Last Name", null));
        Assertions.assertThat((boolean)personType.isAssignableValue(anonymousPerson3)).isTrue();
        Assertions.assertThat((boolean)personType.isInstanceOf(anonymousPerson3)).isTrue();
        Map anonymousCompletePerson = DynamicTypeUtils.prototype(DynamicTypeUtils.entry("First Name", null), DynamicTypeUtils.entry("Last Name", null), DynamicTypeUtils.entry("Address", "100 East Davie Street"));
        Assertions.assertThat((boolean)personType.isAssignableValue(anonymousCompletePerson)).isTrue();
        Assertions.assertThat((boolean)personType.isInstanceOf(anonymousCompletePerson)).isTrue();
        Object nullPerson = null;
        Assertions.assertThat((boolean)personType.isAssignableValue(nullPerson)).isTrue();
        Assertions.assertThat((boolean)personType.isInstanceOf(nullPerson)).isFalse();
    }
}

