/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.runtime.functions;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.Before;
import org.junit.Test;
import org.kie.dmn.feel.runtime.events.InvalidParametersEvent;
import org.kie.dmn.feel.runtime.functions.FunctionTestUtil;
import org.kie.dmn.feel.runtime.functions.SublistFunction;

public class SublistFunctionTest {
    private SublistFunction sublistFunction;

    @Before
    public void setUp() {
        this.sublistFunction = new SublistFunction();
    }

    @Test
    public void invokeNull() {
        FunctionTestUtil.assertResultError(this.sublistFunction.invoke((List)null, null), InvalidParametersEvent.class);
        FunctionTestUtil.assertResultError(this.sublistFunction.invoke(null, BigDecimal.ONE), InvalidParametersEvent.class);
        FunctionTestUtil.assertResultError(this.sublistFunction.invoke(Collections.emptyList(), null), InvalidParametersEvent.class);
    }

    @Test
    public void invokeStartZero() {
        FunctionTestUtil.assertResultError(this.sublistFunction.invoke(Arrays.asList(1, 2), BigDecimal.ZERO), InvalidParametersEvent.class);
    }

    @Test
    public void invokeStartOutOfListBounds() {
        FunctionTestUtil.assertResultError(this.sublistFunction.invoke(Arrays.asList(1, 2), BigDecimal.TEN), InvalidParametersEvent.class);
        FunctionTestUtil.assertResultError(this.sublistFunction.invoke(Arrays.asList(1, 2), BigDecimal.valueOf(-10L)), InvalidParametersEvent.class);
    }

    @Test
    public void invokeLengthNegative() {
        FunctionTestUtil.assertResultError(this.sublistFunction.invoke(Arrays.asList(1, 2), BigDecimal.valueOf(1L), BigDecimal.valueOf(-3L)), InvalidParametersEvent.class);
    }

    @Test
    public void invokeLengthOutOfListBounds() {
        FunctionTestUtil.assertResultError(this.sublistFunction.invoke(Arrays.asList(1, 2), BigDecimal.ONE, BigDecimal.valueOf(3L)), InvalidParametersEvent.class);
        FunctionTestUtil.assertResultError(this.sublistFunction.invoke(Arrays.asList(1, 2), BigDecimal.valueOf(-1L), BigDecimal.valueOf(3L)), InvalidParametersEvent.class);
    }

    @Test
    public void invokeStartPositive() {
        FunctionTestUtil.assertResult(this.sublistFunction.invoke(Arrays.asList(1, 2, 3), BigDecimal.valueOf(2L)), Arrays.asList(2, 3));
        FunctionTestUtil.assertResult(this.sublistFunction.invoke(Arrays.asList(1, "test", 3), BigDecimal.valueOf(2L)), Arrays.asList("test", 3));
        FunctionTestUtil.assertResult(this.sublistFunction.invoke(Arrays.asList(1, "test", 3), BigDecimal.valueOf(2L), BigDecimal.ONE), Collections.singletonList("test"));
    }

    @Test
    public void invokeStartNegative() {
        FunctionTestUtil.assertResult(this.sublistFunction.invoke(Arrays.asList(1, 2, 3), BigDecimal.valueOf(-2L)), Arrays.asList(2, 3));
        FunctionTestUtil.assertResult(this.sublistFunction.invoke(Arrays.asList(1, "test", 3), BigDecimal.valueOf(-2L)), Arrays.asList("test", 3));
        FunctionTestUtil.assertResult(this.sublistFunction.invoke(Arrays.asList(1, "test", 3), BigDecimal.valueOf(-2L), BigDecimal.ONE), Collections.singletonList("test"));
    }
}

