/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.parser.feel11;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.antlr.v4.runtime.tree.ParseTree;
import org.assertj.core.api.Assertions;
import org.junit.Ignore;
import org.junit.Test;
import org.kie.dmn.api.feel.runtime.events.FEELEvent;
import org.kie.dmn.feel.lang.Type;
import org.kie.dmn.feel.lang.ast.ASTNode;
import org.kie.dmn.feel.lang.ast.AtLiteralNode;
import org.kie.dmn.feel.lang.ast.BaseNode;
import org.kie.dmn.feel.lang.ast.BetweenNode;
import org.kie.dmn.feel.lang.ast.BooleanNode;
import org.kie.dmn.feel.lang.ast.ContextEntryNode;
import org.kie.dmn.feel.lang.ast.ContextNode;
import org.kie.dmn.feel.lang.ast.FilterExpressionNode;
import org.kie.dmn.feel.lang.ast.ForExpressionNode;
import org.kie.dmn.feel.lang.ast.FormalParameterNode;
import org.kie.dmn.feel.lang.ast.FunctionDefNode;
import org.kie.dmn.feel.lang.ast.FunctionInvocationNode;
import org.kie.dmn.feel.lang.ast.IfExpressionNode;
import org.kie.dmn.feel.lang.ast.InNode;
import org.kie.dmn.feel.lang.ast.InfixOpNode;
import org.kie.dmn.feel.lang.ast.InstanceOfNode;
import org.kie.dmn.feel.lang.ast.IterationContextNode;
import org.kie.dmn.feel.lang.ast.ListNode;
import org.kie.dmn.feel.lang.ast.NameDefNode;
import org.kie.dmn.feel.lang.ast.NameRefNode;
import org.kie.dmn.feel.lang.ast.NamedParameterNode;
import org.kie.dmn.feel.lang.ast.NullNode;
import org.kie.dmn.feel.lang.ast.NumberNode;
import org.kie.dmn.feel.lang.ast.PathExpressionNode;
import org.kie.dmn.feel.lang.ast.QualifiedNameNode;
import org.kie.dmn.feel.lang.ast.QuantifiedExpressionNode;
import org.kie.dmn.feel.lang.ast.RangeNode;
import org.kie.dmn.feel.lang.ast.SignedUnaryNode;
import org.kie.dmn.feel.lang.ast.StringNode;
import org.kie.dmn.feel.lang.ast.TypeNode;
import org.kie.dmn.feel.lang.impl.MapBackedType;
import org.kie.dmn.feel.lang.types.BuiltInType;
import org.kie.dmn.feel.parser.feel11.ASTBuilderVisitor;
import org.kie.dmn.feel.parser.feel11.FEELParser;
import org.kie.dmn.feel.parser.feel11.FEEL_1_1Parser;
import org.kie.dmn.feel.util.DynamicTypeUtils;
import org.kie.dmn.feel.util.Msg;

public class FEELParserTest {
    @Test
    public void testIntegerLiteral() {
        String inputExpression = "10";
        BaseNode number = this.parse(inputExpression);
        Assertions.assertThat((Object)number).isInstanceOf(NumberNode.class);
        Assertions.assertThat((Object)number.getResultType()).isEqualTo((Object)BuiltInType.NUMBER);
        FEELParserTest.assertLocation(inputExpression, (ASTNode)number);
    }

    @Test
    public void testNegativeIntegerLiteral() {
        String inputExpression = "-10";
        BaseNode number = this.parse(inputExpression);
        Assertions.assertThat((Object)number).isInstanceOf(SignedUnaryNode.class);
        Assertions.assertThat((Object)number.getResultType()).isEqualTo((Object)BuiltInType.NUMBER);
        FEELParserTest.assertLocation(inputExpression, (ASTNode)number);
        SignedUnaryNode sun = (SignedUnaryNode)number;
        Assertions.assertThat((Comparable)sun.getSign()).isEqualTo((Object)SignedUnaryNode.Sign.NEGATIVE);
        Assertions.assertThat((Object)sun.getExpression()).isInstanceOf(NumberNode.class);
        Assertions.assertThat((String)sun.getExpression().getText()).isEqualTo("10");
    }

    @Test
    public void testPositiveIntegerLiteral() {
        String inputExpression = "+10";
        BaseNode number = this.parse(inputExpression);
        Assertions.assertThat((Object)number).isInstanceOf(SignedUnaryNode.class);
        Assertions.assertThat((Object)number.getResultType()).isEqualTo((Object)BuiltInType.NUMBER);
        FEELParserTest.assertLocation(inputExpression, (ASTNode)number);
        SignedUnaryNode sun = (SignedUnaryNode)number;
        Assertions.assertThat((Comparable)sun.getSign()).isEqualTo((Object)SignedUnaryNode.Sign.POSITIVE);
        Assertions.assertThat((Object)sun.getExpression()).isInstanceOf(NumberNode.class);
        Assertions.assertThat((String)sun.getExpression().getText()).isEqualTo("10");
    }

    @Test
    public void testFloatLiteral() {
        String inputExpression = "10.5";
        BaseNode number = this.parse(inputExpression);
        Assertions.assertThat((Object)number).isInstanceOf(NumberNode.class);
        Assertions.assertThat((Object)number.getResultType()).isEqualTo((Object)BuiltInType.NUMBER);
        FEELParserTest.assertLocation(inputExpression, (ASTNode)number);
    }

    @Test
    public void testNegativeFloatLiteral() {
        String inputExpression = "-10.5";
        BaseNode number = this.parse(inputExpression);
        Assertions.assertThat((Object)number).isInstanceOf(SignedUnaryNode.class);
        Assertions.assertThat((Object)number.getResultType()).isEqualTo((Object)BuiltInType.NUMBER);
        FEELParserTest.assertLocation(inputExpression, (ASTNode)number);
        SignedUnaryNode sun = (SignedUnaryNode)number;
        Assertions.assertThat((Comparable)sun.getSign()).isEqualTo((Object)SignedUnaryNode.Sign.NEGATIVE);
        Assertions.assertThat((Object)sun.getExpression()).isInstanceOf(NumberNode.class);
        Assertions.assertThat((String)sun.getExpression().getText()).isEqualTo("10.5");
    }

    @Test
    public void testPositiveFloatLiteral() {
        String inputExpression = "+10.5";
        BaseNode number = this.parse(inputExpression);
        Assertions.assertThat((Object)number).isInstanceOf(SignedUnaryNode.class);
        Assertions.assertThat((Object)number.getResultType()).isEqualTo((Object)BuiltInType.NUMBER);
        FEELParserTest.assertLocation(inputExpression, (ASTNode)number);
        SignedUnaryNode sun = (SignedUnaryNode)number;
        Assertions.assertThat((Comparable)sun.getSign()).isEqualTo((Object)SignedUnaryNode.Sign.POSITIVE);
        Assertions.assertThat((Object)sun.getExpression()).isInstanceOf(NumberNode.class);
        Assertions.assertThat((String)sun.getExpression().getText()).isEqualTo("10.5");
    }

    @Test
    public void testBooleanTrueLiteral() {
        String inputExpression = "true";
        BaseNode bool = this.parse(inputExpression);
        Assertions.assertThat((Object)bool).isInstanceOf(BooleanNode.class);
        Assertions.assertThat((Object)bool.getResultType()).isEqualTo((Object)BuiltInType.BOOLEAN);
        FEELParserTest.assertLocation(inputExpression, (ASTNode)bool);
    }

    @Test
    public void testBooleanFalseLiteral() {
        String inputExpression = "false";
        BaseNode bool = this.parse(inputExpression);
        Assertions.assertThat((Object)bool).isInstanceOf(BooleanNode.class);
        Assertions.assertThat((Object)bool.getResultType()).isEqualTo((Object)BuiltInType.BOOLEAN);
        FEELParserTest.assertLocation(inputExpression, (ASTNode)bool);
    }

    @Test
    public void testAtLiteralDate() {
        String inputExpression = "@\"2016-07-29\"";
        BaseNode bool = this.parse(inputExpression);
        Assertions.assertThat((Object)bool).isInstanceOf(AtLiteralNode.class);
        Assertions.assertThat((Object)bool.getResultType()).isEqualTo((Object)BuiltInType.DATE);
        FEELParserTest.assertLocation(inputExpression, (ASTNode)bool);
    }

    @Test
    public void testAtLiteralTime() {
        String inputExpression = "@\"23:59:00\"";
        BaseNode bool = this.parse(inputExpression);
        Assertions.assertThat((Object)bool).isInstanceOf(AtLiteralNode.class);
        Assertions.assertThat((Object)bool.getResultType()).isEqualTo((Object)BuiltInType.TIME);
        FEELParserTest.assertLocation(inputExpression, (ASTNode)bool);
    }

    @Test
    public void testAtLiteralDateAndTime() {
        String inputExpression = "@\"2016-07-29T05:48:23\"";
        BaseNode bool = this.parse(inputExpression);
        Assertions.assertThat((Object)bool).isInstanceOf(AtLiteralNode.class);
        Assertions.assertThat((Object)bool.getResultType()).isEqualTo((Object)BuiltInType.DATE_TIME);
        FEELParserTest.assertLocation(inputExpression, (ASTNode)bool);
    }

    @Test
    public void testAtLiteralDuration() {
        String inputExpression = "@\"P2Y2M\"";
        BaseNode bool = this.parse(inputExpression);
        Assertions.assertThat((Object)bool).isInstanceOf(AtLiteralNode.class);
        Assertions.assertThat((Object)bool.getResultType()).isEqualTo((Object)BuiltInType.DURATION);
        FEELParserTest.assertLocation(inputExpression, (ASTNode)bool);
    }

    @Test
    public void testNullLiteral() {
        String inputExpression = "null";
        BaseNode nullLit = this.parse(inputExpression);
        Assertions.assertThat((Object)nullLit).isInstanceOf(NullNode.class);
        Assertions.assertThat((Object)nullLit.getResultType()).isEqualTo((Object)BuiltInType.UNKNOWN);
        FEELParserTest.assertLocation(inputExpression, (ASTNode)nullLit);
    }

    @Test
    public void testStringLiteral() {
        String inputExpression = "\"some string\"";
        BaseNode stringLit = this.parse(inputExpression);
        Assertions.assertThat((Object)stringLit).isInstanceOf(StringNode.class);
        Assertions.assertThat((Object)stringLit.getResultType()).isEqualTo((Object)BuiltInType.STRING);
        FEELParserTest.assertLocation(inputExpression, (ASTNode)stringLit);
        Assertions.assertThat((String)stringLit.getText()).isEqualTo(inputExpression);
    }

    @Test
    public void testNameReference() {
        String inputExpression = "someSimpleName";
        BaseNode nameRef = this.parse(inputExpression, DynamicTypeUtils.mapOf(DynamicTypeUtils.entry("someSimpleName", BuiltInType.STRING)));
        Assertions.assertThat((Object)nameRef).isInstanceOf(NameRefNode.class);
        Assertions.assertThat((Object)nameRef.getResultType()).isEqualTo((Object)BuiltInType.STRING);
        FEELParserTest.assertLocation(inputExpression, (ASTNode)nameRef);
    }

    @Test
    public void testQualifiedName() {
        String inputExpression = "My Person.Full Name";
        MapBackedType personType = new MapBackedType("Person", DynamicTypeUtils.mapOf(DynamicTypeUtils.entry("Full Name", BuiltInType.STRING), DynamicTypeUtils.entry("Age", BuiltInType.NUMBER)));
        BaseNode qualRef = this.parse(inputExpression, DynamicTypeUtils.mapOf(DynamicTypeUtils.entry("My Person", personType)));
        Assertions.assertThat((Object)qualRef).isInstanceOf(QualifiedNameNode.class);
        Assertions.assertThat((Object)qualRef.getResultType()).isEqualTo((Object)BuiltInType.STRING);
        List parts = ((QualifiedNameNode)qualRef).getParts();
        Assertions.assertThat((Object)((NameRefNode)parts.get(0))).isInstanceOf(NameRefNode.class);
        Assertions.assertThat((Object)((NameRefNode)parts.get(0)).getResultType()).isEqualTo((Object)personType);
        Assertions.assertThat((Object)((NameRefNode)parts.get(1))).isInstanceOf(NameRefNode.class);
        Assertions.assertThat((Object)((NameRefNode)parts.get(1)).getResultType()).isEqualTo((Object)BuiltInType.STRING);
        FEELParserTest.assertLocation(inputExpression, (ASTNode)qualRef);
    }

    @Test
    public void testParensWithLiteral() {
        String inputExpression = "(10.5 )";
        BaseNode number = this.parse(inputExpression);
        Assertions.assertThat((Object)number).isInstanceOf(NumberNode.class);
        Assertions.assertThat((Object)number.getResultType()).isEqualTo((Object)BuiltInType.NUMBER);
        Assertions.assertThat((String)number.getText()).isEqualTo("10.5");
    }

    @Test
    public void testLogicalNegation() {
        String inputExpression = "not ( true )";
        BaseNode neg = this.parse(inputExpression);
        Assertions.assertThat((Object)neg).isInstanceOf(FunctionInvocationNode.class);
        Assertions.assertThat((Object)neg.getResultType()).isEqualTo((Object)BuiltInType.UNKNOWN);
        Assertions.assertThat((String)neg.getText()).isEqualTo("not ( true )");
        FunctionInvocationNode not = (FunctionInvocationNode)neg;
        Assertions.assertThat((Object)((BaseNode)not.getParams().getElements().get(0))).isInstanceOf(BooleanNode.class);
        Assertions.assertThat((Object)((BaseNode)not.getParams().getElements().get(0)).getResultType()).isEqualTo((Object)BuiltInType.BOOLEAN);
        Assertions.assertThat((String)((BaseNode)not.getParams().getElements().get(0)).getText()).isEqualTo("true");
    }

    @Test
    public void testMultiplication() {
        String inputExpression = "10 * x";
        BaseNode infix = this.parse(inputExpression, DynamicTypeUtils.mapOf(DynamicTypeUtils.entry("x", BuiltInType.NUMBER)));
        Assertions.assertThat((Object)infix).isInstanceOf(InfixOpNode.class);
        Assertions.assertThat((Object)infix.getResultType()).isEqualTo((Object)BuiltInType.NUMBER);
        Assertions.assertThat((String)infix.getText()).isEqualTo(inputExpression);
        InfixOpNode mult = (InfixOpNode)infix;
        Assertions.assertThat((Object)mult.getLeft()).isInstanceOf(NumberNode.class);
        Assertions.assertThat((String)mult.getLeft().getText()).isEqualTo("10");
        Assertions.assertThat((Comparable)mult.getOperator()).isEqualTo((Object)InfixOpNode.InfixOperator.MULT);
        Assertions.assertThat((Object)mult.getRight()).isInstanceOf(NameRefNode.class);
        Assertions.assertThat((String)mult.getRight().getText()).isEqualTo("x");
    }

    @Test
    public void testDivision() {
        String inputExpression = "y / 5 * ( x )";
        BaseNode infix = this.parse(inputExpression, DynamicTypeUtils.mapOf(DynamicTypeUtils.entry("x", BuiltInType.NUMBER), DynamicTypeUtils.entry("y", BuiltInType.NUMBER)));
        Assertions.assertThat((Object)infix).isInstanceOf(InfixOpNode.class);
        Assertions.assertThat((Object)infix.getResultType()).isEqualTo((Object)BuiltInType.NUMBER);
        Assertions.assertThat((String)infix.getText()).isEqualTo(inputExpression);
        InfixOpNode mult = (InfixOpNode)infix;
        Assertions.assertThat((Object)mult.getLeft()).isInstanceOf(InfixOpNode.class);
        Assertions.assertThat((String)mult.getLeft().getText()).isEqualTo("y / 5");
        InfixOpNode div = (InfixOpNode)mult.getLeft();
        Assertions.assertThat((Object)div.getLeft()).isInstanceOf(NameRefNode.class);
        Assertions.assertThat((String)div.getLeft().getText()).isEqualTo("y");
        Assertions.assertThat((Comparable)div.getOperator()).isEqualTo((Object)InfixOpNode.InfixOperator.DIV);
        Assertions.assertThat((Object)div.getRight()).isInstanceOf(NumberNode.class);
        Assertions.assertThat((String)div.getRight().getText()).isEqualTo("5");
        Assertions.assertThat((Comparable)mult.getOperator()).isEqualTo((Object)InfixOpNode.InfixOperator.MULT);
        Assertions.assertThat((Object)mult.getRight()).isInstanceOf(NameRefNode.class);
        Assertions.assertThat((String)mult.getRight().getText()).isEqualTo("x");
    }

    @Test
    public void testPower1() {
        String inputExpression = "y * 5 ** 3";
        BaseNode infix = this.parse(inputExpression, DynamicTypeUtils.mapOf(DynamicTypeUtils.entry("y", BuiltInType.NUMBER)));
        Assertions.assertThat((Object)infix).isInstanceOf(InfixOpNode.class);
        Assertions.assertThat((Object)infix.getResultType()).isEqualTo((Object)BuiltInType.NUMBER);
        Assertions.assertThat((String)infix.getText()).isEqualTo(inputExpression);
        InfixOpNode mult = (InfixOpNode)infix;
        Assertions.assertThat((Object)mult.getLeft()).isInstanceOf(NameRefNode.class);
        Assertions.assertThat((String)mult.getLeft().getText()).isEqualTo("y");
        Assertions.assertThat((Comparable)mult.getOperator()).isEqualTo((Object)InfixOpNode.InfixOperator.MULT);
        Assertions.assertThat((Object)mult.getRight()).isInstanceOf(InfixOpNode.class);
        Assertions.assertThat((String)mult.getRight().getText()).isEqualTo("5 ** 3");
        InfixOpNode exp = (InfixOpNode)mult.getRight();
        Assertions.assertThat((Object)exp.getLeft()).isInstanceOf(NumberNode.class);
        Assertions.assertThat((String)exp.getLeft().getText()).isEqualTo("5");
        Assertions.assertThat((Comparable)exp.getOperator()).isEqualTo((Object)InfixOpNode.InfixOperator.POW);
        Assertions.assertThat((Object)exp.getRight()).isInstanceOf(NumberNode.class);
        Assertions.assertThat((String)exp.getRight().getText()).isEqualTo("3");
    }

    @Test
    public void testPower2() {
        String inputExpression = "(y * 5) ** 3";
        BaseNode infix = this.parse(inputExpression, DynamicTypeUtils.mapOf(DynamicTypeUtils.entry("y", BuiltInType.NUMBER)));
        Assertions.assertThat((Object)infix).isInstanceOf(InfixOpNode.class);
        Assertions.assertThat((Object)infix.getResultType()).isEqualTo((Object)BuiltInType.NUMBER);
        Assertions.assertThat((String)infix.getText()).isEqualTo(inputExpression);
        InfixOpNode exp = (InfixOpNode)infix;
        Assertions.assertThat((Object)exp.getLeft()).isInstanceOf(InfixOpNode.class);
        Assertions.assertThat((String)exp.getLeft().getText()).isEqualTo("y * 5");
        Assertions.assertThat((Comparable)exp.getOperator()).isEqualTo((Object)InfixOpNode.InfixOperator.POW);
        Assertions.assertThat((Object)exp.getRight()).isInstanceOf(NumberNode.class);
        Assertions.assertThat((String)exp.getRight().getText()).isEqualTo("3");
        InfixOpNode mult = (InfixOpNode)exp.getLeft();
        Assertions.assertThat((Object)mult.getLeft()).isInstanceOf(NameRefNode.class);
        Assertions.assertThat((String)mult.getLeft().getText()).isEqualTo("y");
        Assertions.assertThat((Comparable)mult.getOperator()).isEqualTo((Object)InfixOpNode.InfixOperator.MULT);
        Assertions.assertThat((Object)mult.getRight()).isInstanceOf(NumberNode.class);
        Assertions.assertThat((String)mult.getRight().getText()).isEqualTo("5");
    }

    @Test
    public void testPower3() {
        String inputExpression = "y ** 5 * 3";
        BaseNode infix = this.parse(inputExpression, DynamicTypeUtils.mapOf(DynamicTypeUtils.entry("y", BuiltInType.NUMBER)));
        Assertions.assertThat((Object)infix).isInstanceOf(InfixOpNode.class);
        Assertions.assertThat((Object)infix.getResultType()).isEqualTo((Object)BuiltInType.NUMBER);
        Assertions.assertThat((String)infix.getText()).isEqualTo(inputExpression);
        InfixOpNode mult = (InfixOpNode)infix;
        Assertions.assertThat((Object)mult.getLeft()).isInstanceOf(InfixOpNode.class);
        Assertions.assertThat((String)mult.getLeft().getText()).isEqualTo("y ** 5");
        Assertions.assertThat((Comparable)mult.getOperator()).isEqualTo((Object)InfixOpNode.InfixOperator.MULT);
        Assertions.assertThat((Object)mult.getRight()).isInstanceOf(NumberNode.class);
        Assertions.assertThat((String)mult.getRight().getText()).isEqualTo("3");
        InfixOpNode exp = (InfixOpNode)mult.getLeft();
        Assertions.assertThat((Object)exp.getLeft()).isInstanceOf(NameRefNode.class);
        Assertions.assertThat((String)exp.getLeft().getText()).isEqualTo("y");
        Assertions.assertThat((Comparable)exp.getOperator()).isEqualTo((Object)InfixOpNode.InfixOperator.POW);
        Assertions.assertThat((Object)exp.getRight()).isInstanceOf(NumberNode.class);
        Assertions.assertThat((String)exp.getRight().getText()).isEqualTo("5");
    }

    @Test
    public void testPower4() {
        String inputExpression = "y ** ( 5 * 3 )";
        BaseNode infix = this.parse(inputExpression, DynamicTypeUtils.mapOf(DynamicTypeUtils.entry("y", BuiltInType.NUMBER)));
        Assertions.assertThat((Object)infix).isInstanceOf(InfixOpNode.class);
        Assertions.assertThat((Object)infix.getResultType()).isEqualTo((Object)BuiltInType.NUMBER);
        Assertions.assertThat((String)infix.getText()).isEqualTo(inputExpression);
        InfixOpNode exp = (InfixOpNode)infix;
        Assertions.assertThat((Object)exp.getLeft()).isInstanceOf(NameRefNode.class);
        Assertions.assertThat((String)exp.getLeft().getText()).isEqualTo("y");
        Assertions.assertThat((Comparable)exp.getOperator()).isEqualTo((Object)InfixOpNode.InfixOperator.POW);
        Assertions.assertThat((Object)exp.getRight()).isInstanceOf(InfixOpNode.class);
        Assertions.assertThat((String)exp.getRight().getText()).isEqualTo("5 * 3");
        InfixOpNode mult = (InfixOpNode)exp.getRight();
        Assertions.assertThat((Object)mult.getLeft()).isInstanceOf(NumberNode.class);
        Assertions.assertThat((String)mult.getLeft().getText()).isEqualTo("5");
        Assertions.assertThat((Comparable)mult.getOperator()).isEqualTo((Object)InfixOpNode.InfixOperator.MULT);
        Assertions.assertThat((Object)mult.getRight()).isInstanceOf(NumberNode.class);
        Assertions.assertThat((String)mult.getRight().getText()).isEqualTo("3");
    }

    @Test
    public void testAdd1() {
        String inputExpression = "y + 5 * 3";
        BaseNode infix = this.parse(inputExpression, DynamicTypeUtils.mapOf(DynamicTypeUtils.entry("y", BuiltInType.NUMBER)));
        Assertions.assertThat((Object)infix).isInstanceOf(InfixOpNode.class);
        Assertions.assertThat((Object)infix.getResultType()).isEqualTo((Object)BuiltInType.NUMBER);
        Assertions.assertThat((String)infix.getText()).isEqualTo(inputExpression);
        InfixOpNode add = (InfixOpNode)infix;
        Assertions.assertThat((Object)add.getLeft()).isInstanceOf(NameRefNode.class);
        Assertions.assertThat((String)add.getLeft().getText()).isEqualTo("y");
        Assertions.assertThat((Comparable)add.getOperator()).isEqualTo((Object)InfixOpNode.InfixOperator.ADD);
        Assertions.assertThat((Object)add.getRight()).isInstanceOf(InfixOpNode.class);
        Assertions.assertThat((String)add.getRight().getText()).isEqualTo("5 * 3");
        InfixOpNode mult = (InfixOpNode)add.getRight();
        Assertions.assertThat((Object)mult.getLeft()).isInstanceOf(NumberNode.class);
        Assertions.assertThat((String)mult.getLeft().getText()).isEqualTo("5");
        Assertions.assertThat((Comparable)mult.getOperator()).isEqualTo((Object)InfixOpNode.InfixOperator.MULT);
        Assertions.assertThat((Object)mult.getRight()).isInstanceOf(NumberNode.class);
        Assertions.assertThat((String)mult.getRight().getText()).isEqualTo("3");
    }

    @Test
    public void testSub1() {
        String inputExpression = "(y - 5) ** 3";
        BaseNode infix = this.parse(inputExpression, DynamicTypeUtils.mapOf(DynamicTypeUtils.entry("y", BuiltInType.NUMBER)));
        Assertions.assertThat((Object)infix).isInstanceOf(InfixOpNode.class);
        Assertions.assertThat((Object)infix.getResultType()).isEqualTo((Object)BuiltInType.NUMBER);
        Assertions.assertThat((String)infix.getText()).isEqualTo(inputExpression);
        InfixOpNode sub = (InfixOpNode)infix;
        Assertions.assertThat((Object)sub.getLeft()).isInstanceOf(InfixOpNode.class);
        Assertions.assertThat((String)sub.getLeft().getText()).isEqualTo("y - 5");
        Assertions.assertThat((Comparable)sub.getOperator()).isEqualTo((Object)InfixOpNode.InfixOperator.POW);
        Assertions.assertThat((Object)sub.getRight()).isInstanceOf(NumberNode.class);
        Assertions.assertThat((String)sub.getRight().getText()).isEqualTo("3");
        InfixOpNode mult = (InfixOpNode)sub.getLeft();
        Assertions.assertThat((Object)mult.getLeft()).isInstanceOf(NameRefNode.class);
        Assertions.assertThat((String)mult.getLeft().getText()).isEqualTo("y");
        Assertions.assertThat((Comparable)mult.getOperator()).isEqualTo((Object)InfixOpNode.InfixOperator.SUB);
        Assertions.assertThat((Object)mult.getRight()).isInstanceOf(NumberNode.class);
        Assertions.assertThat((String)mult.getRight().getText()).isEqualTo("5");
    }

    @Test
    public void testBetween() {
        String inputExpression = "x between 10+y and 3**z";
        BaseNode between = this.parse(inputExpression);
        Assertions.assertThat((Object)between).isInstanceOf(BetweenNode.class);
        Assertions.assertThat((Object)between.getResultType()).isEqualTo((Object)BuiltInType.BOOLEAN);
        Assertions.assertThat((String)between.getText()).isEqualTo(inputExpression);
        BetweenNode btw = (BetweenNode)between;
        Assertions.assertThat((Object)btw.getValue()).isInstanceOf(NameRefNode.class);
        Assertions.assertThat((String)btw.getValue().getText()).isEqualTo("x");
        Assertions.assertThat((Object)btw.getStart()).isInstanceOf(InfixOpNode.class);
        Assertions.assertThat((String)btw.getStart().getText()).isEqualTo("10+y");
        Assertions.assertThat((Object)btw.getEnd()).isInstanceOf(InfixOpNode.class);
        Assertions.assertThat((String)btw.getEnd().getText()).isEqualTo("3**z");
    }

    @Test
    public void testInValueList() {
        String inputExpression = "x / 4 in ( 10+y, true, 80, someVar )";
        BaseNode inNode = this.parse(inputExpression);
        Assertions.assertThat((Object)inNode).isInstanceOf(InNode.class);
        Assertions.assertThat((Object)inNode.getResultType()).isEqualTo((Object)BuiltInType.BOOLEAN);
        Assertions.assertThat((String)inNode.getText()).isEqualTo(inputExpression);
        InNode in = (InNode)inNode;
        Assertions.assertThat((Object)in.getValue()).isInstanceOf(InfixOpNode.class);
        Assertions.assertThat((String)in.getValue().getText()).isEqualTo("x / 4");
        Assertions.assertThat((Object)in.getExprs()).isInstanceOf(ListNode.class);
        Assertions.assertThat((String)in.getExprs().getText()).isEqualTo("10+y, true, 80, someVar");
        ListNode list = (ListNode)in.getExprs();
        Assertions.assertThat((Object)((BaseNode)list.getElements().get(0))).isInstanceOf(InfixOpNode.class);
        Assertions.assertThat((Object)((BaseNode)list.getElements().get(1))).isInstanceOf(BooleanNode.class);
        Assertions.assertThat((Object)((BaseNode)list.getElements().get(2))).isInstanceOf(NumberNode.class);
        Assertions.assertThat((Object)((BaseNode)list.getElements().get(3))).isInstanceOf(NameRefNode.class);
    }

    @Test
    public void testInUnaryTestList() {
        String inputExpression = "x ** y in ( <=1000, >t, null, (2000..z[, ]z..2000], [(10+5)..(a*b)) )";
        BaseNode inNode = this.parse(inputExpression);
        Assertions.assertThat((Object)inNode).isInstanceOf(InNode.class);
        Assertions.assertThat((Object)inNode.getResultType()).isEqualTo((Object)BuiltInType.BOOLEAN);
        Assertions.assertThat((String)inNode.getText()).isEqualTo(inputExpression);
        InNode in = (InNode)inNode;
        Assertions.assertThat((Object)in.getValue()).isInstanceOf(InfixOpNode.class);
        Assertions.assertThat((String)in.getValue().getText()).isEqualTo("x ** y");
        Assertions.assertThat((Object)in.getExprs()).isInstanceOf(ListNode.class);
        Assertions.assertThat((String)in.getExprs().getText()).isEqualTo("<=1000, >t, null, (2000..z[, ]z..2000], [(10+5)..(a*b))");
        ListNode list = (ListNode)in.getExprs();
        Assertions.assertThat((Object)((BaseNode)list.getElements().get(0))).isInstanceOf(RangeNode.class);
        Assertions.assertThat((String)((BaseNode)list.getElements().get(0)).getText()).isEqualTo("<=1000");
        Assertions.assertThat((Object)((BaseNode)list.getElements().get(1))).isInstanceOf(RangeNode.class);
        Assertions.assertThat((String)((BaseNode)list.getElements().get(1)).getText()).isEqualTo(">t");
        Assertions.assertThat((Object)((BaseNode)list.getElements().get(2))).isInstanceOf(NullNode.class);
        Assertions.assertThat((String)((BaseNode)list.getElements().get(2)).getText()).isEqualTo("null");
        Assertions.assertThat((Object)((BaseNode)list.getElements().get(3))).isInstanceOf(RangeNode.class);
        RangeNode interval = (RangeNode)list.getElements().get(3);
        Assertions.assertThat((String)interval.getText()).isEqualTo("(2000..z[");
        Assertions.assertThat((Comparable)interval.getLowerBound()).isEqualTo((Object)RangeNode.IntervalBoundary.OPEN);
        Assertions.assertThat((Comparable)interval.getUpperBound()).isEqualTo((Object)RangeNode.IntervalBoundary.OPEN);
        Assertions.assertThat((Object)interval.getStart()).isInstanceOf(NumberNode.class);
        Assertions.assertThat((Object)interval.getEnd()).isInstanceOf(NameRefNode.class);
        Assertions.assertThat((Object)((BaseNode)list.getElements().get(4))).isInstanceOf(RangeNode.class);
        interval = (RangeNode)list.getElements().get(4);
        Assertions.assertThat((String)interval.getText()).isEqualTo("]z..2000]");
        Assertions.assertThat((Comparable)interval.getLowerBound()).isEqualTo((Object)RangeNode.IntervalBoundary.OPEN);
        Assertions.assertThat((Comparable)interval.getUpperBound()).isEqualTo((Object)RangeNode.IntervalBoundary.CLOSED);
        Assertions.assertThat((Object)interval.getStart()).isInstanceOf(NameRefNode.class);
        Assertions.assertThat((Object)interval.getEnd()).isInstanceOf(NumberNode.class);
        Assertions.assertThat((Object)((BaseNode)list.getElements().get(5))).isInstanceOf(RangeNode.class);
        interval = (RangeNode)list.getElements().get(5);
        Assertions.assertThat((String)interval.getText()).isEqualTo("[(10+5)..(a*b))");
        Assertions.assertThat((Comparable)interval.getLowerBound()).isEqualTo((Object)RangeNode.IntervalBoundary.CLOSED);
        Assertions.assertThat((Comparable)interval.getUpperBound()).isEqualTo((Object)RangeNode.IntervalBoundary.OPEN);
        Assertions.assertThat((Object)interval.getStart()).isInstanceOf(InfixOpNode.class);
        Assertions.assertThat((Object)interval.getEnd()).isInstanceOf(InfixOpNode.class);
    }

    @Test
    public void testInUnaryTest() {
        String inputExpression = "x - y in [(10+5)..(a*b))";
        BaseNode inNode = this.parse(inputExpression);
        Assertions.assertThat((Object)inNode).isInstanceOf(InNode.class);
        Assertions.assertThat((Object)inNode.getResultType()).isEqualTo((Object)BuiltInType.BOOLEAN);
        Assertions.assertThat((String)inNode.getText()).isEqualTo(inputExpression);
        InNode in = (InNode)inNode;
        Assertions.assertThat((Object)in.getValue()).isInstanceOf(InfixOpNode.class);
        Assertions.assertThat((String)in.getValue().getText()).isEqualTo("x - y");
        Assertions.assertThat((Object)in.getExprs()).isInstanceOf(RangeNode.class);
        Assertions.assertThat((String)in.getExprs().getText()).isEqualTo("[(10+5)..(a*b))");
    }

    @Test
    public void testInUnaryTestStrings() {
        String inputExpression = "name in [\"A\"..\"Z...\")";
        BaseNode inNode = this.parse("name in [\"A\"..\"Z...\")");
        Assertions.assertThat((Object)inNode).isInstanceOf(InNode.class);
        Assertions.assertThat((Object)inNode.getResultType()).isEqualTo((Object)BuiltInType.BOOLEAN);
        Assertions.assertThat((String)inNode.getText()).isEqualTo("name in [\"A\"..\"Z...\")");
        InNode in = (InNode)inNode;
        Assertions.assertThat((Object)in.getExprs()).isInstanceOf(RangeNode.class);
        RangeNode range = (RangeNode)in.getExprs();
        Assertions.assertThat((String)range.getStart().getText()).isEqualTo("\"A\"");
        Assertions.assertThat((String)range.getEnd().getText()).isEqualTo("\"Z...\"");
    }

    @Test
    public void testComparisonInFixOp() {
        String inputExpression = "foo >= bar * 10";
        BaseNode infix = this.parse(inputExpression);
        Assertions.assertThat((Object)infix).isInstanceOf(InfixOpNode.class);
        Assertions.assertThat((Object)infix.getResultType()).isEqualTo((Object)BuiltInType.BOOLEAN);
        Assertions.assertThat((String)infix.getText()).isEqualTo(inputExpression);
        InfixOpNode in = (InfixOpNode)infix;
        Assertions.assertThat((Object)in.getLeft()).isInstanceOf(NameRefNode.class);
        Assertions.assertThat((String)in.getLeft().getText()).isEqualTo("foo");
        Assertions.assertThat((Object)in.getRight()).isInstanceOf(InfixOpNode.class);
        Assertions.assertThat((String)in.getRight().getText()).isEqualTo("bar * 10");
    }

    @Test
    public void testConditionalLogicalOp() {
        String inputExpression = "foo < 10 and bar = \"x\" or baz";
        BaseNode infix = this.parse(inputExpression);
        Assertions.assertThat((Object)infix).isInstanceOf(InfixOpNode.class);
        Assertions.assertThat((Object)infix.getResultType()).isEqualTo((Object)BuiltInType.BOOLEAN);
        Assertions.assertThat((String)infix.getText()).isEqualTo(inputExpression);
        InfixOpNode or = (InfixOpNode)infix;
        Assertions.assertThat((Object)or.getLeft()).isInstanceOf(InfixOpNode.class);
        Assertions.assertThat((String)or.getLeft().getText()).isEqualTo("foo < 10 and bar = \"x\"");
        Assertions.assertThat((Comparable)or.getOperator()).isEqualTo((Object)InfixOpNode.InfixOperator.OR);
        Assertions.assertThat((Object)or.getRight()).isInstanceOf(NameRefNode.class);
        Assertions.assertThat((String)or.getRight().getText()).isEqualTo("baz");
        InfixOpNode and = (InfixOpNode)or.getLeft();
        Assertions.assertThat((Object)and.getLeft()).isInstanceOf(InfixOpNode.class);
        Assertions.assertThat((String)and.getLeft().getText()).isEqualTo("foo < 10");
        Assertions.assertThat((Comparable)and.getOperator()).isEqualTo((Object)InfixOpNode.InfixOperator.AND);
        Assertions.assertThat((Object)and.getRight()).isInstanceOf(InfixOpNode.class);
        Assertions.assertThat((String)and.getRight().getText()).isEqualTo("bar = \"x\"");
    }

    @Test
    public void testEmptyList() {
        String inputExpression = "[]";
        BaseNode list = this.parse(inputExpression);
        Assertions.assertThat((Object)list).isInstanceOf(ListNode.class);
        Assertions.assertThat((Object)list.getResultType()).isEqualTo((Object)BuiltInType.LIST);
        Assertions.assertThat((String)list.getText()).isEqualTo(inputExpression);
        ListNode ln = (ListNode)list;
        Assertions.assertThat((List)ln.getElements()).isEmpty();
    }

    @Test
    public void testExpressionList() {
        String inputExpression = "[ 10, foo * bar, true ]";
        BaseNode list = this.parse(inputExpression);
        Assertions.assertThat((Object)list).isInstanceOf(ListNode.class);
        Assertions.assertThat((Object)list.getResultType()).isEqualTo((Object)BuiltInType.LIST);
        Assertions.assertThat((String)list.getText()).isEqualTo("10, foo * bar, true");
        ListNode ln = (ListNode)list;
        Assertions.assertThat((int)ln.getElements().size()).isEqualTo(3);
        Assertions.assertThat((Object)((BaseNode)ln.getElements().get(0))).isInstanceOf(NumberNode.class);
        Assertions.assertThat((Object)((BaseNode)ln.getElements().get(1))).isInstanceOf(InfixOpNode.class);
        Assertions.assertThat((Object)((BaseNode)ln.getElements().get(2))).isInstanceOf(BooleanNode.class);
    }

    @Test
    public void testEmptyContext() {
        String inputExpression = "{}";
        BaseNode context = this.parse(inputExpression);
        Assertions.assertThat((Object)context).isInstanceOf(ContextNode.class);
        Assertions.assertThat((String)context.getText()).isEqualTo(inputExpression);
        ContextNode ctx = (ContextNode)context;
        Assertions.assertThat((List)ctx.getEntries()).isEmpty();
    }

    @Test
    public void testContextWithMultipleEntries() {
        String inputExpression = "{ \"a string key\" : 10, a non-string key : foo+bar, a key.with + /' odd chars : [10..50] }";
        BaseNode ctxbase = this.parse(inputExpression, DynamicTypeUtils.mapOf(DynamicTypeUtils.entry("foo", BuiltInType.NUMBER), DynamicTypeUtils.entry("bar", BuiltInType.NUMBER)));
        Assertions.assertThat((Object)ctxbase).isInstanceOf(ContextNode.class);
        Assertions.assertThat((String)ctxbase.getText()).isEqualTo(inputExpression);
        ContextNode ctx = (ContextNode)ctxbase;
        Assertions.assertThat((int)ctx.getEntries().size()).isEqualTo(3);
        ContextEntryNode entry = (ContextEntryNode)ctx.getEntries().get(0);
        Assertions.assertThat((Object)entry.getName()).isInstanceOf(StringNode.class);
        StringNode nameNode = (StringNode)entry.getName();
        Assertions.assertThat((String)nameNode.getText()).isNotNull();
        Assertions.assertThat((String)nameNode.getText()).isEqualTo("\"a string key\"");
        Assertions.assertThat((Object)entry.getValue()).isInstanceOf(NumberNode.class);
        Assertions.assertThat((Object)entry.getResultType()).isEqualTo((Object)BuiltInType.NUMBER);
        Assertions.assertThat((String)entry.getValue().getText()).isEqualTo("10");
        entry = (ContextEntryNode)ctx.getEntries().get(1);
        Assertions.assertThat((Object)entry.getName()).isInstanceOf(NameDefNode.class);
        NameDefNode name = (NameDefNode)entry.getName();
        Assertions.assertThat((List)name.getParts()).isNotNull();
        Assertions.assertThat((int)name.getParts().size()).isEqualTo(5);
        Assertions.assertThat((String)entry.getName().getText()).isEqualTo("a non-string key");
        Assertions.assertThat((Object)entry.getValue()).isInstanceOf(InfixOpNode.class);
        Assertions.assertThat((Object)entry.getResultType()).isEqualTo((Object)BuiltInType.NUMBER);
        Assertions.assertThat((String)entry.getValue().getText()).isEqualTo("foo+bar");
        entry = (ContextEntryNode)ctx.getEntries().get(2);
        Assertions.assertThat((Object)entry.getName()).isInstanceOf(NameDefNode.class);
        name = (NameDefNode)entry.getName();
        Assertions.assertThat((List)name.getParts()).isNotNull();
        Assertions.assertThat((int)name.getParts().size()).isEqualTo(9);
        Assertions.assertThat((String)entry.getName().getText()).isEqualTo("a key.with + /' odd chars");
        Assertions.assertThat((Object)entry.getValue()).isInstanceOf(RangeNode.class);
        Assertions.assertThat((Object)entry.getResultType()).isEqualTo((Object)BuiltInType.RANGE);
        Assertions.assertThat((String)entry.getValue().getText()).isEqualTo("[10..50]");
    }

    @Test
    public void testVariableWithInKeyword() {
        String inputExpression = "{ a variable with in keyword : 10,  another variable : a variable with in keyword + 20,  another in variable : an external in variable / 2 }";
        BaseNode ctxbase = this.parse(inputExpression, DynamicTypeUtils.mapOf(DynamicTypeUtils.entry("an external in variable", BuiltInType.NUMBER)));
        Assertions.assertThat((Object)ctxbase).isInstanceOf(ContextNode.class);
        Assertions.assertThat((String)ctxbase.getText()).isEqualTo(inputExpression);
        ContextNode ctx = (ContextNode)ctxbase;
        Assertions.assertThat((int)ctx.getEntries().size()).isEqualTo(3);
        ContextEntryNode entry = (ContextEntryNode)ctx.getEntries().get(0);
        Assertions.assertThat((Object)entry.getName()).isInstanceOf(NameDefNode.class);
        NameDefNode name = (NameDefNode)entry.getName();
        Assertions.assertThat((List)name.getParts()).isNotNull();
        Assertions.assertThat((int)name.getParts().size()).isEqualTo(5);
        Assertions.assertThat((String)entry.getName().getText()).isEqualTo("a variable with in keyword");
        Assertions.assertThat((Object)entry.getValue()).isInstanceOf(NumberNode.class);
        Assertions.assertThat((Object)entry.getResultType()).isEqualTo((Object)BuiltInType.NUMBER);
        Assertions.assertThat((String)entry.getValue().getText()).isEqualTo("10");
        entry = (ContextEntryNode)ctx.getEntries().get(1);
        Assertions.assertThat((Object)entry.getName()).isInstanceOf(NameDefNode.class);
        name = (NameDefNode)entry.getName();
        Assertions.assertThat((List)name.getParts()).isNotNull();
        Assertions.assertThat((int)name.getParts().size()).isEqualTo(2);
        Assertions.assertThat((String)entry.getName().getText()).isEqualTo("another variable");
        Assertions.assertThat((Object)entry.getValue()).isInstanceOf(InfixOpNode.class);
        Assertions.assertThat((Object)entry.getResultType()).isEqualTo((Object)BuiltInType.NUMBER);
        Assertions.assertThat((String)entry.getValue().getText()).isEqualTo("a variable with in keyword + 20");
        entry = (ContextEntryNode)ctx.getEntries().get(2);
        Assertions.assertThat((Object)entry.getName()).isInstanceOf(NameDefNode.class);
        name = (NameDefNode)entry.getName();
        Assertions.assertThat((List)name.getParts()).isNotNull();
        Assertions.assertThat((int)name.getParts().size()).isEqualTo(3);
        Assertions.assertThat((String)entry.getName().getText()).isEqualTo("another in variable");
        Assertions.assertThat((Object)entry.getValue()).isInstanceOf(InfixOpNode.class);
        Assertions.assertThat((Object)entry.getResultType()).isEqualTo((Object)BuiltInType.NUMBER);
        Assertions.assertThat((String)entry.getValue().getText()).isEqualTo("an external in variable / 2");
    }

    @Test
    public void testNestedContexts() {
        String inputExpression = "{ a value : 10, an applicant : {     first name : \"Edson\",     last + name : \"Tirelli\",     full name : first name + last + name,     address : {        street : \"55 broadway st\",        city : \"New York\"     },     xxx: last + name } }";
        BaseNode ctxbase = this.parse(inputExpression);
        Assertions.assertThat((Object)ctxbase).isInstanceOf(ContextNode.class);
        Assertions.assertThat((String)ctxbase.getText()).isEqualTo(inputExpression);
        ContextNode ctx = (ContextNode)ctxbase;
        Assertions.assertThat((int)ctx.getEntries().size()).isEqualTo(2);
        ContextEntryNode entry = (ContextEntryNode)ctx.getEntries().get(0);
        Assertions.assertThat((Object)entry.getName()).isInstanceOf(NameDefNode.class);
        NameDefNode name = (NameDefNode)entry.getName();
        Assertions.assertThat((String)name.getText()).isEqualTo("a value");
        Assertions.assertThat((Object)entry.getValue()).isInstanceOf(NumberNode.class);
        Assertions.assertThat((Object)entry.getResultType()).isEqualTo((Object)BuiltInType.NUMBER);
        Assertions.assertThat((String)entry.getValue().getText()).isEqualTo("10");
        entry = (ContextEntryNode)ctx.getEntries().get(1);
        Assertions.assertThat((Object)entry.getName()).isInstanceOf(NameDefNode.class);
        name = (NameDefNode)entry.getName();
        Assertions.assertThat((String)name.getText()).isEqualTo("an applicant");
        Assertions.assertThat((Object)entry.getValue()).isInstanceOf(ContextNode.class);
        ContextNode applicant = (ContextNode)entry.getValue();
        Assertions.assertThat((int)applicant.getEntries().size()).isEqualTo(5);
        Assertions.assertThat((String)((ContextEntryNode)applicant.getEntries().get(0)).getName().getText()).isEqualTo("first name");
        Assertions.assertThat((Object)((ContextEntryNode)applicant.getEntries().get(0)).getResultType()).isEqualTo((Object)BuiltInType.STRING);
        Assertions.assertThat((String)((ContextEntryNode)applicant.getEntries().get(1)).getName().getText()).isEqualTo("last + name");
        Assertions.assertThat((Object)((ContextEntryNode)applicant.getEntries().get(1)).getResultType()).isEqualTo((Object)BuiltInType.STRING);
        Assertions.assertThat((String)((ContextEntryNode)applicant.getEntries().get(2)).getName().getText()).isEqualTo("full name");
        Assertions.assertThat((Object)((ContextEntryNode)applicant.getEntries().get(2)).getResultType()).isEqualTo((Object)BuiltInType.STRING);
        Assertions.assertThat((String)((ContextEntryNode)applicant.getEntries().get(3)).getName().getText()).isEqualTo("address");
        Assertions.assertThat((Object)((ContextEntryNode)applicant.getEntries().get(3)).getValue()).isInstanceOf(ContextNode.class);
        ContextNode address = (ContextNode)((ContextEntryNode)applicant.getEntries().get(3)).getValue();
        Assertions.assertThat((int)address.getEntries().size()).isEqualTo(2);
        Assertions.assertThat((String)((ContextEntryNode)address.getEntries().get(0)).getName().getText()).isEqualTo("street");
        Assertions.assertThat((Object)((ContextEntryNode)address.getEntries().get(0)).getResultType()).isEqualTo((Object)BuiltInType.STRING);
        Assertions.assertThat((String)((ContextEntryNode)address.getEntries().get(1)).getName().getText()).isEqualTo("city");
        Assertions.assertThat((Object)((ContextEntryNode)address.getEntries().get(0)).getResultType()).isEqualTo((Object)BuiltInType.STRING);
    }

    @Test
    public void testNestedContexts2() {
        String inputExpression = "{ an applicant : {     home address : {        street name: \"broadway st\",        city : \"New York\"     }  },\n  street : an applicant.home address.street name \n}";
        BaseNode ctxbase = this.parse(inputExpression);
        Assertions.assertThat((Object)ctxbase).isInstanceOf(ContextNode.class);
        Assertions.assertThat((String)ctxbase.getText()).isEqualTo(inputExpression);
        ContextNode ctx = (ContextNode)ctxbase;
        Assertions.assertThat((int)ctx.getEntries().size()).isEqualTo(2);
        ContextEntryNode entry = (ContextEntryNode)ctx.getEntries().get(1);
        Assertions.assertThat((Object)entry.getName()).isInstanceOf(NameDefNode.class);
        Assertions.assertThat((Object)entry.getResultType()).isEqualTo((Object)BuiltInType.STRING);
        NameDefNode name = (NameDefNode)entry.getName();
        Assertions.assertThat((String)name.getText()).isEqualTo("street");
        Assertions.assertThat((Object)entry.getValue()).isInstanceOf(QualifiedNameNode.class);
        QualifiedNameNode qnn = (QualifiedNameNode)entry.getValue();
        Assertions.assertThat((String)((NameRefNode)qnn.getParts().get(0)).getText()).isEqualTo("an applicant");
        Assertions.assertThat((String)((NameRefNode)qnn.getParts().get(1)).getText()).isEqualTo("home address");
        Assertions.assertThat((String)((NameRefNode)qnn.getParts().get(2)).getText()).isEqualTo("street name");
    }

    @Test
    public void testFunctionDefinition() {
        String inputExpression = "{ is minor : function( person's age ) person's age < 21 }";
        BaseNode ctxbase = this.parse(inputExpression);
        Assertions.assertThat((Object)ctxbase).isInstanceOf(ContextNode.class);
        Assertions.assertThat((String)ctxbase.getText()).isEqualTo(inputExpression);
        ContextNode ctx = (ContextNode)ctxbase;
        Assertions.assertThat((int)ctx.getEntries().size()).isEqualTo(1);
        ContextEntryNode entry = (ContextEntryNode)ctx.getEntries().get(0);
        Assertions.assertThat((Object)entry.getName()).isInstanceOf(NameDefNode.class);
        NameDefNode name = (NameDefNode)entry.getName();
        Assertions.assertThat((String)name.getText()).isEqualTo("is minor");
        Assertions.assertThat((Object)entry.getValue()).isInstanceOf(FunctionDefNode.class);
        Assertions.assertThat((String)entry.getValue().getText()).isEqualTo("function( person's age ) person's age < 21");
        FunctionDefNode isMinorFunc = (FunctionDefNode)entry.getValue();
        Assertions.assertThat((int)isMinorFunc.getFormalParameters().size()).isEqualTo(1);
        Assertions.assertThat((String)((FormalParameterNode)isMinorFunc.getFormalParameters().get(0)).getText()).isEqualTo("person's age");
        Assertions.assertThat((boolean)isMinorFunc.isExternal()).isEqualTo(false);
        Assertions.assertThat((Object)isMinorFunc.getBody()).isInstanceOf(InfixOpNode.class);
    }

    @Test
    public void testExternalFunctionDefinition() {
        String inputExpression = "{ trigonometric cosine : function( angle ) external {    java : {        class : \"java.lang.Math\",        method signature : \"cos(double)\"    }}}";
        BaseNode ctxbase = this.parse(inputExpression);
        Assertions.assertThat((Object)ctxbase).isInstanceOf(ContextNode.class);
        Assertions.assertThat((String)ctxbase.getText()).isEqualTo(inputExpression);
        ContextNode ctx = (ContextNode)ctxbase;
        Assertions.assertThat((int)ctx.getEntries().size()).isEqualTo(1);
        ContextEntryNode entry = (ContextEntryNode)ctx.getEntries().get(0);
        Assertions.assertThat((Object)entry.getName()).isInstanceOf(NameDefNode.class);
        NameDefNode name = (NameDefNode)entry.getName();
        Assertions.assertThat((String)name.getText()).isEqualTo("trigonometric cosine");
        Assertions.assertThat((Object)entry.getValue()).isInstanceOf(FunctionDefNode.class);
        Assertions.assertThat((String)entry.getValue().getText()).isEqualTo("function( angle ) external {    java : {        class : \"java.lang.Math\",        method signature : \"cos(double)\"    }}");
        FunctionDefNode cos = (FunctionDefNode)entry.getValue();
        Assertions.assertThat((int)cos.getFormalParameters().size()).isEqualTo(1);
        Assertions.assertThat((String)((FormalParameterNode)cos.getFormalParameters().get(0)).getText()).isEqualTo("angle");
        Assertions.assertThat((boolean)cos.isExternal()).isEqualTo(true);
        Assertions.assertThat((Object)cos.getBody()).isInstanceOf(ContextNode.class);
        ContextNode body = (ContextNode)cos.getBody();
        Assertions.assertThat((int)body.getEntries().size()).isEqualTo(1);
        ContextEntryNode java = (ContextEntryNode)body.getEntries().get(0);
        Assertions.assertThat((String)java.getName().getText()).isEqualTo("java");
        Assertions.assertThat((Object)java.getValue()).isInstanceOf(ContextNode.class);
        ContextNode def = (ContextNode)java.getValue();
        Assertions.assertThat((int)def.getEntries().size()).isEqualTo(2);
        Assertions.assertThat((String)((ContextEntryNode)def.getEntries().get(0)).getName().getText()).isEqualTo("class");
        Assertions.assertThat((Object)((ContextEntryNode)def.getEntries().get(0)).getValue()).isInstanceOf(StringNode.class);
        Assertions.assertThat((String)((ContextEntryNode)def.getEntries().get(0)).getValue().getText()).isEqualTo("\"java.lang.Math\"");
        Assertions.assertThat((String)((ContextEntryNode)def.getEntries().get(1)).getName().getText()).isEqualTo("method signature");
        Assertions.assertThat((Object)((ContextEntryNode)def.getEntries().get(1)).getValue()).isInstanceOf(StringNode.class);
        Assertions.assertThat((String)((ContextEntryNode)def.getEntries().get(1)).getValue().getText()).isEqualTo("\"cos(double)\"");
    }

    @Test
    public void testForExpression() {
        String inputExpression = "for item in order.items return item.price * item.quantity";
        BaseNode forbase = this.parse(inputExpression);
        Assertions.assertThat((Object)forbase).isInstanceOf(ForExpressionNode.class);
        Assertions.assertThat((String)forbase.getText()).isEqualTo(inputExpression);
        Assertions.assertThat((Object)forbase.getResultType()).isEqualTo((Object)BuiltInType.LIST);
        ForExpressionNode forExpr = (ForExpressionNode)forbase;
        Assertions.assertThat((int)forExpr.getIterationContexts().size()).isEqualTo(1);
        Assertions.assertThat((Object)forExpr.getExpression()).isInstanceOf(InfixOpNode.class);
        Assertions.assertThat((String)forExpr.getExpression().getText()).isEqualTo("item.price * item.quantity");
        IterationContextNode ic = (IterationContextNode)forExpr.getIterationContexts().get(0);
        Assertions.assertThat((String)ic.getName().getText()).isEqualTo("item");
        Assertions.assertThat((Object)ic.getExpression()).isInstanceOf(QualifiedNameNode.class);
        Assertions.assertThat((String)ic.getExpression().getText()).isEqualTo("order.items");
    }

    @Test
    public void testIfExpression() {
        String inputExpression = "if applicant.age < 18 then \"declined\" else \"accepted\"";
        BaseNode ifBase = this.parse(inputExpression);
        Assertions.assertThat((Object)ifBase).isInstanceOf(IfExpressionNode.class);
        Assertions.assertThat((String)ifBase.getText()).isEqualTo(inputExpression);
        Assertions.assertThat((Object)ifBase.getResultType()).isEqualTo((Object)BuiltInType.STRING);
        IfExpressionNode ifExpr = (IfExpressionNode)ifBase;
        Assertions.assertThat((String)ifExpr.getCondition().getText()).isEqualTo("applicant.age < 18");
        Assertions.assertThat((String)ifExpr.getThenExpression().getText()).isEqualTo("\"declined\"");
        Assertions.assertThat((String)ifExpr.getElseExpression().getText()).isEqualTo("\"accepted\"");
    }

    @Test
    public void testQuantifiedExpressionSome() {
        String inputExpression = "some item in order.items satisfies item.price > 100";
        BaseNode someBase = this.parse(inputExpression);
        Assertions.assertThat((Object)someBase).isInstanceOf(QuantifiedExpressionNode.class);
        Assertions.assertThat((String)someBase.getText()).isEqualTo(inputExpression);
        Assertions.assertThat((Object)someBase.getResultType()).isEqualTo((Object)BuiltInType.BOOLEAN);
        QuantifiedExpressionNode someExpr = (QuantifiedExpressionNode)someBase;
        Assertions.assertThat((Comparable)someExpr.getQuantifier()).isEqualTo((Object)QuantifiedExpressionNode.Quantifier.SOME);
        Assertions.assertThat((int)someExpr.getIterationContexts().size()).isEqualTo(1);
        Assertions.assertThat((String)((IterationContextNode)someExpr.getIterationContexts().get(0)).getText()).isEqualTo("item in order.items");
        Assertions.assertThat((String)someExpr.getExpression().getText()).isEqualTo("item.price > 100");
    }

    @Test
    public void testQuantifiedExpressionEvery() {
        String inputExpression = "every item in order.items satisfies item.price > 100";
        BaseNode everyBase = this.parse(inputExpression);
        Assertions.assertThat((Object)everyBase).isInstanceOf(QuantifiedExpressionNode.class);
        Assertions.assertThat((String)everyBase.getText()).isEqualTo(inputExpression);
        Assertions.assertThat((Object)everyBase.getResultType()).isEqualTo((Object)BuiltInType.BOOLEAN);
        QuantifiedExpressionNode everyExpr = (QuantifiedExpressionNode)everyBase;
        Assertions.assertThat((Comparable)everyExpr.getQuantifier()).isEqualTo((Object)QuantifiedExpressionNode.Quantifier.EVERY);
        Assertions.assertThat((int)everyExpr.getIterationContexts().size()).isEqualTo(1);
        Assertions.assertThat((String)((IterationContextNode)everyExpr.getIterationContexts().get(0)).getText()).isEqualTo("item in order.items");
        Assertions.assertThat((String)everyExpr.getExpression().getText()).isEqualTo("item.price > 100");
    }

    @Test
    public void testInstanceOfExpression() {
        String inputExpression = "\"foo\" instance of string";
        BaseNode instanceOfBase = this.parse(inputExpression);
        Assertions.assertThat((Object)instanceOfBase).isInstanceOf(InstanceOfNode.class);
        Assertions.assertThat((String)instanceOfBase.getText()).isEqualTo(inputExpression);
        Assertions.assertThat((Object)instanceOfBase.getResultType()).isEqualTo((Object)BuiltInType.BOOLEAN);
        InstanceOfNode ioExpr = (InstanceOfNode)instanceOfBase;
        Assertions.assertThat((Object)ioExpr.getExpression()).isInstanceOf(StringNode.class);
        Assertions.assertThat((String)ioExpr.getExpression().getText()).isEqualTo("\"foo\"");
        Assertions.assertThat((Object)ioExpr.getType()).isInstanceOf(TypeNode.class);
        Assertions.assertThat((String)ioExpr.getType().getText()).isEqualTo("string");
    }

    @Test
    public void testInstanceOfExpressionAnd() {
        String inputExpression = "\"foo\" instance of string and 10 instance of number";
        BaseNode andExpr = this.parse(inputExpression);
        Assertions.assertThat((Object)andExpr).isInstanceOf(InfixOpNode.class);
        Assertions.assertThat((String)andExpr.getText()).isEqualTo(inputExpression);
        Assertions.assertThat((Object)andExpr.getResultType()).isEqualTo((Object)BuiltInType.BOOLEAN);
        InfixOpNode and = (InfixOpNode)andExpr;
        Assertions.assertThat((Comparable)and.getOperator()).isEqualTo((Object)InfixOpNode.InfixOperator.AND);
        Assertions.assertThat((Object)and.getLeft()).isInstanceOf(InstanceOfNode.class);
        Assertions.assertThat((Object)and.getRight()).isInstanceOf(InstanceOfNode.class);
        Assertions.assertThat((String)and.getLeft().getText()).isEqualTo("\"foo\" instance of string");
        Assertions.assertThat((String)and.getRight().getText()).isEqualTo("10 instance of number");
        Assertions.assertThat((Object)and.getLeft().getResultType()).isEqualTo((Object)BuiltInType.BOOLEAN);
        Assertions.assertThat((Object)and.getRight().getResultType()).isEqualTo((Object)BuiltInType.BOOLEAN);
        InstanceOfNode ioExpr = (InstanceOfNode)and.getLeft();
        Assertions.assertThat((Object)ioExpr.getExpression()).isInstanceOf(StringNode.class);
        Assertions.assertThat((String)ioExpr.getExpression().getText()).isEqualTo("\"foo\"");
        Assertions.assertThat((Object)ioExpr.getType()).isInstanceOf(TypeNode.class);
        Assertions.assertThat((String)ioExpr.getType().getText()).isEqualTo("string");
        ioExpr = (InstanceOfNode)and.getRight();
        Assertions.assertThat((Object)ioExpr.getExpression()).isInstanceOf(NumberNode.class);
        Assertions.assertThat((String)ioExpr.getExpression().getText()).isEqualTo("10");
        Assertions.assertThat((Object)ioExpr.getType()).isInstanceOf(TypeNode.class);
        Assertions.assertThat((String)ioExpr.getType().getText()).isEqualTo("number");
    }

    @Test
    public void testInstanceOfExpressionFunction() {
        String inputExpression = "duration instance of function";
        BaseNode instanceOfBase = this.parse(inputExpression);
        Assertions.assertThat((Object)instanceOfBase).isInstanceOf(InstanceOfNode.class);
        Assertions.assertThat((String)instanceOfBase.getText()).isEqualTo(inputExpression);
        Assertions.assertThat((Object)instanceOfBase.getResultType()).isEqualTo((Object)BuiltInType.BOOLEAN);
        InstanceOfNode ioExpr = (InstanceOfNode)instanceOfBase;
        Assertions.assertThat((Object)ioExpr.getExpression()).isInstanceOf(NameRefNode.class);
        Assertions.assertThat((String)ioExpr.getExpression().getText()).isEqualTo("duration");
        Assertions.assertThat((Object)ioExpr.getType()).isInstanceOf(TypeNode.class);
        Assertions.assertThat((String)ioExpr.getType().getText()).isEqualTo("function");
    }

    @Test
    public void testPathExpression() {
        String inputExpression = "[ 10, 15 ].size";
        BaseNode pathBase = this.parse(inputExpression);
        Assertions.assertThat((Object)pathBase).isInstanceOf(PathExpressionNode.class);
        Assertions.assertThat((String)pathBase.getText()).isEqualTo(inputExpression);
        PathExpressionNode pathExpr = (PathExpressionNode)pathBase;
        Assertions.assertThat((Object)pathExpr.getExpression()).isInstanceOf(ListNode.class);
        Assertions.assertThat((String)pathExpr.getExpression().getText()).isEqualTo("10, 15");
        Assertions.assertThat((Object)pathExpr.getName()).isInstanceOf(NameRefNode.class);
        Assertions.assertThat((String)pathExpr.getName().getText()).isEqualTo("size");
    }

    @Test
    public void testFilterExpression() {
        String inputExpression = "[ {x:1, y:2}, {x:2, y:3} ][ x=1 ]";
        BaseNode filterBase = this.parse(inputExpression);
        Assertions.assertThat((Object)filterBase).isInstanceOf(FilterExpressionNode.class);
        Assertions.assertThat((String)filterBase.getText()).isEqualTo(inputExpression);
        FilterExpressionNode filter = (FilterExpressionNode)filterBase;
        Assertions.assertThat((Object)filter.getExpression()).isInstanceOf(ListNode.class);
        Assertions.assertThat((String)filter.getExpression().getText()).isEqualTo("{x:1, y:2}, {x:2, y:3}");
        Assertions.assertThat((Object)filter.getFilter()).isInstanceOf(InfixOpNode.class);
        Assertions.assertThat((String)filter.getFilter().getText()).isEqualTo("x=1");
    }

    @Test
    public void testFunctionInvocationNamedParams() {
        String inputExpression = "my.test.Function( named parameter 1 : x+10, named parameter 2 : \"foo\" )";
        BaseNode functionBase = this.parse(inputExpression);
        Assertions.assertThat((Object)functionBase).isInstanceOf(FunctionInvocationNode.class);
        Assertions.assertThat((String)functionBase.getText()).isEqualTo(inputExpression);
        FunctionInvocationNode function = (FunctionInvocationNode)functionBase;
        Assertions.assertThat((Object)function.getName()).isInstanceOf(QualifiedNameNode.class);
        Assertions.assertThat((String)function.getName().getText()).isEqualTo("my.test.Function");
        Assertions.assertThat((Object)function.getParams()).isInstanceOf(ListNode.class);
        Assertions.assertThat((int)function.getParams().getElements().size()).isEqualTo(2);
        Assertions.assertThat((Object)((BaseNode)function.getParams().getElements().get(0))).isInstanceOf(NamedParameterNode.class);
        Assertions.assertThat((Object)((BaseNode)function.getParams().getElements().get(1))).isInstanceOf(NamedParameterNode.class);
        NamedParameterNode named = (NamedParameterNode)function.getParams().getElements().get(0);
        Assertions.assertThat((String)named.getText()).isEqualTo("named parameter 1 : x+10");
        Assertions.assertThat((String)named.getName().getText()).isEqualTo("named parameter 1");
        Assertions.assertThat((Object)named.getExpression()).isInstanceOf(InfixOpNode.class);
        Assertions.assertThat((String)named.getExpression().getText()).isEqualTo("x+10");
        named = (NamedParameterNode)function.getParams().getElements().get(1);
        Assertions.assertThat((String)named.getText()).isEqualTo("named parameter 2 : \"foo\"");
        Assertions.assertThat((String)named.getName().getText()).isEqualTo("named parameter 2");
        Assertions.assertThat((Object)named.getExpression()).isInstanceOf(StringNode.class);
        Assertions.assertThat((String)named.getExpression().getText()).isEqualTo("\"foo\"");
    }

    @Test
    public void testFunctionInvocationPositionalParams() {
        String inputExpression = "my.test.Function( x+10, \"foo\" )";
        BaseNode functionBase = this.parse(inputExpression);
        Assertions.assertThat((Object)functionBase).isInstanceOf(FunctionInvocationNode.class);
        Assertions.assertThat((String)functionBase.getText()).isEqualTo(inputExpression);
        FunctionInvocationNode function = (FunctionInvocationNode)functionBase;
        Assertions.assertThat((Object)function.getName()).isInstanceOf(QualifiedNameNode.class);
        Assertions.assertThat((String)function.getName().getText()).isEqualTo("my.test.Function");
        Assertions.assertThat((Object)function.getParams()).isInstanceOf(ListNode.class);
        Assertions.assertThat((int)function.getParams().getElements().size()).isEqualTo(2);
        Assertions.assertThat((Object)((BaseNode)function.getParams().getElements().get(0))).isInstanceOf(InfixOpNode.class);
        Assertions.assertThat((Object)((BaseNode)function.getParams().getElements().get(1))).isInstanceOf(StringNode.class);
    }

    @Test
    public void testFunctionInvocationWithKeyword() {
        String inputExpression = "date and time( \"2016-07-29T19:47:53\" )";
        BaseNode functionBase = this.parse(inputExpression);
        Assertions.assertThat((Object)functionBase).isInstanceOf(FunctionInvocationNode.class);
        Assertions.assertThat((String)functionBase.getText()).isEqualTo(inputExpression);
        FunctionInvocationNode function = (FunctionInvocationNode)functionBase;
        Assertions.assertThat((Object)function.getName()).isInstanceOf(NameRefNode.class);
        Assertions.assertThat((String)function.getName().getText()).isEqualTo("date and time");
        Assertions.assertThat((Object)function.getParams()).isInstanceOf(ListNode.class);
        Assertions.assertThat((int)function.getParams().getElements().size()).isEqualTo(1);
        Assertions.assertThat((Object)((BaseNode)function.getParams().getElements().get(0))).isInstanceOf(StringNode.class);
    }

    @Test
    public void testFunctionInvocationWithExpressionParameters() {
        String inputExpression = "date and time( date(\"2016-07-29\"), time(\"19:47:53\") )";
        BaseNode functionBase = this.parse(inputExpression);
        Assertions.assertThat((Object)functionBase).isInstanceOf(FunctionInvocationNode.class);
        Assertions.assertThat((String)functionBase.getText()).isEqualTo(inputExpression);
        FunctionInvocationNode function = (FunctionInvocationNode)functionBase;
        Assertions.assertThat((Object)function.getName()).isInstanceOf(NameRefNode.class);
        Assertions.assertThat((String)function.getName().getText()).isEqualTo("date and time");
        Assertions.assertThat((Object)function.getParams()).isInstanceOf(ListNode.class);
        Assertions.assertThat((int)function.getParams().getElements().size()).isEqualTo(2);
        Assertions.assertThat((Object)((BaseNode)function.getParams().getElements().get(0))).isInstanceOf(FunctionInvocationNode.class);
        Assertions.assertThat((Object)((BaseNode)function.getParams().getElements().get(1))).isInstanceOf(FunctionInvocationNode.class);
    }

    @Test
    public void testFunctionInvocationEmptyParams() {
        String inputExpression = "my.test.Function()";
        BaseNode functionBase = this.parse(inputExpression);
        Assertions.assertThat((Object)functionBase).isInstanceOf(FunctionInvocationNode.class);
        Assertions.assertThat((String)functionBase.getText()).isEqualTo(inputExpression);
        FunctionInvocationNode function = (FunctionInvocationNode)functionBase;
        Assertions.assertThat((Object)function.getName()).isInstanceOf(QualifiedNameNode.class);
        Assertions.assertThat((String)function.getName().getText()).isEqualTo("my.test.Function");
        Assertions.assertThat((Object)function.getParams()).isInstanceOf(ListNode.class);
        Assertions.assertThat((List)function.getParams().getElements()).isEmpty();
    }

    @Ignore(value="dropped since DMNv1.2")
    @Test
    public void testFunctionDecisionTableInvocation() {
        String inputExpression = "decision table(     outputs: \"Applicant Risk Rating\",    input expression list: [\"Applicant Age\", \"Medical History\"],    rule list: [        [ >60      , \"good\" , \"Medium\" ],        [ >60      , \"bad\"  , \"High\"   ],        [ [25..60] , -        , \"Medium\" ],        [ <25      , \"good\" , \"Low\"    ],        [ <25      , \"bad\"  , \"Medium\" ] ],    hit policy: \"Unique\" )";
        BaseNode functionBase = this.parse(inputExpression);
        Assertions.assertThat((Object)functionBase).isInstanceOf(FunctionInvocationNode.class);
        Assertions.assertThat((String)functionBase.getText()).isEqualTo(inputExpression);
        FunctionInvocationNode function = (FunctionInvocationNode)functionBase;
        Assertions.assertThat((Object)function.getName()).isInstanceOf(NameRefNode.class);
        Assertions.assertThat((String)function.getName().getText()).isEqualTo("decision table");
        Assertions.assertThat((Object)function.getParams()).isInstanceOf(ListNode.class);
        Assertions.assertThat((int)function.getParams().getElements().size()).isEqualTo(4);
        Assertions.assertThat((Object)((BaseNode)function.getParams().getElements().get(0))).isInstanceOf(NamedParameterNode.class);
        Assertions.assertThat((Object)((BaseNode)function.getParams().getElements().get(1))).isInstanceOf(NamedParameterNode.class);
        Assertions.assertThat((Object)((BaseNode)function.getParams().getElements().get(2))).isInstanceOf(NamedParameterNode.class);
        Assertions.assertThat((Object)((BaseNode)function.getParams().getElements().get(3))).isInstanceOf(NamedParameterNode.class);
        NamedParameterNode named = (NamedParameterNode)function.getParams().getElements().get(0);
        Assertions.assertThat((String)named.getText()).isEqualTo("outputs: \"Applicant Risk Rating\"");
        Assertions.assertThat((String)named.getName().getText()).isEqualTo("outputs");
        Assertions.assertThat((Object)named.getExpression()).isInstanceOf(StringNode.class);
        Assertions.assertThat((String)named.getExpression().getText()).isEqualTo("\"Applicant Risk Rating\"");
        named = (NamedParameterNode)function.getParams().getElements().get(1);
        Assertions.assertThat((String)named.getName().getText()).isEqualTo("input expression list");
        Assertions.assertThat((Object)named.getExpression()).isInstanceOf(ListNode.class);
        ListNode list = (ListNode)named.getExpression();
        Assertions.assertThat((int)list.getElements().size()).isEqualTo(2);
        Assertions.assertThat((Object)((BaseNode)list.getElements().get(0))).isInstanceOf(StringNode.class);
        Assertions.assertThat((String)((BaseNode)list.getElements().get(0)).getText()).isEqualTo("\"Applicant Age\"");
        Assertions.assertThat((Object)((BaseNode)list.getElements().get(1))).isInstanceOf(StringNode.class);
        Assertions.assertThat((String)((BaseNode)list.getElements().get(1)).getText()).isEqualTo("\"Medical History\"");
        named = (NamedParameterNode)function.getParams().getElements().get(2);
        Assertions.assertThat((String)named.getName().getText()).isEqualTo("rule list");
        Assertions.assertThat((Object)named.getExpression()).isInstanceOf(ListNode.class);
        list = (ListNode)named.getExpression();
        Assertions.assertThat((int)list.getElements().size()).isEqualTo(5);
        Assertions.assertThat((Object)((BaseNode)list.getElements().get(0))).isInstanceOf(ListNode.class);
        ListNode rule = (ListNode)list.getElements().get(0);
        Assertions.assertThat((int)rule.getElements().size()).isEqualTo(3);
        Assertions.assertThat((Object)((BaseNode)rule.getElements().get(0))).isInstanceOf(RangeNode.class);
        Assertions.assertThat((String)((BaseNode)rule.getElements().get(0)).getText()).isEqualTo(">60");
        Assertions.assertThat((Object)((BaseNode)rule.getElements().get(1))).isInstanceOf(StringNode.class);
        Assertions.assertThat((String)((BaseNode)rule.getElements().get(1)).getText()).isEqualTo("\"good\"");
        Assertions.assertThat((Object)((BaseNode)rule.getElements().get(2))).isInstanceOf(StringNode.class);
        Assertions.assertThat((String)((BaseNode)rule.getElements().get(2)).getText()).isEqualTo("\"Medium\"");
        named = (NamedParameterNode)function.getParams().getElements().get(3);
        Assertions.assertThat((String)named.getName().getText()).isEqualTo("hit policy");
        Assertions.assertThat((Object)named.getExpression()).isInstanceOf(StringNode.class);
        Assertions.assertThat((String)named.getExpression().getText()).isEqualTo("\"Unique\"");
    }

    @Test
    public void testContextPathExpression() {
        String inputExpression = "{ x : \"foo\" }.x";
        BaseNode pathBase = this.parse(inputExpression);
        Assertions.assertThat((Object)pathBase).isInstanceOf(PathExpressionNode.class);
        Assertions.assertThat((String)pathBase.getText()).isEqualTo(inputExpression);
        Assertions.assertThat((Object)pathBase.getResultType()).isEqualTo((Object)BuiltInType.STRING);
        PathExpressionNode pathExpr = (PathExpressionNode)pathBase;
        Assertions.assertThat((Object)pathExpr.getExpression()).isInstanceOf(ContextNode.class);
        Assertions.assertThat((String)pathExpr.getExpression().getText()).isEqualTo("{ x : \"foo\" }");
        Assertions.assertThat((Object)pathExpr.getName()).isInstanceOf(NameRefNode.class);
        Assertions.assertThat((String)pathExpr.getName().getText()).isEqualTo("x");
    }

    @Test
    public void testContextPathExpression2() {
        String inputExpression = "{ x : { y : \"foo\" } }.x.y";
        BaseNode pathBase = this.parse(inputExpression);
        Assertions.assertThat((Object)pathBase).isInstanceOf(PathExpressionNode.class);
        Assertions.assertThat((String)pathBase.getText()).isEqualTo(inputExpression);
        Assertions.assertThat((Object)pathBase.getResultType()).isEqualTo((Object)BuiltInType.STRING);
        PathExpressionNode pathExpr = (PathExpressionNode)pathBase;
        Assertions.assertThat((Object)pathExpr.getExpression()).isInstanceOf(ContextNode.class);
        Assertions.assertThat((String)pathExpr.getExpression().getText()).isEqualTo("{ x : { y : \"foo\" } }");
        Assertions.assertThat((Object)pathExpr.getName()).isInstanceOf(QualifiedNameNode.class);
        Assertions.assertThat((String)pathExpr.getName().getText()).isEqualTo("x.y");
    }

    @Test
    public void testContextPathExpression3() {
        String inputExpression = "{ first name : \"bob\" }.first name";
        BaseNode pathBase = this.parse(inputExpression);
        Assertions.assertThat((Object)pathBase).isInstanceOf(PathExpressionNode.class);
        Assertions.assertThat((String)pathBase.getText()).isEqualTo(inputExpression);
        Assertions.assertThat((Object)pathBase.getResultType()).isEqualTo((Object)BuiltInType.STRING);
        PathExpressionNode pathExpr = (PathExpressionNode)pathBase;
        Assertions.assertThat((Object)pathExpr.getExpression()).isInstanceOf(ContextNode.class);
        Assertions.assertThat((String)pathExpr.getExpression().getText()).isEqualTo("{ first name : \"bob\" }");
        Assertions.assertThat((Object)pathExpr.getName()).isInstanceOf(NameRefNode.class);
        Assertions.assertThat((String)pathExpr.getName().getText()).isEqualTo("first name");
    }

    @Test
    public void testVariableName() {
        String var = "valid variable name";
        Assertions.assertThat((boolean)FEELParser.isVariableNameValid((String)var)).isEqualTo(true);
    }

    @Test
    public void testVariableNameWithValidCharacters() {
        String var = "?_873./-'+*valid";
        Assertions.assertThat((boolean)FEELParser.isVariableNameValid((String)var)).isEqualTo(true);
    }

    @Test
    public void testVariableNameWithValidCharactersHorseEmoji() {
        String var = "\ud83d\udc0e";
        Assertions.assertThat((boolean)FEELParser.isVariableNameValid((String)var)).isEqualTo(true);
    }

    @Test
    public void testVariableNameWithInvalidCharacterPercentSimplified() {
        String var = "banana%mango";
        Assertions.assertThat((boolean)FEELParser.isVariableNameValid((String)var)).isEqualTo(false);
        Assertions.assertThat((String)((FEELEvent)FEELParser.checkVariableName((String)var).get(0)).getMessage()).isEqualTo(Msg.createMessage((Msg.Message2)Msg.INVALID_VARIABLE_NAME, (Object)"character", (Object)"%"));
    }

    @Test
    public void testVariableNameWithInvalidCharacterPercent() {
        String var = "?_873./-'%+*valid";
        Assertions.assertThat((boolean)FEELParser.isVariableNameValid((String)var)).isEqualTo(false);
        Assertions.assertThat((String)((FEELEvent)FEELParser.checkVariableName((String)var).get(0)).getMessage()).isEqualTo(Msg.createMessage((Msg.Message2)Msg.INVALID_VARIABLE_NAME, (Object)"character", (Object)"%"));
    }

    @Test
    public void testVariableNameWithInvalidCharacterAt() {
        String var = "?_873./-'@+*valid";
        Assertions.assertThat((boolean)FEELParser.isVariableNameValid((String)var)).isEqualTo(false);
        Assertions.assertThat((String)((FEELEvent)FEELParser.checkVariableName((String)var).get(0)).getMessage()).isEqualTo(Msg.createMessage((Msg.Message2)Msg.INVALID_VARIABLE_NAME, (Object)"character", (Object)"@"));
    }

    @Test
    public void testVariableNameInvalidStartCharacter() {
        String var = "5variable can't start with a number";
        Assertions.assertThat((boolean)FEELParser.isVariableNameValid((String)var)).isEqualTo(false);
        Assertions.assertThat((String)((FEELEvent)FEELParser.checkVariableName((String)var).get(0)).getMessage()).isEqualTo(Msg.createMessage((Msg.Message2)Msg.INVALID_VARIABLE_NAME_START, (Object)"character", (Object)"5"));
    }

    @Test
    public void testVariableNameCantStartWithKeyword() {
        String var = "for keyword is an invalid start for a variable name";
        Assertions.assertThat((boolean)FEELParser.isVariableNameValid((String)var)).isEqualTo(false);
        Assertions.assertThat((String)((FEELEvent)FEELParser.checkVariableName((String)var).get(0)).getMessage()).isEqualTo(Msg.createMessage((Msg.Message2)Msg.INVALID_VARIABLE_NAME_START, (Object)"keyword", (Object)"for"));
    }

    public static void assertLocation(String inputExpression, ASTNode number) {
        Assertions.assertThat((String)number.getText()).isEqualTo(inputExpression);
        Assertions.assertThat((int)number.getStartChar()).isEqualTo(0);
        Assertions.assertThat((int)number.getStartLine()).isEqualTo(1);
        Assertions.assertThat((int)number.getStartColumn()).isEqualTo(0);
        Assertions.assertThat((int)number.getEndChar()).isEqualTo(inputExpression.length() - 1);
        Assertions.assertThat((int)number.getEndLine()).isEqualTo(1);
        Assertions.assertThat((int)number.getEndColumn()).isEqualTo(inputExpression.length());
    }

    private BaseNode parse(String input) {
        return this.parse(input, Collections.emptyMap());
    }

    private BaseNode parse(String input, Map<String, Type> inputTypes) {
        FEEL_1_1Parser parser = FEELParser.parse(null, (String)input, inputTypes, Collections.emptyMap(), Collections.emptyList(), Collections.emptyList(), null);
        FEEL_1_1Parser.ExpressionContext tree = parser.expression();
        ASTBuilderVisitor v = new ASTBuilderVisitor(inputTypes, null);
        BaseNode expr = (BaseNode)v.visit((ParseTree)tree);
        return expr;
    }
}

