/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.runtime.functions;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.Before;
import org.junit.Test;
import org.kie.dmn.feel.runtime.events.InvalidParametersEvent;
import org.kie.dmn.feel.runtime.functions.CountFunction;
import org.kie.dmn.feel.runtime.functions.FunctionTestUtil;

public class CountFunctionTest {
    private CountFunction countFunction;

    @Before
    public void setUp() {
        this.countFunction = new CountFunction();
    }

    @Test
    public void invokeParamListNull() {
        FunctionTestUtil.assertResultError(this.countFunction.invoke((List)null), InvalidParametersEvent.class);
    }

    @Test
    public void invokeParamListEmpty() {
        FunctionTestUtil.assertResult(this.countFunction.invoke(Collections.emptyList()), BigDecimal.ZERO);
    }

    @Test
    public void invokeParamListNonEmpty() {
        FunctionTestUtil.assertResult(this.countFunction.invoke(Arrays.asList(1, 2, "test")), BigDecimal.valueOf(3L));
    }

    @Test
    public void invokeParamArrayNull() {
        FunctionTestUtil.assertResultError(this.countFunction.invoke((Object[])null), InvalidParametersEvent.class);
    }

    @Test
    public void invokeParamArrayEmpty() {
        FunctionTestUtil.assertResult(this.countFunction.invoke(new Object[0]), BigDecimal.ZERO);
    }

    @Test
    public void invokeParamArrayNonEmpty() {
        FunctionTestUtil.assertResult(this.countFunction.invoke(new Object[]{1, 2, "test"}), BigDecimal.valueOf(3L));
    }
}

