/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.runtime.functions;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.kie.dmn.api.feel.runtime.events.FEELEvent;
import org.kie.dmn.feel.runtime.events.InvalidParametersEvent;
import org.kie.dmn.feel.runtime.functions.BaseFEELFunction;
import org.kie.dmn.feel.runtime.functions.FEELFnResult;
import org.kie.dmn.feel.runtime.functions.ParameterName;

public class MatchesFunction
extends BaseFEELFunction {
    public MatchesFunction() {
        super("matches");
    }

    public FEELFnResult<Boolean> invoke(@ParameterName(value="input") String input, @ParameterName(value="pattern") String pattern) {
        return this.invoke(input, pattern, null);
    }

    public FEELFnResult<Boolean> invoke(@ParameterName(value="input") String input, @ParameterName(value="pattern") String pattern, @ParameterName(value="flags") String flags) {
        if (input == null) {
            return FEELFnResult.ofError(new InvalidParametersEvent(FEELEvent.Severity.ERROR, "input", "cannot be null"));
        }
        if (pattern == null) {
            return FEELFnResult.ofError(new InvalidParametersEvent(FEELEvent.Severity.ERROR, "pattern", "cannot be null"));
        }
        try {
            int f = this.processFlags(flags);
            Pattern p = Pattern.compile(pattern, f);
            Matcher m = p.matcher(input);
            return FEELFnResult.ofResult(m.find());
        }
        catch (PatternSyntaxException e) {
            return FEELFnResult.ofError(new InvalidParametersEvent(FEELEvent.Severity.ERROR, "pattern", "is invalid and can not be compiled", e));
        }
        catch (IllegalArgumentException t) {
            return FEELFnResult.ofError(new InvalidParametersEvent(FEELEvent.Severity.ERROR, "flags", "contains unknown flags", t));
        }
        catch (Throwable t) {
            return FEELFnResult.ofError(new InvalidParametersEvent(FEELEvent.Severity.ERROR, "pattern", "is invalid and can not be compiled", t));
        }
    }

    private int processFlags(String flags) {
        int f = 0;
        if (flags != null) {
            if (flags.contains("s")) {
                f |= 0x20;
            }
            if (flags.contains("m")) {
                f |= 8;
            }
            if (flags.contains("i")) {
                f |= 2;
            }
        }
        return f;
    }
}

