/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.runtime.functions;

import java.util.Map;
import org.kie.dmn.api.core.DMNContext;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNResult;
import org.kie.dmn.api.core.DMNRuntime;
import org.kie.dmn.api.feel.runtime.events.FEELEvent;
import org.kie.dmn.feel.lang.EvaluationContext;
import org.kie.dmn.feel.runtime.events.FEELEventBase;
import org.kie.dmn.feel.runtime.events.InvalidParametersEvent;
import org.kie.dmn.feel.runtime.functions.BaseFEELFunction;
import org.kie.dmn.feel.runtime.functions.FEELFnResult;
import org.kie.dmn.feel.runtime.functions.ParameterName;

public class InvokeFunction
extends BaseFEELFunction {
    public InvokeFunction() {
        super("invoke");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FEELFnResult<Object> invoke(@ParameterName(value="ctx") EvaluationContext ctx, @ParameterName(value="namespace") String namespace, @ParameterName(value="model name") String modelName, @ParameterName(value="decision name") String decisionName, @ParameterName(value="parameters") Map<String, Object> parameters) {
        DMNRuntime dmnRuntime = ctx.getDMNRuntime();
        if (namespace == null) {
            return FEELFnResult.ofError(new InvalidParametersEvent(FEELEvent.Severity.ERROR, "namespace", "cannot be null"));
        }
        if (modelName == null) {
            return FEELFnResult.ofError(new InvalidParametersEvent(FEELEvent.Severity.ERROR, "model name", "cannot be null"));
        }
        if (decisionName == null) {
            return FEELFnResult.ofError(new InvalidParametersEvent(FEELEvent.Severity.ERROR, "decision name", "cannot be null"));
        }
        if (parameters == null) {
            return FEELFnResult.ofError(new InvalidParametersEvent(FEELEvent.Severity.ERROR, "parameters", "cannot be null"));
        }
        FEELEventBase capturedException = null;
        try {
            ctx.enterFrame();
            DMNModel dmnModel = dmnRuntime.getModel(namespace, modelName);
            if (dmnModel == null) {
                FEELFnResult<Object> fEELFnResult = FEELFnResult.ofError(new FEELEventBase(FEELEvent.Severity.ERROR, "Cannot find model '" + modelName + "' in namespace " + namespace, null));
                return fEELFnResult;
            }
            if (dmnModel.getDecisionByName(decisionName) == null) {
                FEELFnResult<Object> fEELFnResult = FEELFnResult.ofError(new FEELEventBase(FEELEvent.Severity.ERROR, "Cannot find decision '" + decisionName + "' in the model", null));
                return fEELFnResult;
            }
            DMNContext dmnContext = dmnRuntime.newContext();
            dmnContext.getAll().putAll(parameters);
            DMNResult requiredDecisionResult = dmnRuntime.evaluateByName(dmnModel, dmnContext, new String[]{decisionName});
            if (requiredDecisionResult.hasErrors()) {
                FEELFnResult<Object> fEELFnResult = FEELFnResult.ofError(new FEELEventBase(FEELEvent.Severity.ERROR, "Errors occurred while invoking the external decision: " + requiredDecisionResult.getMessages(), null));
                return fEELFnResult;
            }
            FEELFnResult<Object> fEELFnResult = FEELFnResult.ofResult(requiredDecisionResult.getContext().get(decisionName));
            return fEELFnResult;
        }
        catch (Exception e) {
            capturedException = new FEELEventBase(FEELEvent.Severity.ERROR, "Error invoking function", new RuntimeException("Error invoking function " + this.getName() + ".", e));
        }
        finally {
            ctx.exitFrame();
        }
        return FEELFnResult.ofError(capturedException);
    }
}

