/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.runtime.impl;

import org.junit.Assert;
import org.junit.Test;
import org.kie.dmn.feel.runtime.Range;
import org.kie.dmn.feel.runtime.impl.RangeImpl;

public class RangeImplTest {
    @Test
    public void getLowBoundary() throws Exception {
        Range.RangeBoundary lowBoundary = Range.RangeBoundary.CLOSED;
        RangeImpl rangeImpl = new RangeImpl(lowBoundary, (Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(15), Range.RangeBoundary.OPEN);
        Assert.assertEquals((Object)lowBoundary, (Object)rangeImpl.getLowBoundary());
    }

    @Test
    public void getLowEndPoint() throws Exception {
        Integer lowEndPoint = 1;
        RangeImpl rangeImpl = new RangeImpl(Range.RangeBoundary.OPEN, (Comparable)lowEndPoint, (Comparable)Integer.valueOf(15), Range.RangeBoundary.CLOSED);
        Assert.assertEquals((Object)lowEndPoint, (Object)rangeImpl.getLowEndPoint());
    }

    @Test
    public void getHighEndPoint() throws Exception {
        Integer highEndPoint = 15;
        RangeImpl rangeImpl = new RangeImpl(Range.RangeBoundary.OPEN, (Comparable)Integer.valueOf(1), (Comparable)highEndPoint, Range.RangeBoundary.CLOSED);
        Assert.assertEquals((Object)highEndPoint, (Object)rangeImpl.getHighEndPoint());
    }

    @Test
    public void getHighBoundary() throws Exception {
        Range.RangeBoundary highBoundary = Range.RangeBoundary.CLOSED;
        RangeImpl rangeImpl = new RangeImpl(Range.RangeBoundary.OPEN, (Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(15), highBoundary);
        Assert.assertEquals((Object)highBoundary, (Object)rangeImpl.getHighBoundary());
    }

    @Test
    public void includes() throws Exception {
        RangeImpl rangeImpl = new RangeImpl(Range.RangeBoundary.OPEN, (Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(15), Range.RangeBoundary.OPEN);
        Assert.assertFalse((boolean)rangeImpl.includes((Object)-15));
        Assert.assertFalse((boolean)rangeImpl.includes((Object)5));
        Assert.assertFalse((boolean)rangeImpl.includes((Object)10));
        Assert.assertTrue((boolean)rangeImpl.includes((Object)12));
        Assert.assertFalse((boolean)rangeImpl.includes((Object)15));
        Assert.assertFalse((boolean)rangeImpl.includes((Object)156));
        rangeImpl = new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(15), Range.RangeBoundary.OPEN);
        Assert.assertTrue((boolean)rangeImpl.includes((Object)10));
        Assert.assertTrue((boolean)rangeImpl.includes((Object)12));
        Assert.assertFalse((boolean)rangeImpl.includes((Object)15));
        rangeImpl = new RangeImpl(Range.RangeBoundary.OPEN, (Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(15), Range.RangeBoundary.CLOSED);
        Assert.assertFalse((boolean)rangeImpl.includes((Object)10));
        Assert.assertTrue((boolean)rangeImpl.includes((Object)12));
        Assert.assertTrue((boolean)rangeImpl.includes((Object)15));
        rangeImpl = new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(15), Range.RangeBoundary.CLOSED);
        Assert.assertTrue((boolean)rangeImpl.includes((Object)10));
        Assert.assertTrue((boolean)rangeImpl.includes((Object)12));
        Assert.assertTrue((boolean)rangeImpl.includes((Object)15));
    }

    @Test
    public void equals() throws Exception {
        RangeImpl rangeImpl = new RangeImpl(Range.RangeBoundary.OPEN, (Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(15), Range.RangeBoundary.OPEN);
        Assert.assertTrue((boolean)rangeImpl.equals((Object)rangeImpl));
        RangeImpl rangeImpl2 = new RangeImpl(Range.RangeBoundary.OPEN, (Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(15), Range.RangeBoundary.OPEN);
        Assert.assertTrue((boolean)rangeImpl.equals((Object)rangeImpl2));
        rangeImpl2 = new RangeImpl(Range.RangeBoundary.OPEN, (Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(15), Range.RangeBoundary.CLOSED);
        Assert.assertFalse((boolean)rangeImpl.equals((Object)rangeImpl2));
        rangeImpl2 = new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(15), Range.RangeBoundary.OPEN);
        Assert.assertFalse((boolean)rangeImpl.equals((Object)rangeImpl2));
        rangeImpl2 = new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(15), Range.RangeBoundary.CLOSED);
        Assert.assertFalse((boolean)rangeImpl.equals((Object)rangeImpl2));
        rangeImpl2 = new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)Integer.valueOf(12), (Comparable)Integer.valueOf(15), Range.RangeBoundary.CLOSED);
        Assert.assertFalse((boolean)rangeImpl.equals((Object)rangeImpl2));
        rangeImpl2 = new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)Integer.valueOf(12), (Comparable)Integer.valueOf(17), Range.RangeBoundary.CLOSED);
        Assert.assertFalse((boolean)rangeImpl.equals((Object)rangeImpl2));
        rangeImpl = new RangeImpl();
        Assert.assertTrue((boolean)rangeImpl.equals((Object)rangeImpl));
    }

    @Test
    public void hashCodeTest() throws Exception {
        RangeImpl rangeImpl = new RangeImpl(Range.RangeBoundary.OPEN, (Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(15), Range.RangeBoundary.OPEN);
        Assert.assertEquals((long)rangeImpl.hashCode(), (long)rangeImpl.hashCode());
        RangeImpl rangeImpl2 = new RangeImpl(Range.RangeBoundary.OPEN, (Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(15), Range.RangeBoundary.OPEN);
        Assert.assertEquals((long)rangeImpl.hashCode(), (long)rangeImpl2.hashCode());
        rangeImpl2 = new RangeImpl(Range.RangeBoundary.OPEN, (Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(15), Range.RangeBoundary.CLOSED);
        Assert.assertNotEquals((long)rangeImpl.hashCode(), (long)rangeImpl2.hashCode());
        rangeImpl2 = new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(15), Range.RangeBoundary.OPEN);
        Assert.assertNotEquals((long)rangeImpl.hashCode(), (long)rangeImpl2.hashCode());
        rangeImpl2 = new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(15), Range.RangeBoundary.CLOSED);
        Assert.assertNotEquals((long)rangeImpl.hashCode(), (long)rangeImpl2.hashCode());
        rangeImpl2 = new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)Integer.valueOf(12), (Comparable)Integer.valueOf(15), Range.RangeBoundary.CLOSED);
        Assert.assertNotEquals((long)rangeImpl.hashCode(), (long)rangeImpl2.hashCode());
        rangeImpl2 = new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)Integer.valueOf(12), (Comparable)Integer.valueOf(17), Range.RangeBoundary.CLOSED);
        Assert.assertNotEquals((long)rangeImpl.hashCode(), (long)rangeImpl2.hashCode());
    }
}

