/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.util;

import java.math.BigDecimal;
import org.junit.Assert;
import org.junit.Test;
import org.kie.dmn.feel.util.EvalHelper;

public class EvalHelperTest {
    @Test
    public void testNormalizeSpace() {
        Assert.assertNull((Object)EvalHelper.normalizeVariableName(null));
        Assert.assertEquals((Object)"", (Object)EvalHelper.normalizeVariableName((String)""));
        Assert.assertEquals((Object)"", (Object)EvalHelper.normalizeVariableName((String)" "));
        Assert.assertEquals((Object)"", (Object)EvalHelper.normalizeVariableName((String)"\t"));
        Assert.assertEquals((Object)"", (Object)EvalHelper.normalizeVariableName((String)"\n"));
        Assert.assertEquals((Object)"", (Object)EvalHelper.normalizeVariableName((String)"\t"));
        Assert.assertEquals((Object)"", (Object)EvalHelper.normalizeVariableName((String)"\u000b"));
        Assert.assertEquals((Object)"", (Object)EvalHelper.normalizeVariableName((String)"\f"));
        Assert.assertEquals((Object)"", (Object)EvalHelper.normalizeVariableName((String)"\u001c"));
        Assert.assertEquals((Object)"", (Object)EvalHelper.normalizeVariableName((String)"\u001d"));
        Assert.assertEquals((Object)"", (Object)EvalHelper.normalizeVariableName((String)"\u001e"));
        Assert.assertEquals((Object)"", (Object)EvalHelper.normalizeVariableName((String)"\u001f"));
        Assert.assertEquals((Object)"", (Object)EvalHelper.normalizeVariableName((String)"\f"));
        Assert.assertEquals((Object)"", (Object)EvalHelper.normalizeVariableName((String)"\r"));
        Assert.assertEquals((Object)"a", (Object)EvalHelper.normalizeVariableName((String)"  a  "));
        Assert.assertEquals((Object)"a b c", (Object)EvalHelper.normalizeVariableName((String)"  a  b   c  "));
        Assert.assertEquals((Object)"a b c", (Object)EvalHelper.normalizeVariableName((String)"a\t\f\r  b\u000b   c\n"));
        Assert.assertEquals((Object)"a b c", (Object)EvalHelper.normalizeVariableName((String)"a\t\f\r  \u00a0\u00a0b\u000b   c\n"));
        Assert.assertEquals((Object)"b", (Object)EvalHelper.normalizeVariableName((String)" b"));
        Assert.assertEquals((Object)"b", (Object)EvalHelper.normalizeVariableName((String)"b "));
        Assert.assertEquals((Object)"ab c", (Object)EvalHelper.normalizeVariableName((String)"ab c  "));
        Assert.assertEquals((Object)"a b", (Object)EvalHelper.normalizeVariableName((String)"a\u00a0b"));
    }

    @Test
    public void testGetBigDecimalOrNull() {
        Assert.assertEquals((Object)new BigDecimal("10"), (Object)EvalHelper.getBigDecimalOrNull((Object)10.0));
        Assert.assertEquals((Object)new BigDecimal("10"), (Object)EvalHelper.getBigDecimalOrNull((Object)10.0));
        Assert.assertEquals((Object)new BigDecimal("10000000000.5"), (Object)EvalHelper.getBigDecimalOrNull((Object)1.00000000005E10));
    }
}

