/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.lang.ast;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.antlr.v4.runtime.ParserRuleContext;
import org.kie.dmn.feel.lang.EvaluationContext;
import org.kie.dmn.feel.lang.Type;
import org.kie.dmn.feel.lang.ast.BaseNode;
import org.kie.dmn.feel.lang.ast.IterationContextNode;
import org.kie.dmn.feel.lang.ast.ListNode;
import org.kie.dmn.feel.lang.types.BuiltInType;

public class ForExpressionNode
extends BaseNode {
    private List<IterationContextNode> iterationContexts = new ArrayList<IterationContextNode>();
    private BaseNode expression;

    public ForExpressionNode(ParserRuleContext ctx, ListNode iterationContexts, BaseNode expression) {
        super(ctx);
        this.expression = expression;
        for (BaseNode n : iterationContexts.getElements()) {
            this.iterationContexts.add((IterationContextNode)n);
        }
    }

    public List<IterationContextNode> getIterationContexts() {
        return this.iterationContexts;
    }

    public void setIterationContexts(List<IterationContextNode> iterationContexts) {
        this.iterationContexts = iterationContexts;
    }

    public BaseNode getExpression() {
        return this.expression;
    }

    public void setExpression(BaseNode expression) {
        this.expression = expression;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object evaluate(EvaluationContext ctx) {
        try {
            ctx.enterFrame();
            ArrayList<Object> results = new ArrayList<Object>();
            ForIteration[] ictx = this.initializeContexts(ctx, this.iterationContexts);
            while (this.nextIteration(ctx, ictx)) {
                Object result = this.expression.evaluate(ctx);
                results.add(result);
            }
            ArrayList<Object> arrayList = results;
            return arrayList;
        }
        finally {
            ctx.exitFrame();
        }
    }

    private boolean nextIteration(EvaluationContext ctx, ForIteration[] ictx) {
        int i = ictx.length - 1;
        while (i >= 0 && i < ictx.length) {
            if (ictx[i].hasNextValue()) {
                this.setValueIntoContext(ctx, ictx[i]);
                ++i;
                continue;
            }
            --i;
        }
        return i >= 0;
    }

    private void setValueIntoContext(EvaluationContext ctx, ForIteration forIteration) {
        ctx.setValue(forIteration.getName(), forIteration.getNextValue());
    }

    @Override
    public Type getResultType() {
        return BuiltInType.LIST;
    }

    private ForIteration[] initializeContexts(EvaluationContext ctx, List<IterationContextNode> iterationContexts) {
        ForIteration[] ictx = new ForIteration[iterationContexts.size()];
        int i = 0;
        for (IterationContextNode icn : iterationContexts) {
            ictx[i] = this.createQuantifiedExpressionIterationContext(ctx, icn);
            if (i < iterationContexts.size() - 1 && ictx[i].hasNextValue()) {
                this.setValueIntoContext(ctx, ictx[i]);
            }
            ++i;
        }
        return ictx;
    }

    private ForIteration createQuantifiedExpressionIterationContext(EvaluationContext ctx, IterationContextNode icn) {
        String name = icn.evaluateName(ctx);
        Object result = icn.evaluate(ctx);
        List<Object> values = result instanceof Iterable ? (List<Object>)result : Collections.singletonList(result);
        ForIteration fi = new ForIteration(name, values);
        return fi;
    }

    private static class ForIteration {
        private String name;
        private Iterable values;
        private Iterator iterator;

        public ForIteration(String name, Iterable values) {
            this.name = name;
            this.values = values;
        }

        public boolean hasNextValue() {
            boolean hasValue;
            if (this.iterator == null) {
                this.iterator = this.values.iterator();
            }
            if (!(hasValue = this.iterator.hasNext())) {
                this.iterator = null;
            }
            return hasValue;
        }

        public Object getNextValue() {
            return this.iterator != null ? this.iterator.next() : null;
        }

        public String getName() {
            return this.name;
        }
    }
}

