/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.runtime.functions;

import java.math.BigDecimal;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import org.junit.Before;
import org.junit.Test;
import org.kie.dmn.feel.runtime.Range;
import org.kie.dmn.feel.runtime.events.InvalidParametersEvent;
import org.kie.dmn.feel.runtime.functions.FunctionTestUtil;
import org.kie.dmn.feel.runtime.functions.StringFunction;
import org.kie.dmn.feel.runtime.impl.RangeImpl;

public class StringFunctionTest {
    private StringFunction stringFunction;

    @Before
    public void setUp() throws Exception {
        this.stringFunction = new StringFunction();
    }

    @Test
    public void invokeNull() {
        FunctionTestUtil.assertResult(this.stringFunction.invoke(null), null);
    }

    @Test
    public void invokeMaskNull() {
        FunctionTestUtil.assertResultError(this.stringFunction.invoke((String)null, null), InvalidParametersEvent.class);
        FunctionTestUtil.assertResultError(this.stringFunction.invoke((String)null, new Object[0]), InvalidParametersEvent.class);
    }

    @Test
    public void invokeString() {
        FunctionTestUtil.assertResult(this.stringFunction.invoke((Object)"test"), "test");
    }

    @Test
    public void invokeBigDecimal() {
        FunctionTestUtil.assertResult(this.stringFunction.invoke((Object)BigDecimal.valueOf(10.7)), "10.7");
    }

    @Test
    public void invokeLocalDate() {
        LocalDate localDate = LocalDate.now();
        FunctionTestUtil.assertResult(this.stringFunction.invoke((Object)localDate), localDate.toString());
    }

    @Test
    public void invokeLocalTime() {
        LocalTime localTime = LocalTime.now();
        FunctionTestUtil.assertResult(this.stringFunction.invoke((Object)localTime), localTime.toString());
    }

    @Test
    public void invokeOffsetTime() {
        OffsetTime offsetTime = OffsetTime.now();
        FunctionTestUtil.assertResult(this.stringFunction.invoke((Object)offsetTime), offsetTime.toString());
    }

    @Test
    public void invokeLocalDateTime() {
        LocalDateTime localDateTime = LocalDateTime.now();
        FunctionTestUtil.assertResult(this.stringFunction.invoke((Object)localDateTime), localDateTime.toString());
    }

    @Test
    public void invokeOffsetDateTime() {
        OffsetDateTime offsetDateTime = OffsetDateTime.now();
        FunctionTestUtil.assertResult(this.stringFunction.invoke((Object)offsetDateTime), offsetDateTime.toString());
    }

    @Test
    public void invokeZonedDateTime() {
        ZonedDateTime zonedDateTime = ZonedDateTime.now();
        FunctionTestUtil.assertResult(this.stringFunction.invoke((Object)zonedDateTime), zonedDateTime.toString());
    }

    @Test
    public void invokeDurationZero() {
        FunctionTestUtil.assertResult(this.stringFunction.invoke((Object)Duration.ZERO), "PT0S");
    }

    @Test
    public void invokeDurationDays() {
        FunctionTestUtil.assertResult(this.stringFunction.invoke((Object)Duration.ofDays(9L)), "P9D");
        FunctionTestUtil.assertResult(this.stringFunction.invoke((Object)Duration.ofDays(-9L)), "-P9D");
    }

    @Test
    public void invokeDurationHours() {
        FunctionTestUtil.assertResult(this.stringFunction.invoke((Object)Duration.ofHours(9L)), "PT9H");
        FunctionTestUtil.assertResult(this.stringFunction.invoke((Object)Duration.ofHours(200L)), "P8DT8H");
        FunctionTestUtil.assertResult(this.stringFunction.invoke((Object)Duration.ofHours(-200L)), "-P8DT8H");
    }

    @Test
    public void invokeDurationMinutes() {
        FunctionTestUtil.assertResult(this.stringFunction.invoke((Object)Duration.ofMinutes(9L)), "PT9M");
        FunctionTestUtil.assertResult(this.stringFunction.invoke((Object)Duration.ofMinutes(200L)), "PT3H20M");
        FunctionTestUtil.assertResult(this.stringFunction.invoke((Object)Duration.ofMinutes(5000L)), "P3DT11H20M");
        FunctionTestUtil.assertResult(this.stringFunction.invoke((Object)Duration.ofMinutes(-5000L)), "-P3DT11H20M");
    }

    @Test
    public void invokeDurationSeconds() {
        FunctionTestUtil.assertResult(this.stringFunction.invoke((Object)Duration.ofSeconds(9L)), "PT9S");
        FunctionTestUtil.assertResult(this.stringFunction.invoke((Object)Duration.ofSeconds(200L)), "PT3M20S");
        FunctionTestUtil.assertResult(this.stringFunction.invoke((Object)Duration.ofSeconds(5000L)), "PT1H23M20S");
        FunctionTestUtil.assertResult(this.stringFunction.invoke((Object)Duration.ofSeconds(90061L)), "P1DT1H1M1S");
        FunctionTestUtil.assertResult(this.stringFunction.invoke((Object)Duration.ofSeconds(-90061L)), "-P1DT1H1M1S");
    }

    @Test
    public void invokeDurationNanosMillis() {
        FunctionTestUtil.assertResult(this.stringFunction.invoke((Object)Duration.ofNanos(25L)), "PT0.000000025S");
        FunctionTestUtil.assertResult(this.stringFunction.invoke((Object)Duration.ofNanos(10000L)), "PT0.00001S");
        FunctionTestUtil.assertResult(this.stringFunction.invoke((Object)Duration.ofNanos(10025L)), "PT0.000010025S");
        FunctionTestUtil.assertResult(this.stringFunction.invoke((Object)Duration.ofMillis(1500L)), "PT1.5S");
        FunctionTestUtil.assertResult(this.stringFunction.invoke((Object)Duration.ofMillis(90061025L)), "P1DT1H1M1.025S");
        FunctionTestUtil.assertResult(this.stringFunction.invoke((Object)Duration.ofMillis(-90061025L)), "-P1DT1H1M1.025S");
    }

    @Test
    public void invokePeriodZero() {
        FunctionTestUtil.assertResult(this.stringFunction.invoke((Object)Period.ZERO), "P0M");
    }

    @Test
    public void invokePeriodYears() {
        FunctionTestUtil.assertResult(this.stringFunction.invoke((Object)Period.ofYears(24)), "P24Y");
        FunctionTestUtil.assertResult(this.stringFunction.invoke((Object)Period.ofYears(-24)), "-P24Y");
    }

    @Test
    public void invokePeriodMonths() {
        FunctionTestUtil.assertResult(this.stringFunction.invoke((Object)Period.ofMonths(2)), "P2M");
        FunctionTestUtil.assertResult(this.stringFunction.invoke((Object)Period.ofMonths(27)), "P2Y3M");
        FunctionTestUtil.assertResult(this.stringFunction.invoke((Object)Period.ofMonths(-27)), "-P2Y3M");
    }

    @Test
    public void invokeListEmpty() {
        FunctionTestUtil.assertResult(this.stringFunction.invoke(Collections.emptyList()), "[ ]");
    }

    @Test
    public void invokeListNonEmpty() {
        ArrayList<Object> values = new ArrayList<Object>();
        values.add(1);
        values.add(BigDecimal.valueOf(10.5));
        values.add("test");
        FunctionTestUtil.assertResult(this.stringFunction.invoke(values), "[ 1, 10.5, test ]");
    }

    @Test
    public void invokeRangeOpenOpen() {
        FunctionTestUtil.assertResult(this.stringFunction.invoke((Object)new RangeImpl(Range.RangeBoundary.OPEN, (Comparable)Integer.valueOf(12), (Comparable)Integer.valueOf(15), Range.RangeBoundary.OPEN)), "( 12 .. 15 )");
    }

    @Test
    public void invokeRangeOpenClosed() {
        FunctionTestUtil.assertResult(this.stringFunction.invoke((Object)new RangeImpl(Range.RangeBoundary.OPEN, (Comparable)Integer.valueOf(12), (Comparable)Integer.valueOf(15), Range.RangeBoundary.CLOSED)), "( 12 .. 15 ]");
    }

    @Test
    public void invokeRangeClosedOpen() {
        FunctionTestUtil.assertResult(this.stringFunction.invoke((Object)new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)Integer.valueOf(12), (Comparable)Integer.valueOf(15), Range.RangeBoundary.OPEN)), "[ 12 .. 15 )");
    }

    @Test
    public void invokeRangeClosedClosed() {
        FunctionTestUtil.assertResult(this.stringFunction.invoke((Object)new RangeImpl(Range.RangeBoundary.CLOSED, (Comparable)Integer.valueOf(12), (Comparable)Integer.valueOf(15), Range.RangeBoundary.CLOSED)), "[ 12 .. 15 ]");
    }

    @Test
    public void invokeContextEmpty() {
        FunctionTestUtil.assertResult(this.stringFunction.invoke(new HashMap()), "{ }");
    }

    @Test
    public void invokeContextNonEmpty() {
        HashMap<String, String> childContextMap = new HashMap<String, String>();
        childContextMap.put("childKey1", "childValue1");
        HashMap<String, Object> contextMap = new HashMap<String, Object>();
        contextMap.put("key1", "value1");
        contextMap.put("key2", childContextMap);
        FunctionTestUtil.assertResult(this.stringFunction.invoke(contextMap), "{ key1 : value1, key2 : { childKey1 : childValue1 } }");
    }

    @Test
    public void invokeMaskedFormat() {
        FunctionTestUtil.assertResult(this.stringFunction.invoke("%s is here!", new Object[]{"Gorgonzola"}), "Gorgonzola is here!");
    }
}

