/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.runtime.functions;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.Before;
import org.junit.Test;
import org.kie.dmn.feel.runtime.events.InvalidParametersEvent;
import org.kie.dmn.feel.runtime.functions.AppendFunction;
import org.kie.dmn.feel.runtime.functions.FEELFnResult;
import org.kie.dmn.feel.runtime.functions.FunctionTestUtil;

public class AppendFunctionTest {
    private AppendFunction appendFunction;

    @Before
    public void setUp() {
        this.appendFunction = new AppendFunction();
    }

    @Test
    public void invokeInvalidParams() {
        FunctionTestUtil.assertResultError(this.appendFunction.invoke((List)null, null), InvalidParametersEvent.class);
        FunctionTestUtil.assertResultError(this.appendFunction.invoke((List)null, new Object[0]), InvalidParametersEvent.class);
        FunctionTestUtil.assertResultError(this.appendFunction.invoke(Collections.emptyList(), null), InvalidParametersEvent.class);
    }

    @Test
    public void invokeEmptyParams() {
        FunctionTestUtil.assertResultList((FEELFnResult<List>)this.appendFunction.invoke(Collections.emptyList(), new Object[0]), Collections.emptyList());
    }

    @Test
    public void invokeAppendNothing() {
        FunctionTestUtil.assertResultList((FEELFnResult<List>)this.appendFunction.invoke(Arrays.asList("test"), new Object[0]), Arrays.asList("test"));
        FunctionTestUtil.assertResultList((FEELFnResult<List>)this.appendFunction.invoke(Arrays.asList("test", "test2"), new Object[0]), Arrays.asList("test", "test2"));
    }

    @Test
    public void invokeAppendSomething() {
        FunctionTestUtil.assertResultList((FEELFnResult<List>)this.appendFunction.invoke(Collections.emptyList(), new Object[]{"test"}), Arrays.asList("test"));
        FunctionTestUtil.assertResultList((FEELFnResult<List>)this.appendFunction.invoke(Arrays.asList("test"), new Object[]{"test2"}), Arrays.asList("test", "test2"));
        FunctionTestUtil.assertResultList((FEELFnResult<List>)this.appendFunction.invoke(Arrays.asList("test"), new Object[]{"test2", "test3"}), Arrays.asList("test", "test2", "test3"));
    }
}

