/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.runtime.functions.twovaluelogic;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.Before;
import org.junit.Test;
import org.kie.dmn.feel.runtime.events.InvalidParametersEvent;
import org.kie.dmn.feel.runtime.functions.FunctionTestUtil;
import org.kie.dmn.feel.runtime.functions.twovaluelogic.NNMedianFunction;

public class MedianFunctionTest {
    private NNMedianFunction medianFunction;

    @Before
    public void setUp() {
        this.medianFunction = NNMedianFunction.INSTANCE;
    }

    @Test
    public void invokeListNull() {
        FunctionTestUtil.assertResult(this.medianFunction.invoke((List)null), null);
    }

    @Test
    public void invokeListEmpty() {
        FunctionTestUtil.assertResult(this.medianFunction.invoke(Collections.emptyList()), null);
    }

    @Test
    public void invokeListTypeHeterogenous() {
        FunctionTestUtil.assertResultError(this.medianFunction.invoke(Arrays.asList(1, "test")), InvalidParametersEvent.class);
    }

    @Test
    public void invokeListParamSupportedTypesWithNull() {
        FunctionTestUtil.assertResult(this.medianFunction.invoke(Arrays.asList(20, 30, null, 40L, null, BigDecimal.TEN)), BigDecimal.valueOf(25L));
    }

    @Test
    public void invokeListWithIntegers() {
        FunctionTestUtil.assertResult(this.medianFunction.invoke(Arrays.asList(10, 20, 30)), BigDecimal.valueOf(20L));
        FunctionTestUtil.assertResult(this.medianFunction.invoke(Arrays.asList(10, 20, 30, -10, -20, -30)), BigDecimal.ZERO);
        FunctionTestUtil.assertResult(this.medianFunction.invoke(Arrays.asList(0, 0, 1)), BigDecimal.ZERO);
    }

    @Test
    public void invokeListWithDoubles() {
        FunctionTestUtil.assertResult(this.medianFunction.invoke(Arrays.asList(10.0, 20.0, 30.0)), BigDecimal.valueOf(20L));
        FunctionTestUtil.assertResult(this.medianFunction.invoke(Arrays.asList(10.2, 20.2, 30.2)), BigDecimal.valueOf(20.2));
    }

    @Test
    public void invokeArrayNull() {
        FunctionTestUtil.assertResult(this.medianFunction.invoke((Object[])null), null);
    }

    @Test
    public void invokeArrayEmpty() {
        FunctionTestUtil.assertResult(this.medianFunction.invoke(new Object[0]), null);
    }

    @Test
    public void invokeArrayTypeHeterogenous() {
        FunctionTestUtil.assertResultError(this.medianFunction.invoke(new Object[]{1, "test"}), InvalidParametersEvent.class);
    }

    @Test
    public void invokeArrayWithIntegers() {
        FunctionTestUtil.assertResult(this.medianFunction.invoke(new Object[]{10, 20, 30}), BigDecimal.valueOf(20L));
        FunctionTestUtil.assertResult(this.medianFunction.invoke(new Object[]{10, 20, 30, -10, -20, -30}), BigDecimal.ZERO);
        FunctionTestUtil.assertResult(this.medianFunction.invoke(new Object[]{0, 0, 1}), BigDecimal.ZERO);
    }

    @Test
    public void invokeArrayWithDoubles() {
        FunctionTestUtil.assertResult(this.medianFunction.invoke(new Object[]{10.0, 20.0, 30.0}), BigDecimal.valueOf(20L));
        FunctionTestUtil.assertResult(this.medianFunction.invoke(new Object[]{10.2, 20.2, 30.2}), BigDecimal.valueOf(20.2));
    }

    @Test
    public void invokeArrayParamSupportedTypesWithNull() {
        FunctionTestUtil.assertResult(this.medianFunction.invoke(new Object[]{20, 30, null, 40L, null, BigDecimal.TEN}), BigDecimal.valueOf(25L));
    }
}

