/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.runtime.functions;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAmount;
import org.junit.Before;
import org.junit.Test;
import org.kie.dmn.feel.lang.types.impl.ComparablePeriod;
import org.kie.dmn.feel.runtime.events.InvalidParametersEvent;
import org.kie.dmn.feel.runtime.functions.DurationFunction;
import org.kie.dmn.feel.runtime.functions.FunctionTestUtil;

public class DurationFunctionTest {
    private DurationFunction durationFunction;

    @Before
    public void setUp() {
        this.durationFunction = new DurationFunction();
    }

    @Test
    public void invokeParamStringNull() {
        FunctionTestUtil.assertResultError(this.durationFunction.invoke((String)null), InvalidParametersEvent.class);
    }

    @Test
    public void invokeParamStringInvalid() {
        FunctionTestUtil.assertResultError(this.durationFunction.invoke("test"), InvalidParametersEvent.class);
        FunctionTestUtil.assertResultError(this.durationFunction.invoke("test HHH"), InvalidParametersEvent.class);
        FunctionTestUtil.assertResultError(this.durationFunction.invoke("testP2Y3D"), InvalidParametersEvent.class);
        FunctionTestUtil.assertResultError(this.durationFunction.invoke("test P2Y3D"), InvalidParametersEvent.class);
        FunctionTestUtil.assertResultError(this.durationFunction.invoke("P2Y3DD"), InvalidParametersEvent.class);
        FunctionTestUtil.assertResultError(this.durationFunction.invoke("P3DD"), InvalidParametersEvent.class);
        FunctionTestUtil.assertResultError(this.durationFunction.invoke("PT3HH"), InvalidParametersEvent.class);
        FunctionTestUtil.assertResultError(this.durationFunction.invoke("P2Y3M4DT3H"), InvalidParametersEvent.class);
    }

    @Test
    public void invokeParamStringDuration() {
        FunctionTestUtil.assertResult(this.durationFunction.invoke("P2D"), Duration.of(2L, ChronoUnit.DAYS));
        FunctionTestUtil.assertResult(this.durationFunction.invoke("P2DT3H"), Duration.of(2L, ChronoUnit.DAYS).plusHours(3L));
        FunctionTestUtil.assertResult(this.durationFunction.invoke("P2DT3H28M"), Duration.of(2L, ChronoUnit.DAYS).plusHours(3L).plusMinutes(28L));
        FunctionTestUtil.assertResult(this.durationFunction.invoke("P2DT3H28M15S"), Duration.of(2L, ChronoUnit.DAYS).plusHours(3L).plusMinutes(28L).plusSeconds(15L));
    }

    @Test
    public void invokeParamStringPeriod() {
        FunctionTestUtil.assertResult(this.durationFunction.invoke("P2Y3M"), ComparablePeriod.of((int)2, (int)3, (int)0));
        FunctionTestUtil.assertResult(this.durationFunction.invoke("P2Y3M4D"), ComparablePeriod.of((int)2, (int)3, (int)4));
    }

    @Test
    public void invokeParamTemporalAmountNull() {
        FunctionTestUtil.assertResultError(this.durationFunction.invoke((TemporalAmount)null), InvalidParametersEvent.class);
    }

    @Test
    public void invokeParamTemporalDuration() {
        FunctionTestUtil.assertResult(this.durationFunction.invoke((TemporalAmount)Duration.parse("P2DT3H28M15S")), Duration.of(2L, ChronoUnit.DAYS).plusHours(3L).plusMinutes(28L).plusSeconds(15L));
    }

    @Test
    public void invokeParamTemporalPeriod() {
        FunctionTestUtil.assertResult(this.durationFunction.invoke((TemporalAmount)ComparablePeriod.parse((CharSequence)"P2Y3M4D")), ComparablePeriod.of((int)2, (int)3, (int)4));
    }
}

