/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.runtime;

import java.math.BigDecimal;
import java.util.Collection;
import org.junit.runners.Parameterized;
import org.kie.dmn.api.feel.runtime.events.FEELEvent;
import org.kie.dmn.feel.runtime.BaseFEELTest;

public class FEELFunctionDefinitionTest
extends BaseFEELTest {
    @Parameterized.Parameters(name="{3}: {0} ({1}) = {2}")
    public static Collection<Object[]> data() {
        Object[][] cases = new Object[][]{{"{ hello : function() \"Hello World!\"}.hello()", "Hello World!", null}, {"{ hello : function(n) \"Hello \"+n+\"!\"}.hello(\"John\")", "Hello John!", null}, {"{ hello world : function() \"Hello World!\", message : hello world() }.message", "Hello World!", null}, {"{ functioncontext: { innercontext: {hello world : function() \"Hello World!\"}},  message : functioncontext.innercontext.hello world() }.message", "Hello World!", null}, {"{ hello world : function() \"Hello World!\", message : helloWorld() }.message", null, FEELEvent.Severity.ERROR}, {"{ is minor : function( person's age ) person's age < 18, bob is minor : is minor( 16 ) }.bob is minor", Boolean.TRUE, null}, {"{ is minor : function( person's age ) person's age < 18, bob is minor : is minor( 16, 24 ) }.bob is minor", null, FEELEvent.Severity.ERROR}, {"{ abs : function( v1 ) external { java : { class : \"java.lang.Math\", method signature: \"abs(double)\" } }, absolute : abs( -10.1 ) }.absolute", BigDecimal.valueOf(10.1), null}, {"{ abs : function( v1 ) external { java : { class : \"java.lang.Math\", method signature: \"abs(float)\" } }, absolute : abs( -10.1 ) }.absolute", BigDecimal.valueOf(10.1), null}, {"{ abs : function( v1 ) external { java : { class : \"java.lang.Math\", method signature: \"abs(int)\" } }, absolute : abs( -10 ) }.absolute", BigDecimal.valueOf(10L), null}, {"{ compare shorts : function( v1, v2 ) external { java : { class : \"java.lang.Short\", method signature: \"compare(short,short)\" } }, compareResult : compare shorts( 10, 10 ) }.compareResult", BigDecimal.valueOf(0L), null}, {"{ compare bytes : function( v1, v2 ) external { java : { class : \"java.lang.Byte\", method signature: \"compare(byte,byte)\" } }, compareResult : compare bytes( 10, 10 ) }.compareResult", BigDecimal.valueOf(0L), null}, {"{ compare chars : function( v1, v2 ) external { java : { class : \"java.lang.Character\", method signature: \"compare(char,char)\" } }, compareResult : compare chars( \"a\", \"a\" ) }.compareResult", BigDecimal.valueOf(0L), null}, {"{ compare booleans : function( v1, v2 ) external { java : { class : \"java.lang.Boolean\", method signature: \"compare(boolean,boolean)\" } }, compareResult : compare booleans( true, true ) }.compareResult", BigDecimal.valueOf(0L), null}, {"{ maximum : function( v1, v2 ) external { java : { class : \"java.lang.Math\", method signature: \"max(long,long)\" } }, the max : maximum( 10, 20 ) }.the max", BigDecimal.valueOf(20L), null}, {"{ maximum : function( v1, v2 ) external { java : { class : \"java.lang.Math\", method signature: \"max(long,long,int)\" } }, the max : maximum( 10, 20 ) }.the max", null, FEELEvent.Severity.ERROR}, {"{ maximum : function( v1, v2 ) external { java : { class : \"java.lang.Math\", method signature: \"maxX(long,long,int)\" } }, the max : maximum( 10, 20 ) }.the max", null, FEELEvent.Severity.ERROR}, {"{ maximum : function( v1, v2 ) external { }, the max : maximum( 10, 20 ) }.the max", null, FEELEvent.Severity.ERROR}, {"{ maximum : function( v1, v2 ) external { missingDefiniton }, the max : maximum( 10, 20 ) }.the max", null, FEELEvent.Severity.ERROR}, {"{ maximum : function( v1, v2 ) external { missingDefiniton : }, the max : maximum( 10, 20 ) }.the max", null, FEELEvent.Severity.ERROR}, {"{ \n    string format : function( mask, value ) external {\n                      java : {\n                          class : \"java.lang.String\",\n                          method signature : \"format( java.lang.String, [Ljava.lang.Object; )\"\n                      }\n                  },\n    format currency : function( amount ) \n                 string format( \"$%,4.2f\", amount )\n    ,\n   result : format currency( 76499.3456 )\n}.result", "$76,499.35", null}, {"{ myimport : { f1 : function() \"Hi\", x1 : function(name) f1() + \" \" + name }, r1 : myimport.x1(\"John\") }.r1", "Hi John", null}, {"{ myimport : { f1 : function() \"Hi\", f2 : function() f1() + \" \" , x1 : function(name) f2() + name }, r1 : myimport.x1(\"John\") }.r1", "Hi John", null}, {"{ m : { n : { o : { f1 : function() \"Hi\", f2 : function() f1() + \" \" , x1 : function(name) f2() + name }}}, r1 : m.n.o.x1(\"John\") }.r1", "Hi John", null}, {"{ m : { n : { f1 : function() \"Hi\", f2 : function() f1() + \" \" , o : { x1 : function(name) f2() + name }}}, r1 : m.n.o.x1(\"John\") }.r1", "Hi John", null}, {"{ m : { n : { f1 : function() \"Hi\", f2 : function() f1() + \" \" , o : { x1 : function(name) f2() + name }}}, r2 : m.n.f1() }.r2", "Hi", null}};
        return FEELFunctionDefinitionTest.addAdditionalParameters(cases, false);
    }
}

