/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.codegen.feel11;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.tree.ParseTree;
import org.drools.javaparser.ast.expr.Expression;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.kie.dmn.feel.codegen.feel11.CodegenTestUtil;
import org.kie.dmn.feel.codegen.feel11.CompiledCustomFEELFunction;
import org.kie.dmn.feel.codegen.feel11.CompiledFEELExpression;
import org.kie.dmn.feel.codegen.feel11.CompilerBytecodeLoader;
import org.kie.dmn.feel.codegen.feel11.DirectCompilerResult;
import org.kie.dmn.feel.codegen.feel11.DirectCompilerVisitor;
import org.kie.dmn.feel.lang.EvaluationContext;
import org.kie.dmn.feel.lang.FEELProperty;
import org.kie.dmn.feel.lang.Type;
import org.kie.dmn.feel.lang.impl.JavaBackedType;
import org.kie.dmn.feel.lang.impl.MapBackedType;
import org.kie.dmn.feel.lang.types.BuiltInType;
import org.kie.dmn.feel.parser.feel11.FEELParser;
import org.kie.dmn.feel.parser.feel11.FEEL_1_1Parser;
import org.kie.dmn.feel.util.DynamicTypeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectCompilerTest {
    public static final Logger LOG = LoggerFactory.getLogger(DirectCompilerTest.class);

    private Object parseCompileEvaluate(String feelLiteralExpression) {
        CompiledFEELExpression compiledExpression = this.parse(feelLiteralExpression);
        LOG.debug("{}", (Object)compiledExpression);
        EvaluationContext emptyContext = CodegenTestUtil.newEmptyEvaluationContext();
        Object result = compiledExpression.apply((Object)emptyContext);
        LOG.debug("{}", result);
        return result;
    }

    @Test
    public void test_FEEL_number() {
        Assert.assertThat((Object)this.parseCompileEvaluate("10"), (Matcher)CoreMatchers.is((Object)BigDecimal.valueOf(10L)));
    }

    @Test
    public void test_FEEL_negative_number() {
        Assert.assertThat((Object)this.parseCompileEvaluate("-10"), (Matcher)CoreMatchers.is((Object)BigDecimal.valueOf(-10L)));
    }

    @Test
    public void test_FEEL_DROOLS_2143() {
        Assert.assertThat((Object)this.parseCompileEvaluate("--10"), (Matcher)CoreMatchers.is((Object)BigDecimal.valueOf(10L)));
        Assert.assertThat((Object)this.parseCompileEvaluate("---10"), (Matcher)CoreMatchers.is((Object)BigDecimal.valueOf(-10L)));
        Assert.assertThat((Object)this.parseCompileEvaluate("+10"), (Matcher)CoreMatchers.is((Object)BigDecimal.valueOf(10L)));
    }

    @Test
    public void test_FEEL_boolean() {
        Assert.assertThat((Object)this.parseCompileEvaluate("false"), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)this.parseCompileEvaluate("true"), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)this.parseCompileEvaluate("null"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_FEEL_null() {
        Assert.assertThat((Object)this.parseCompileEvaluate("null"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_FEEL_string() {
        Assert.assertThat((Object)this.parseCompileEvaluate("\"some string\""), (Matcher)CoreMatchers.is((Object)"some string"));
    }

    @Test
    public void test_primary_parens() {
        Assert.assertThat((Object)this.parseCompileEvaluate("(\"some string\")"), (Matcher)CoreMatchers.is((Object)"some string"));
        Assert.assertThat((Object)this.parseCompileEvaluate("(123)"), (Matcher)CoreMatchers.is((Object)BigDecimal.valueOf(123L)));
        Assert.assertThat((Object)this.parseCompileEvaluate("(-123)"), (Matcher)CoreMatchers.is((Object)BigDecimal.valueOf(-123L)));
        Assert.assertThat((Object)this.parseCompileEvaluate("-(123)"), (Matcher)CoreMatchers.is((Object)BigDecimal.valueOf(-123L)));
        Assert.assertThat((Object)this.parseCompileEvaluate("(false)"), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)this.parseCompileEvaluate("(true)"), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void test_ternary_logic() {
        Assert.assertThat((Object)this.parseCompileEvaluate("true and true"), (Matcher)CoreMatchers.is((Object)Boolean.TRUE));
        Assert.assertThat((Object)this.parseCompileEvaluate("true and false"), (Matcher)CoreMatchers.is((Object)Boolean.FALSE));
        Assert.assertThat((Object)this.parseCompileEvaluate("true and null"), (Matcher)CoreMatchers.nullValue());
        Assert.assertThat((Object)this.parseCompileEvaluate("false and true"), (Matcher)CoreMatchers.is((Object)Boolean.FALSE));
        Assert.assertThat((Object)this.parseCompileEvaluate("false and false"), (Matcher)CoreMatchers.is((Object)Boolean.FALSE));
        Assert.assertThat((Object)this.parseCompileEvaluate("false and null"), (Matcher)CoreMatchers.is((Object)Boolean.FALSE));
        Assert.assertThat((Object)this.parseCompileEvaluate("null and true"), (Matcher)CoreMatchers.nullValue());
        Assert.assertThat((Object)this.parseCompileEvaluate("null and false"), (Matcher)CoreMatchers.is((Object)Boolean.FALSE));
        Assert.assertThat((Object)this.parseCompileEvaluate("null and null"), (Matcher)CoreMatchers.nullValue());
        Assert.assertThat((Object)this.parseCompileEvaluate("true or true"), (Matcher)CoreMatchers.is((Object)Boolean.TRUE));
        Assert.assertThat((Object)this.parseCompileEvaluate("true or false"), (Matcher)CoreMatchers.is((Object)Boolean.TRUE));
        Assert.assertThat((Object)this.parseCompileEvaluate("true or null"), (Matcher)CoreMatchers.is((Object)Boolean.TRUE));
        Assert.assertThat((Object)this.parseCompileEvaluate("false or true"), (Matcher)CoreMatchers.is((Object)Boolean.TRUE));
        Assert.assertThat((Object)this.parseCompileEvaluate("false or false"), (Matcher)CoreMatchers.is((Object)Boolean.FALSE));
        Assert.assertThat((Object)this.parseCompileEvaluate("false or null"), (Matcher)CoreMatchers.nullValue());
        Assert.assertThat((Object)this.parseCompileEvaluate("null or true"), (Matcher)CoreMatchers.is((Object)Boolean.TRUE));
        Assert.assertThat((Object)this.parseCompileEvaluate("null or false"), (Matcher)CoreMatchers.nullValue());
        Assert.assertThat((Object)this.parseCompileEvaluate("null or null"), (Matcher)CoreMatchers.nullValue());
        Assert.assertThat((Object)this.parseCompileEvaluate("false and false or true"), (Matcher)CoreMatchers.is((Object)Boolean.TRUE));
        Assert.assertThat((Object)this.parseCompileEvaluate("false and (false or true)"), (Matcher)CoreMatchers.is((Object)Boolean.FALSE));
        Assert.assertThat((Object)this.parseCompileEvaluate("true or false and false"), (Matcher)CoreMatchers.is((Object)Boolean.TRUE));
        Assert.assertThat((Object)this.parseCompileEvaluate("(true or false) and false"), (Matcher)CoreMatchers.is((Object)Boolean.FALSE));
    }

    @Test
    public void test_if() {
        Assert.assertThat((Object)this.parseCompileEvaluate("if true then 15 else 5"), (Matcher)CoreMatchers.is((Object)BigDecimal.valueOf(15L)));
        Assert.assertThat((Object)this.parseCompileEvaluate("if false then 15 else 5"), (Matcher)CoreMatchers.is((Object)BigDecimal.valueOf(5L)));
        Assert.assertThat((Object)this.parseCompileEvaluate("if null then 15 else 5"), (Matcher)CoreMatchers.is((Object)BigDecimal.valueOf(5L)));
        Assert.assertThat((Object)this.parseCompileEvaluate("if \"hello\" then 15 else 5"), (Matcher)CoreMatchers.is((Object)BigDecimal.valueOf(5L)));
    }

    @Test
    public void test_additiveExpression() {
        Assert.assertThat((Object)this.parseCompileEvaluate("1 + 2"), (Matcher)CoreMatchers.is((Object)BigDecimal.valueOf(3L)));
        Assert.assertThat((Object)this.parseCompileEvaluate("1 + null"), (Matcher)CoreMatchers.nullValue());
        Assert.assertThat((Object)this.parseCompileEvaluate("1 - 2"), (Matcher)CoreMatchers.is((Object)BigDecimal.valueOf(-1L)));
        Assert.assertThat((Object)this.parseCompileEvaluate("1 - null"), (Matcher)CoreMatchers.nullValue());
        Assert.assertThat((Object)this.parseCompileEvaluate("\"Hello, \" + \"World\""), (Matcher)CoreMatchers.is((Object)"Hello, World"));
    }

    @Test
    public void test_multiplicativeExpression() {
        Assert.assertThat((Object)this.parseCompileEvaluate("3 * 5"), (Matcher)CoreMatchers.is((Object)BigDecimal.valueOf(15L)));
        Assert.assertThat((Object)this.parseCompileEvaluate("3 * null"), (Matcher)CoreMatchers.nullValue());
        Assert.assertThat((Object)this.parseCompileEvaluate("10 / 2"), (Matcher)CoreMatchers.is((Object)BigDecimal.valueOf(5L)));
        Assert.assertThat((Object)this.parseCompileEvaluate("10 / null"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_exponentiationExpression() {
        Assert.assertThat((Object)this.parseCompileEvaluate("3 ** 3"), (Matcher)CoreMatchers.is((Object)BigDecimal.valueOf(27L)));
        Assert.assertThat((Object)this.parseCompileEvaluate("3 ** null"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_logicalNegationExpression() {
        Assert.assertThat((Object)this.parseCompileEvaluate("not true"), (Matcher)CoreMatchers.nullValue());
        Assert.assertThat((Object)this.parseCompileEvaluate("not false"), (Matcher)CoreMatchers.nullValue());
        Assert.assertThat((Object)this.parseCompileEvaluate("not null"), (Matcher)CoreMatchers.nullValue());
        Assert.assertThat((Object)this.parseCompileEvaluate("not 3"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_listExpression() {
        Assert.assertThat((Object)this.parseCompileEvaluate("[]"), (Matcher)CoreMatchers.is(Collections.emptyList()));
        Assert.assertThat((Object)this.parseCompileEvaluate("[ ]"), (Matcher)CoreMatchers.is(Collections.emptyList()));
        Assert.assertThat((Object)this.parseCompileEvaluate("[1]"), (Matcher)CoreMatchers.is(Arrays.asList(BigDecimal.valueOf(1L))));
        Assert.assertThat((Object)this.parseCompileEvaluate("[1, 2,3]"), (Matcher)CoreMatchers.is(Arrays.asList(BigDecimal.valueOf(1L), BigDecimal.valueOf(2L), BigDecimal.valueOf(3L))));
    }

    @Test
    public void test_instanceOfExpression() {
        Assert.assertThat((Object)this.parseCompileEvaluate("123 instance of number"), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)this.parseCompileEvaluate("\"ciao\" instance of number"), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)this.parseCompileEvaluate("123 instance of string"), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)this.parseCompileEvaluate("\"ciao\" instance of string"), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void test_between() {
        Assert.assertThat((Object)this.parseCompileEvaluate("10 between 5 and 12"), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)this.parseCompileEvaluate("10 between 20 and 30"), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)this.parseCompileEvaluate("10 between 20 and \"foo\""), (Matcher)CoreMatchers.nullValue());
        Assert.assertThat((Object)this.parseCompileEvaluate("\"foo\" between 5 and 12"), (Matcher)CoreMatchers.nullValue());
        Assert.assertThat((Object)this.parseCompileEvaluate("\"foo\" between \"bar\" and \"zap\""), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)this.parseCompileEvaluate("\"foo\" between null and \"zap\""), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_filterPath() {
        Assert.assertThat((Object)this.parseCompileEvaluate("[\"a\", \"b\", \"c\"][1]"), (Matcher)CoreMatchers.is((Object)"a"));
        Assert.assertThat((Object)this.parseCompileEvaluate("[\"a\", \"b\", \"c\"][2]"), (Matcher)CoreMatchers.is((Object)"b"));
        Assert.assertThat((Object)this.parseCompileEvaluate("[\"a\", \"b\", \"c\"][3]"), (Matcher)CoreMatchers.is((Object)"c"));
        Assert.assertThat((Object)this.parseCompileEvaluate("[\"a\", \"b\", \"c\"][-1]"), (Matcher)CoreMatchers.is((Object)"c"));
        Assert.assertThat((Object)this.parseCompileEvaluate("[\"a\", \"b\", \"c\"][-2]"), (Matcher)CoreMatchers.is((Object)"b"));
        Assert.assertThat((Object)this.parseCompileEvaluate("[\"a\", \"b\", \"c\"][-3]"), (Matcher)CoreMatchers.is((Object)"a"));
        Assert.assertThat((Object)this.parseCompileEvaluate("[\"a\", \"b\", \"c\"][4]"), (Matcher)CoreMatchers.nullValue());
        Assert.assertThat((Object)this.parseCompileEvaluate("[\"a\", \"b\", \"c\"][984]"), (Matcher)CoreMatchers.nullValue());
        Assert.assertThat((Object)this.parseCompileEvaluate("[\"a\", \"b\", \"c\"][-4]"), (Matcher)CoreMatchers.nullValue());
        Assert.assertThat((Object)this.parseCompileEvaluate("[\"a\", \"b\", \"c\"][-984]"), (Matcher)CoreMatchers.nullValue());
        Assert.assertThat((Object)this.parseCompileEvaluate("\"a\"[1]"), (Matcher)CoreMatchers.is((Object)"a"));
        Assert.assertThat((Object)this.parseCompileEvaluate("\"a\"[2]"), (Matcher)CoreMatchers.nullValue());
        Assert.assertThat((Object)this.parseCompileEvaluate("\"a\"[-1]"), (Matcher)CoreMatchers.is((Object)"a"));
        Assert.assertThat((Object)this.parseCompileEvaluate("\"a\"[-2]"), (Matcher)CoreMatchers.nullValue());
        Assert.assertThat((Object)this.parseCompileEvaluate("[1, 2, 3, 4][item = 4]"), (Matcher)CoreMatchers.is(Arrays.asList(BigDecimal.valueOf(4L))));
        Assert.assertThat((Object)this.parseCompileEvaluate("[1, 2, 3, 4][item > 2]"), (Matcher)CoreMatchers.is(Arrays.asList(BigDecimal.valueOf(3L), BigDecimal.valueOf(4L))));
        Assert.assertThat((Object)this.parseCompileEvaluate("[1, 2, 3, 4][item > 5]"), (Matcher)CoreMatchers.is(Collections.emptyList()));
        Assert.assertThat((Object)this.parseCompileEvaluate("[ {x:1, y:2}, {x:2, y:3} ][x = 1]"), (Matcher)CoreMatchers.is(Arrays.asList(DynamicTypeUtils.mapOf(DynamicTypeUtils.entry("x", new BigDecimal(1)), DynamicTypeUtils.entry("y", new BigDecimal(2))))));
        Assert.assertThat((Object)this.parseCompileEvaluate("[ {x:1, y:2}, {x:2, y:3} ][x > 1]"), (Matcher)CoreMatchers.is(Arrays.asList(DynamicTypeUtils.mapOf(DynamicTypeUtils.entry("x", new BigDecimal(2)), DynamicTypeUtils.entry("y", new BigDecimal(3))))));
        Assert.assertThat((Object)this.parseCompileEvaluate("[ {x:1, y:2}, {x:2, y:3} ][x = 0]"), (Matcher)CoreMatchers.is(Collections.emptyList()));
    }

    @Test
    public void test_filterPath_tricky1() {
        CompiledFEELExpression nameRef = this.parse("[ {x:1, y:2}, {x:2, y:3} ][x]");
        LOG.debug("{}", (Object)nameRef);
        EvaluationContext context = CodegenTestUtil.newEmptyEvaluationContext();
        context.setValue("x", (Object)2);
        Object result = nameRef.apply((Object)context);
        LOG.debug("{}", result);
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.is(DynamicTypeUtils.mapOf(DynamicTypeUtils.entry("x", new BigDecimal(2)), DynamicTypeUtils.entry("y", new BigDecimal(3)))));
    }

    @Test
    public void test_filterPath_tricky2() {
        CompiledFEELExpression nameRef = this.parse("[ {x:1, y:2}, {x:2, y:3} ][x]");
        LOG.debug("{}", (Object)nameRef);
        EvaluationContext context = CodegenTestUtil.newEmptyEvaluationContext();
        context.setValue("x", (Object)false);
        Object result = nameRef.apply((Object)context);
        LOG.debug("{}", result);
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.is(Collections.emptyList()));
    }

    @Test
    public void test_filterPathSelection() {
        Assert.assertThat((Object)this.parseCompileEvaluate("[ {x:1, y:2}, {x:2, y:3} ].y"), (Matcher)CoreMatchers.is(Arrays.asList(BigDecimal.valueOf(2L), BigDecimal.valueOf(3L))));
        Assert.assertThat((Object)this.parseCompileEvaluate("[ {x:1, y:2}, {x:2} ].y"), (Matcher)CoreMatchers.is(Arrays.asList(BigDecimal.valueOf(2L))));
        Assert.assertThat((Object)this.parseCompileEvaluate("[ {x:1, y:2}, {x:2, y:3} ].z"), (Matcher)CoreMatchers.is(Collections.emptyList()));
    }

    @Test
    public void test_for() {
        Assert.assertThat((Object)this.parseCompileEvaluate("for x in [ 10, 20, 30 ], y in [ 1, 2, 3 ] return x * y"), (Matcher)CoreMatchers.is(Arrays.asList(10, 20, 30, 20, 40, 60, 30, 60, 90).stream().map(x -> BigDecimal.valueOf(x.intValue())).collect(Collectors.toList())));
        Assert.assertThat((Object)this.parseCompileEvaluate("for x in [1, 2, 3] return x+1"), (Matcher)CoreMatchers.is(Arrays.asList(1, 2, 3).stream().map(x -> BigDecimal.valueOf(x + 1)).collect(Collectors.toList())));
    }

    @Test
    public void test_quantifiedExpressions() {
        Assert.assertThat((Object)this.parseCompileEvaluate("some price in [ 80, 11, 110 ] satisfies price > 100"), (Matcher)CoreMatchers.is((Object)Boolean.TRUE));
        Assert.assertThat((Object)this.parseCompileEvaluate("some price in [ 80, 11, 90 ] satisfies price > 100"), (Matcher)CoreMatchers.is((Object)Boolean.FALSE));
        Assert.assertThat((Object)this.parseCompileEvaluate("some x in [ 5, 6, 7 ], y in [ 10, 11, 6 ] satisfies x > y"), (Matcher)CoreMatchers.is((Object)Boolean.TRUE));
        Assert.assertThat((Object)this.parseCompileEvaluate("every price in [ 80, 11, 90 ] satisfies price > 10"), (Matcher)CoreMatchers.is((Object)Boolean.TRUE));
        Assert.assertThat((Object)this.parseCompileEvaluate("every price in [ 80, 11, 90 ] satisfies price > 70"), (Matcher)CoreMatchers.is((Object)Boolean.FALSE));
        Assert.assertThat((Object)this.parseCompileEvaluate("some x in [ 5, 6, 7 ], y in [ 10, 11, 12 ] satisfies x < y"), (Matcher)CoreMatchers.is((Object)Boolean.TRUE));
        Assert.assertThat((Object)this.parseCompileEvaluate("some price in [ 80, 11, 110 ] satisfies price > max(100, 50, 10)"), (Matcher)CoreMatchers.is((Object)Boolean.TRUE));
    }

    @Test
    public void test_basicFunctionInvocation() {
        Assert.assertThat((Object)this.parseCompileEvaluate("max(1, 2, 3)"), (Matcher)CoreMatchers.is((Object)new BigDecimal(3)));
    }

    @Test
    public void test_basicFunctionDefinition() {
        Assert.assertThat((Object)this.parseCompileEvaluate("function (a, b) a + b"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(CompiledCustomFEELFunction.class)));
        Assert.assertThat((Object)this.parseCompileEvaluate("{ s : function (a, b) a + b, x : 1, y : 2, r : s(x,y) }.r"), (Matcher)CoreMatchers.is((Object)new BigDecimal(3)));
    }

    @Test
    public void test_namedFunctionInvocation() {
        Assert.assertThat((Object)this.parseCompileEvaluate("substring(start position: 2, string: \"FOOBAR\")"), (Matcher)CoreMatchers.is((Object)"OOBAR"));
        Assert.assertThat((Object)this.parseCompileEvaluate("ceiling( n : 1.5 )"), (Matcher)CoreMatchers.is((Object)new BigDecimal("2")));
    }

    @Test
    public void test_Misc_fromOriginalFEELInterpretedTestSuite() {
        Assert.assertThat((Object)this.parseCompileEvaluate("if null then \"foo\" else \"bar\""), (Matcher)CoreMatchers.is((Object)"bar"));
        Assert.assertThat((Object)this.parseCompileEvaluate("{ hello world : function() \"Hello World!\", message : hello world() }.message"), (Matcher)CoreMatchers.is((Object)"Hello World!"));
        Assert.assertThat((Object)this.parseCompileEvaluate("1 + if true then 1 else 2"), (Matcher)CoreMatchers.is((Object)new BigDecimal("2")));
        Assert.assertThat((Object)this.parseCompileEvaluate("\"string with \\\"quotes\\\"\""), (Matcher)CoreMatchers.is((Object)"string with \"quotes\""));
        Assert.assertThat((Object)this.parseCompileEvaluate("date( -0105, 8, 2 )"), (Matcher)CoreMatchers.is((Object)LocalDate.of(-105, 8, 2)));
        Assert.assertThat((Object)this.parseCompileEvaluate("string(null)"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)this.parseCompileEvaluate("[ null ]"), (Matcher)CoreMatchers.is(Arrays.asList(new Object[]{null})));
        Assert.assertThat((Object)this.parseCompileEvaluate("[ null, null ]"), (Matcher)CoreMatchers.is(Arrays.asList(null, null)));
        Assert.assertThat((Object)this.parseCompileEvaluate("[ null, 47, null ]"), (Matcher)CoreMatchers.is(Arrays.asList(null, BigDecimal.valueOf(47L), null)));
    }

    @Test
    public void test_Benchmark_feelExpressions() {
        Assert.assertThat((Object)this.parseCompileEvaluate("{ full name: { first name: \"John\", last name: \"Doe\" } }.full name.last name"), (Matcher)CoreMatchers.is((Object)"Doe"));
        Assert.assertThat((Object)this.parseCompileEvaluate("some price in [ 80, 11, 110 ] satisfies price > 100"), (Matcher)CoreMatchers.is((Object)Boolean.TRUE));
        Assert.assertThat((Object)this.parseCompileEvaluate("every price in [ 80, 11, 90 ] satisfies price > 10"), (Matcher)CoreMatchers.is((Object)Boolean.TRUE));
    }

    @Test
    public void test_contextExpression() {
        Assert.assertThat((Object)this.parseCompileEvaluate("{}"), (Matcher)CoreMatchers.is(Collections.emptyMap()));
        Assert.assertThat((Object)this.parseCompileEvaluate("{ }"), (Matcher)CoreMatchers.is(Collections.emptyMap()));
        Assert.assertThat((Object)this.parseCompileEvaluate("{ a : 1 }"), (Matcher)CoreMatchers.is(DynamicTypeUtils.mapOf(DynamicTypeUtils.entry("a", new BigDecimal(1)))));
        Assert.assertThat((Object)this.parseCompileEvaluate("{ \"a\" : 1 }"), (Matcher)CoreMatchers.is(DynamicTypeUtils.mapOf(DynamicTypeUtils.entry("a", new BigDecimal(1)))));
        Assert.assertThat((Object)this.parseCompileEvaluate("{ \" a\" : 1 }"), (Matcher)CoreMatchers.is(DynamicTypeUtils.mapOf(DynamicTypeUtils.entry(" a", new BigDecimal(1)))));
        Assert.assertThat((Object)this.parseCompileEvaluate("{ a : 1, b : 2, c : 3 }"), (Matcher)CoreMatchers.is(DynamicTypeUtils.mapOf(DynamicTypeUtils.entry("a", new BigDecimal(1)), DynamicTypeUtils.entry("b", new BigDecimal(2)), DynamicTypeUtils.entry("c", new BigDecimal(3)))));
        Assert.assertThat((Object)this.parseCompileEvaluate("{ a : 1, a name : \"John Doe\" }"), (Matcher)CoreMatchers.is(DynamicTypeUtils.mapOf(DynamicTypeUtils.entry("a", new BigDecimal(1)), DynamicTypeUtils.entry("a name", "John Doe"))));
        Assert.assertThat((Object)this.parseCompileEvaluate("{ a : 1, b : a }"), (Matcher)CoreMatchers.is(DynamicTypeUtils.mapOf(DynamicTypeUtils.entry("a", new BigDecimal(1)), DynamicTypeUtils.entry("b", new BigDecimal(1)))));
    }

    @Test
    public void testContextWithMultipleEntries() {
        String inputExpression = "{ \"a string key\" : 10,\n a non-string key : 11,\n a key.with + /' odd chars : 12 }";
        Assert.assertThat((Object)this.parseCompileEvaluate(inputExpression), (Matcher)CoreMatchers.is(DynamicTypeUtils.mapOf(DynamicTypeUtils.entry("a string key", new BigDecimal(10)), DynamicTypeUtils.entry("a non-string key", new BigDecimal(11)), DynamicTypeUtils.entry("a key.with + /' odd chars", new BigDecimal(12)))));
    }

    @Test
    public void testNestedContexts() {
        String inputExpression = "{ a value : 10,\n an applicant : { \n    first name : \"Edson\", \n    last + name : \"Tirelli\", \n    full name : first name + last + name, \n    address : {\n        street : \"55 broadway st\",\n        city : \"New York\" \n    }, \n    xxx: last + name\n } \n}";
        Assert.assertThat((Object)this.parseCompileEvaluate(inputExpression), (Matcher)CoreMatchers.is(DynamicTypeUtils.mapOf(DynamicTypeUtils.entry("a value", new BigDecimal(10)), DynamicTypeUtils.entry("an applicant", DynamicTypeUtils.mapOf(DynamicTypeUtils.entry("first name", "Edson"), DynamicTypeUtils.entry("last + name", "Tirelli"), DynamicTypeUtils.entry("full name", "EdsonTirelli"), DynamicTypeUtils.entry("address", DynamicTypeUtils.mapOf(DynamicTypeUtils.entry("street", "55 broadway st"), DynamicTypeUtils.entry("city", "New York"))), DynamicTypeUtils.entry("xxx", "Tirelli"))))));
    }

    @Test
    public void testNestedContexts2() {
        String complexContext = "{ an applicant : {                                \n    home address : {                              \n        street name: \"broadway st\",             \n        city : \"New York\"                       \n    }                                             \n   },                                             \n   street : an applicant.home address.street name \n}                                                 ";
        Assert.assertThat((Object)this.parseCompileEvaluate(complexContext), (Matcher)CoreMatchers.is(DynamicTypeUtils.mapOf(DynamicTypeUtils.entry("an applicant", DynamicTypeUtils.mapOf(DynamicTypeUtils.entry("home address", DynamicTypeUtils.mapOf(DynamicTypeUtils.entry("street name", "broadway st"), DynamicTypeUtils.entry("city", "New York"))))), DynamicTypeUtils.entry("street", "broadway st"))));
    }

    @Test
    public void testNameReference() {
        String inputExpression = "someSimpleName";
        CompiledFEELExpression nameRef = this.parse(inputExpression, DynamicTypeUtils.mapOf(DynamicTypeUtils.entry("someSimpleName", BuiltInType.STRING)));
        LOG.debug("{}", (Object)nameRef);
        EvaluationContext context = CodegenTestUtil.newEmptyEvaluationContext();
        context.setValue("someSimpleName", (Object)123L);
        Object result = nameRef.apply((Object)context);
        LOG.debug("{}", result);
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)BigDecimal.valueOf(123L)));
    }

    @Test
    public void testQualifiedName() {
        String inputExpression = "My Person.Full Name";
        MapBackedType personType = new MapBackedType("Person", DynamicTypeUtils.mapOf(DynamicTypeUtils.entry("Full Name", BuiltInType.STRING), DynamicTypeUtils.entry("Age", BuiltInType.NUMBER)));
        CompiledFEELExpression qualRef = this.parse(inputExpression, DynamicTypeUtils.mapOf(DynamicTypeUtils.entry("My Person", personType)));
        LOG.debug("{}", (Object)qualRef);
        EvaluationContext context = CodegenTestUtil.newEmptyEvaluationContext();
        context.setValue("My Person", DynamicTypeUtils.mapOf(DynamicTypeUtils.entry("Full Name", "John Doe"), DynamicTypeUtils.entry("Age", 47)));
        Object result = qualRef.apply((Object)context);
        LOG.debug("{}", result);
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)"John Doe"));
        CompiledFEELExpression personAgeExpression = this.parse("My Person.Age", DynamicTypeUtils.mapOf(DynamicTypeUtils.entry("My Person", personType)));
        LOG.debug("{}", (Object)personAgeExpression);
        Object resultPersonAge = personAgeExpression.apply((Object)context);
        LOG.debug("{}", resultPersonAge);
        Assert.assertThat((Object)resultPersonAge, (Matcher)CoreMatchers.is((Object)BigDecimal.valueOf(47L)));
    }

    @Test
    public void testQualifiedName2() {
        String inputExpression = "My Person.Full Name";
        Type personType = JavaBackedType.of(MyPerson.class);
        CompiledFEELExpression qualRef = this.parse(inputExpression, DynamicTypeUtils.mapOf(DynamicTypeUtils.entry("My Person", personType)));
        LOG.debug("{}", (Object)qualRef);
        EvaluationContext context = CodegenTestUtil.newEmptyEvaluationContext();
        context.setValue("My Person", (Object)new MyPerson());
        Object result = qualRef.apply((Object)context);
        LOG.debug("{}", result);
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)"John Doe"));
    }

    @Test
    public void testQualifiedName3() {
        String inputExpression = "a date.year";
        BuiltInType dateType = BuiltInType.DATE;
        CompiledFEELExpression qualRef = this.parse(inputExpression, DynamicTypeUtils.mapOf(DynamicTypeUtils.entry("a date", dateType)));
        LOG.debug("{}", (Object)qualRef);
        EvaluationContext context = CodegenTestUtil.newEmptyEvaluationContext();
        context.setValue("a date", (Object)LocalDate.of(2016, 8, 2));
        Object result = qualRef.apply((Object)context);
        LOG.debug("{}", result);
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)BigDecimal.valueOf(2016L)));
    }

    private CompiledFEELExpression parse(String input) {
        return this.parse(input, Collections.emptyMap());
    }

    private CompiledFEELExpression parse(String input, Map<String, Type> inputTypes) {
        FEEL_1_1Parser parser = FEELParser.parse(null, (String)input, inputTypes, Collections.emptyMap(), Collections.emptyList(), Collections.emptyList());
        FEEL_1_1Parser.Compilation_unitContext tree = parser.compilation_unit();
        DirectCompilerVisitor v = new DirectCompilerVisitor(inputTypes);
        DirectCompilerResult directResult = (DirectCompilerResult)v.visit((ParseTree)tree);
        Expression expr = directResult.getExpression();
        CompiledFEELExpression cu = new CompilerBytecodeLoader().makeFromJPExpression(input, expr, directResult.getFieldDeclarations());
        return cu;
    }

    public static class MyPerson {
        @FEELProperty(value="Full Name")
        public String getFullName() {
            return "John Doe";
        }
    }
}

